/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json;

import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.AbstractFileFieldHandler;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileFieldHandler;
import com.openexchange.file.storage.FileFieldSwitcher;
import com.openexchange.file.storage.meta.FileFieldSet;
import com.openexchange.file.storage.parse.FileMetadataParserService;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileMetadataParser
implements FileMetadataParserService {
    private static final FileMetadataParser instance = new FileMetadataParser();
    private final JSONParserHandler jsonHandler = new JSONParserHandler();

    public static FileMetadataParser getInstance() {
        return instance;
    }

    private FileMetadataParser() {
    }

    public File parse(JSONObject object) throws OXException {
        DefaultFile file = new DefaultFile();
        try {
            JSONObject purged = new JSONObject(object);
            if (purged.has("last_modified")) {
                purged.remove("last_modified");
            }
            File.Field.inject((FileFieldHandler)this.jsonHandler, (Object)file, (Object[])new Object[]{purged});
        }
        catch (RuntimeException x) {
            if (x.getCause() != null && JSONException.class.isInstance(x.getCause())) {
                throw AjaxExceptionCodes.JSON_ERROR.create(new Object[]{x.getCause().getMessage()});
            }
            throw x;
        }
        return file;
    }

    public List<File.Field> getFields(final JSONObject object) {
        return (List)File.Field.inject((FileFieldHandler)new AbstractFileFieldHandler(){

            public Object handle(File.Field field, Object ... args) {
                List fields = (List)args[0];
                if (object.has(field.getName())) {
                    fields.add(field);
                }
                return fields;
            }
        }, new ArrayList(), (Object[])new Object[0]);
    }

    private static final class JSONParserHandler
    extends AbstractFileFieldHandler {
        private final FileFieldSet set = new FileFieldSet();

        protected JSONParserHandler() {
        }

        public Object handle(File.Field field, Object ... args) {
            File md = this.md(args);
            JSONObject object = (JSONObject)this.get(1, JSONObject.class, args);
            if (!object.has(field.getName())) {
                return md;
            }
            try {
                Object value = object.get(field.getName());
                value = this.process(field, value);
                field.doSwitch((FileFieldSwitcher)this.set, new Object[]{md, value});
            }
            catch (JSONException x) {
                throw new RuntimeException(x);
            }
            return md;
        }

        private Object process(File.Field field, Object value) throws JSONException {
            Object val = value;
            if (val == JSONObject.NULL) {
                val = null;
            }
            switch (field) {
                case CATEGORIES: {
                    if (String.class.isInstance(val)) {
                        return val;
                    }
                    return this.categories((JSONArray)val);
                }
                case META: {
                    if (value == null || value == JSONObject.NULL) {
                        return null;
                    }
                    return JSONCoercion.coerceToNative((Object)value);
                }
            }
            return val;
        }

        private Object categories(JSONArray value) throws JSONException {
            if (value.length() == 0) {
                return "";
            }
            StringBuilder b = new StringBuilder();
            int size = value.length();
            for (int i = 0; i < size; ++i) {
                b.append(value.getString(i)).append(", ");
            }
            b.setLength(b.length() - 2);
            return b.toString();
        }
    }
}

