/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.json.FileMetadataWriter;
import com.openexchange.file.storage.json.actions.files.AJAXInfostoreRequest;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;

public class FileConverter
implements ResultConverter {
    private final FileMetadataWriter writer = new FileMetadataWriter();

    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        AJAXInfostoreRequest iReq = new AJAXInfostoreRequest(requestData, session);
        Object resultObject = result.getResultObject();
        if (resultObject instanceof File) {
            resultObject = this.writer.write((File)resultObject, iReq.getTimezone());
        } else if (resultObject instanceof SearchIterator) {
            SearchIterator iterator = (SearchIterator)resultObject;
            resultObject = this.writer.write((SearchIterator<File>)iterator, iReq.getColumns(), iReq.getTimezone());
        }
        result.setResultObject(resultObject);
    }

    public String getInputFormat() {
        return "infostore";
    }

    public String getOutputFormat() {
        return "json";
    }

    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }
}

