/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore.internal;

import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.infostore.Services;
import com.openexchange.file.storage.infostore.internal.TrashCleaner;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.login.LoginResult;
import com.openexchange.login.NonTransient;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;

public class TrashCleanupHandler
implements LoginHandlerService,
NonTransient {
    public void handleLogin(LoginResult loginResult) throws OXException {
        Session session = loginResult.getSession();
        int retentionDays = TrashCleanupHandler.getRetentionDays(session.getContextId(), session.getUserId());
        if (0 < retentionDays) {
            ServerSession serverSession = ServerSessionAdapter.valueOf((Session)session, (Context)loginResult.getContext(), (User)loginResult.getUser());
            if (!serverSession.getUserConfiguration().hasInfostore()) {
                return;
            }
            new TrashCleaner(serverSession, retentionDays).run();
        }
    }

    public void handleLogout(LoginResult logout) throws OXException {
    }

    private static int getRetentionDays(int contextID, int userID) throws OXException {
        ConfigViewFactory configViewFactory = Services.getService(ConfigViewFactory.class);
        if (null != configViewFactory) {
            ConfigView configView = configViewFactory.getView(userID, contextID);
            return (Integer)configView.opt("com.openexchange.infostore.trash.retentionDays", Integer.class, (Object)-1);
        }
        return -1;
    }
}

