/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.CapabilityAware;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageCapability;
import com.openexchange.file.storage.FileStorageCapabilityTools;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageFolderAccess;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.infostore.InfostoreAdapterFileAccess;
import com.openexchange.file.storage.infostore.InfostoreFileStorageService;
import com.openexchange.file.storage.infostore.InfostoreFolderAccess;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;

public class InfostoreAccountAccess
implements FileStorageAccountAccess,
CapabilityAware {
    private final ServerSession session;
    private final InfostoreFileStorageService service;
    private InfostoreFolderAccess folders;
    private InfostoreAdapterFileAccess files;

    public InfostoreAccountAccess(Session session, InfostoreFileStorageService service) throws OXException {
        this.session = ServerSessionAdapter.valueOf((Session)session);
        this.service = service;
    }

    public Boolean supports(FileStorageCapability capability) {
        return FileStorageCapabilityTools.supportsByClass(InfostoreAdapterFileAccess.class, (FileStorageCapability)capability);
    }

    public String getAccountId() {
        return "infostore";
    }

    public FileStorageFileAccess getFileAccess() throws OXException {
        if (this.files != null) {
            return this.files;
        }
        this.files = new InfostoreAdapterFileAccess(this.session, this.service.getInfostore(), this.service.getSearch(), this);
        return this.files;
    }

    public FileStorageFolderAccess getFolderAccess() throws OXException {
        if (this.folders != null) {
            return this.folders;
        }
        this.folders = new InfostoreFolderAccess(this.session, this.service.getInfostore());
        return this.folders;
    }

    public FileStorageFolder getRootFolder() throws OXException {
        return null;
    }

    public boolean cacheable() {
        return false;
    }

    public void close() {
    }

    public void connect() throws OXException {
    }

    public boolean isConnected() {
        return true;
    }

    public boolean ping() throws OXException {
        return true;
    }

    public FileStorageService getService() {
        return this.service;
    }
}

