/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync.optimize;

import com.openexchange.drive.FileVersion;
import com.openexchange.drive.comparison.VersionMapper;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.sync.FileSynchronizer;
import com.openexchange.drive.sync.IntermediateSyncResult;
import com.openexchange.drive.sync.optimize.EmptyFileOptimizer;
import com.openexchange.drive.sync.optimize.FileActionOptimizer;
import com.openexchange.drive.sync.optimize.FileCopyOptimizer;
import com.openexchange.drive.sync.optimize.FileMultipleUploadsOptimizer;
import com.openexchange.drive.sync.optimize.FileOrderOptimizer;
import com.openexchange.drive.sync.optimize.FileRenameOptimizer;
import com.openexchange.exception.OXException;

public class OptimizingFileSynchronizer
extends FileSynchronizer {
    public OptimizingFileSynchronizer(SyncSession session, VersionMapper<FileVersion> mapper, String path) throws OXException {
        super(session, mapper, path);
    }

    @Override
    public IntermediateSyncResult<FileVersion> sync() throws OXException {
        IntermediateSyncResult<FileVersion> result = super.sync();
        if (!result.isEmpty()) {
            FileActionOptimizer[] optimizers;
            int lastResults = 0;
            if (this.session.isTraceEnabled()) {
                lastResults = result.hashCode();
                this.session.trace("Sync results before optimizations:\n" + result.toString());
            }
            for (FileActionOptimizer optimizer : optimizers = new FileActionOptimizer[]{new FileRenameOptimizer(this.mapper), new EmptyFileOptimizer(this.mapper), new FileCopyOptimizer(this.mapper), new FileMultipleUploadsOptimizer(this.mapper), new FileOrderOptimizer(this.mapper)}) {
                int currentResults;
                result = optimizer.optimize(this.session, result);
                if (!this.session.isTraceEnabled() || (currentResults = result.hashCode()) == lastResults) continue;
                lastResults = currentResults;
                this.session.trace("Sync results after optimizations of " + optimizer.getClass().getSimpleName() + ":\n" + result.toString());
            }
        }
        return result;
    }
}

