/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync.optimize;

import com.openexchange.drive.Action;
import com.openexchange.drive.DriveAction;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.actions.AbstractAction;
import com.openexchange.drive.actions.AcknowledgeFileAction;
import com.openexchange.drive.actions.EditFileAction;
import com.openexchange.drive.comparison.VersionMapper;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.sync.IntermediateSyncResult;
import com.openexchange.drive.sync.RenameTools;
import com.openexchange.drive.sync.SimpleFileVersion;
import com.openexchange.drive.sync.optimize.FileActionOptimizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FileRenameOptimizer
extends FileActionOptimizer {
    private final Set<String> usedFilenames;

    public FileRenameOptimizer(VersionMapper<FileVersion> mapper) {
        super(mapper);
        this.usedFilenames = new HashSet<String>(mapper.getKeys());
    }

    @Override
    public IntermediateSyncResult<FileVersion> optimize(SyncSession session, IntermediateSyncResult<FileVersion> result) {
        ArrayList<AbstractAction<FileVersion>> optimizedActionsForClient = new ArrayList<AbstractAction<FileVersion>>(result.getActionsForClient());
        ArrayList<AbstractAction<FileVersion>> optimizedActionsForServer = new ArrayList<AbstractAction<FileVersion>>(result.getActionsForServer());
        for (AbstractAction<FileVersion> clientAction : result.getActionsForClient()) {
            if (Action.UPLOAD == clientAction.getAction()) {
                AbstractAction matchingServerAction = null;
                for (AbstractAction abstractAction : optimizedActionsForServer) {
                    if (Action.REMOVE != abstractAction.getAction() || !FileRenameOptimizer.matchesByChecksum(clientAction.getNewVersion(), abstractAction.getVersion())) continue;
                    matchingServerAction = abstractAction;
                    break;
                }
                if (null != matchingServerAction) {
                    AbstractAction matchingClientAction = null;
                    for (AbstractAction abstractAction : optimizedActionsForClient) {
                        if (Action.ACKNOWLEDGE != abstractAction.getAction() || !FileRenameOptimizer.matchesByNameAndChecksum((FileVersion)matchingServerAction.getVersion(), (FileVersion)abstractAction.getVersion())) continue;
                        matchingClientAction = abstractAction;
                        break;
                    }
                    if (null != matchingClientAction) {
                        String string = (String)clientAction.getParameters().get("path");
                        optimizedActionsForClient.remove(clientAction);
                        optimizedActionsForClient.remove(matchingClientAction);
                        optimizedActionsForServer.remove(matchingServerAction);
                        EditFileAction editFileAction = new EditFileAction((FileVersion)matchingServerAction.getVersion(), clientAction.getNewVersion(), null, string);
                        if (null != clientAction.getVersion()) {
                            editFileAction.getParameters().put("targetVersion", clientAction.getVersion());
                        }
                        AcknowledgeFileAction clientAcknowledge = new AcknowledgeFileAction(session, (FileVersion)matchingClientAction.getVersion(), clientAction.getNewVersion(), null, string, null);
                        clientAcknowledge.setDependingAction(editFileAction);
                        optimizedActionsForClient.add(clientAcknowledge);
                        optimizedActionsForServer.add(editFileAction);
                    }
                }
            }
            if (!Action.UPLOAD.equals((Object)clientAction.getAction()) || !FileRenameOptimizer.matchesByName(clientAction.getVersion(), clientAction.getNewVersion())) continue;
            DriveAction matchingAction = null;
            for (AbstractAction abstractAction : optimizedActionsForClient) {
                if (Action.UPLOAD != abstractAction.getAction() || !FileRenameOptimizer.matchesByName((FileVersion)abstractAction.getVersion(), (FileVersion)abstractAction.getNewVersion()) || !FileRenameOptimizer.matchesByChecksum(clientAction.getVersion(), abstractAction.getNewVersion()) || !FileRenameOptimizer.matchesByChecksum(clientAction.getNewVersion(), abstractAction.getVersion())) continue;
                matchingAction = abstractAction;
                break;
            }
            if (null == matchingAction) continue;
            FileVersion clientActionServerVersion = FileRenameOptimizer.findByNameAndChecksum(clientAction.getVersion().getName(), clientAction.getVersion().getChecksum(), this.mapper.getServerVersions());
            FileVersion fileVersion = FileRenameOptimizer.findByNameAndChecksum(((FileVersion)matchingAction.getVersion()).getName(), ((FileVersion)matchingAction.getVersion()).getChecksum(), this.mapper.getServerVersions());
            if (null == clientActionServerVersion || null == fileVersion) continue;
            String string = (String)clientAction.getParameters().get("path");
            optimizedActionsForClient.remove(clientAction);
            optimizedActionsForClient.remove(matchingAction);
            FileVersion renamedVersion = this.getRenamedVersion(session, clientAction.getVersion());
            optimizedActionsForServer.add(new EditFileAction(clientActionServerVersion, renamedVersion, null, string, 1));
            EditFileAction serverEdit1 = new EditFileAction(fileVersion, clientActionServerVersion, null, string, 2);
            optimizedActionsForServer.add(serverEdit1);
            EditFileAction serverEdit2 = new EditFileAction(renamedVersion, fileVersion, null, string, 3);
            optimizedActionsForServer.add(serverEdit2);
            AcknowledgeFileAction clientAcknowledge1 = new AcknowledgeFileAction(session, clientAction.getVersion(), clientAction.getNewVersion(), null, string, null);
            clientAcknowledge1.setDependingAction(serverEdit1);
            AcknowledgeFileAction clientAcknowledge2 = new AcknowledgeFileAction(session, (FileVersion)matchingAction.getVersion(), (FileVersion)matchingAction.getNewVersion(), null, string, null);
            clientAcknowledge2.setDependingAction(serverEdit2);
            optimizedActionsForClient.add(clientAcknowledge1);
            optimizedActionsForClient.add(clientAcknowledge2);
        }
        return new IntermediateSyncResult<FileVersion>(this.optimizeRenames(optimizedActionsForServer), this.optimizeRenames(optimizedActionsForClient));
    }

    private List<AbstractAction<FileVersion>> optimizeRenames(List<AbstractAction<FileVersion>> actions) {
        ArrayList<AbstractAction<FileVersion>> optimizedList = new ArrayList<AbstractAction<FileVersion>>(actions);
        for (AbstractAction<FileVersion> action : actions) {
            if (!Action.REMOVE.equals((Object)action.getAction())) continue;
            AbstractAction matchingAction = null;
            for (AbstractAction abstractAction : optimizedList) {
                if (Action.DOWNLOAD != abstractAction.getAction() || !FileRenameOptimizer.matchesByChecksum(action.getVersion(), abstractAction.getNewVersion())) continue;
                matchingAction = abstractAction;
                break;
            }
            if (null == matchingAction) continue;
            String path = (String)matchingAction.getParameters().get("path");
            optimizedList.remove(action);
            optimizedList.remove(matchingAction);
            optimizedList.add(new EditFileAction(action.getVersion(), (FileVersion)matchingAction.getNewVersion(), null, path));
        }
        return optimizedList;
    }

    private FileVersion getRenamedVersion(SyncSession session, FileVersion conflictingVersion) {
        String alternativeName = RenameTools.findAlternativeName(conflictingVersion.getName(), this.usedFilenames, session.getDeviceName());
        if (null != this.usedFilenames) {
            this.usedFilenames.add(alternativeName);
        }
        return new SimpleFileVersion(alternativeName, conflictingVersion.getChecksum());
    }

    private static FileVersion findByNameAndChecksum(String name, String checksum, Collection<? extends FileVersion> fileVersions) {
        if (null != fileVersions && 0 < fileVersions.size()) {
            for (FileVersion fileVersion : fileVersions) {
                if (!name.equals(fileVersion.getName()) || !checksum.equals(fileVersion.getChecksum())) continue;
                return fileVersion;
            }
        }
        return null;
    }
}

