/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync.optimize;

import com.openexchange.drive.Action;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.actions.AbstractAction;
import com.openexchange.drive.comparison.Change;
import com.openexchange.drive.comparison.VersionMapper;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.sync.IntermediateSyncResult;
import com.openexchange.drive.sync.optimize.FileActionOptimizer;
import java.util.ArrayList;
import java.util.HashSet;

public class FileMultipleUploadsOptimizer
extends FileActionOptimizer {
    public FileMultipleUploadsOptimizer(VersionMapper<FileVersion> mapper) {
        super(mapper);
    }

    @Override
    public IntermediateSyncResult<FileVersion> optimize(SyncSession session, IntermediateSyncResult<FileVersion> result) {
        ArrayList optimizedActionsForClients = new ArrayList(result.getActionsForClient().size());
        HashSet<String> uploadedVersionChecksums = new HashSet<String>();
        for (AbstractAction<FileVersion> action : result.getActionsForClient()) {
            if (Action.UPLOAD.equals((Object)action.getAction())) {
                boolean alreadyKnown;
                boolean bl = alreadyKnown = false == uploadedVersionChecksums.add(action.getNewVersion().getChecksum());
                if (action.wasCausedBy(Change.NEW, Change.NONE) && alreadyKnown) continue;
            }
            optimizedActionsForClients.add(action);
        }
        return new IntermediateSyncResult<FileVersion>(result.getActionsForServer(), optimizedActionsForClients);
    }
}

