/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync.optimize;

import com.openexchange.drive.Action;
import com.openexchange.drive.DirectoryVersion;
import com.openexchange.drive.actions.AbstractAction;
import com.openexchange.drive.actions.EditDirectoryAction;
import com.openexchange.drive.actions.RemoveDirectoryAction;
import com.openexchange.drive.actions.SyncDirectoryAction;
import com.openexchange.drive.comparison.VersionMapper;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.sync.IntermediateSyncResult;
import com.openexchange.drive.sync.SimpleDirectoryVersion;
import com.openexchange.drive.sync.optimize.DirectoryActionOptimizer;
import java.util.Collections;
import java.util.List;

public class DirectoryOrderOptimizer
extends DirectoryActionOptimizer {
    public DirectoryOrderOptimizer(VersionMapper<DirectoryVersion> mapper) {
        super(mapper);
    }

    @Override
    public IntermediateSyncResult<DirectoryVersion> optimize(SyncSession session, IntermediateSyncResult<DirectoryVersion> result) {
        List actionsForClient = result.getActionsForClient();
        List actionsForServer = result.getActionsForServer();
        Collections.sort(actionsForClient);
        Collections.sort(actionsForServer);
        actionsForClient = DirectoryOrderOptimizer.propagateRenames(actionsForClient);
        actionsForServer = DirectoryOrderOptimizer.propagateRenames(actionsForServer);
        return new IntermediateSyncResult<DirectoryVersion>(actionsForServer, actionsForClient);
    }

    private static List<AbstractAction<DirectoryVersion>> propagateRenames(List<AbstractAction<DirectoryVersion>> actions) {
        for (int i = 0; i < actions.size(); ++i) {
            if (!Action.EDIT.equals((Object)actions.get(i).getAction()) || null == actions.get(i).getVersion() || null == actions.get(i).getNewVersion()) continue;
            String oldPath = actions.get(i).getVersion().getPath();
            String newPath = actions.get(i).getNewVersion().getPath();
            for (int j = i + 1; j < actions.size(); ++j) {
                SimpleDirectoryVersion modifiedOldVersion;
                String newOldPath;
                if (Action.EDIT.equals((Object)actions.get(j).getAction()) && actions.get(j).getVersion().getPath().startsWith(oldPath + '/')) {
                    newOldPath = newPath + actions.get(j).getVersion().getPath().substring(oldPath.length());
                    modifiedOldVersion = new SimpleDirectoryVersion(newOldPath, actions.get(j).getVersion().getChecksum());
                    actions.set(j, new EditDirectoryAction(modifiedOldVersion, actions.get(j).getNewVersion(), actions.get(j).getComparison()));
                    continue;
                }
                if (Action.REMOVE.equals((Object)actions.get(j).getAction()) && actions.get(j).getVersion().getPath().startsWith(oldPath + '/')) {
                    newOldPath = newPath + actions.get(j).getVersion().getPath().substring(oldPath.length());
                    modifiedOldVersion = new SimpleDirectoryVersion(newOldPath, actions.get(j).getVersion().getChecksum());
                    actions.set(j, new RemoveDirectoryAction(modifiedOldVersion, actions.get(j).getComparison()));
                    continue;
                }
                if (!Action.SYNC.equals((Object)actions.get(j).getAction()) || !actions.get(j).getVersion().getPath().startsWith(oldPath + '/')) continue;
                newOldPath = newPath + actions.get(j).getVersion().getPath().substring(oldPath.length());
                modifiedOldVersion = new SimpleDirectoryVersion(newOldPath, actions.get(j).getVersion().getChecksum());
                actions.set(j, new SyncDirectoryAction(modifiedOldVersion, actions.get(j).getComparison()));
            }
        }
        return actions;
    }
}

