/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync;

import com.openexchange.java.Strings;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RenameTools {
    public static String findAlternativeName(String conflictingName, Set<String> usedFilenames, String deviceName) {
        String alternativeName;
        if (Strings.isEmpty((String)deviceName)) {
            return RenameTools.findAlternativeName(conflictingName, usedFilenames);
        }
        FileName fileName = new FileName(conflictingName);
        String name = fileName.getName();
        Pattern regex = Pattern.compile("\\(" + Pattern.quote(deviceName) + "(\\s\\d+)?\\)\\z");
        do {
            Matcher matcher;
            if (!(matcher = regex.matcher(name)).find()) {
                name = name + " (" + deviceName + ')';
            } else if (0 == matcher.groupCount() || 0 < matcher.groupCount() && Strings.isEmpty((String)matcher.group(1))) {
                name = name.substring(0, matcher.start()) + '(' + deviceName + " 1)";
            } else {
                int number = 0;
                try {
                    number = Integer.valueOf(matcher.group(1).trim());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                name = name.substring(0, matcher.start()) + '(' + deviceName + ' ' + String.valueOf(1 + number) + ')';
            }
            alternativeName = name + fileName.getExtension();
        } while (null != usedFilenames && usedFilenames.contains(alternativeName));
        return alternativeName;
    }

    public static String findAlternativeName(String conflictingName, Set<String> usedFilenames) {
        String alternativeName;
        FileName fileName = new FileName(conflictingName);
        String name = fileName.getName();
        Pattern regex = Pattern.compile("\\((\\d+)\\)\\z");
        do {
            Matcher matcher;
            if (!(matcher = regex.matcher(name)).find()) {
                name = name + " (1)";
            } else {
                int number = 0;
                try {
                    number = Integer.valueOf(matcher.group(1));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                name = name.substring(0, matcher.start()) + '(' + String.valueOf(1 + number) + ')';
            }
            alternativeName = name + fileName.getExtension();
        } while (null != usedFilenames && usedFilenames.contains(alternativeName));
        return alternativeName;
    }

    public static String findRandomAlternativeName(String conflictingName) {
        FileName fileName = new FileName(conflictingName);
        return fileName.getName() + ' ' + System.currentTimeMillis() + fileName.getExtension();
    }

    public static String findRandomAlternativeName(String conflictingName, String deviceName) {
        if (Strings.isEmpty((String)deviceName)) {
            return RenameTools.findRandomAlternativeName(conflictingName);
        }
        FileName fileName = new FileName(conflictingName);
        return fileName.getName() + " (" + deviceName + ' ' + System.currentTimeMillis() + ')' + fileName.getExtension();
    }

    private static final class FileName {
        private String name;
        private String extension;

        public FileName(String fileName) {
            int extensionIndex = fileName.lastIndexOf(46);
            if (-1 == extensionIndex) {
                this.name = fileName;
                this.extension = "";
            } else {
                this.name = fileName.substring(0, extensionIndex);
                this.extension = fileName.substring(extensionIndex);
            }
        }

        public String getExtension() {
            return this.extension;
        }

        public String getName() {
            return this.name;
        }
    }
}

