/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.sync;

import com.openexchange.drive.DirectoryVersion;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.DriveUtils;
import com.openexchange.drive.actions.AcknowledgeDirectoryAction;
import com.openexchange.drive.actions.EditDirectoryAction;
import com.openexchange.drive.actions.ErrorDirectoryAction;
import com.openexchange.drive.actions.RemoveDirectoryAction;
import com.openexchange.drive.actions.SyncDirectoryAction;
import com.openexchange.drive.comparison.Change;
import com.openexchange.drive.comparison.ThreeWayComparison;
import com.openexchange.drive.comparison.VersionMapper;
import com.openexchange.drive.internal.PathNormalizer;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.management.DriveConfig;
import com.openexchange.drive.sync.IntermediateSyncResult;
import com.openexchange.drive.sync.Synchronizer;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStoragePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DirectorySynchronizer
extends Synchronizer<DirectoryVersion> {
    private Map<String, Set<String>> normalizedFilesnamesPerFolder;

    public DirectorySynchronizer(SyncSession session, VersionMapper<DirectoryVersion> mapper) throws OXException {
        super(session, mapper);
    }

    @Override
    public IntermediateSyncResult<DirectoryVersion> sync() throws OXException {
        OXException e;
        ThreeWayComparison<DirectoryVersion> twc;
        IntermediateSyncResult<DirectoryVersion> syncResult = super.sync();
        if (null != this.mapper.getMappingProblems().getCaseConflictingClientVersions()) {
            for (DirectoryVersion clientVersion : this.mapper.getMappingProblems().getCaseConflictingClientVersions()) {
                twc = new ThreeWayComparison<DirectoryVersion>();
                twc.setClientVersion(clientVersion);
                e = DriveExceptionCodes.CONFLICTING_PATH.create(clientVersion.getPath());
                LOG.warn("Client change refused due to case conflicting name: {}", (Object)clientVersion, (Object)e);
                syncResult.addActionForClient(new ErrorDirectoryAction(null, clientVersion, twc, e, true, false));
            }
        }
        if (null != this.mapper.getMappingProblems().getUnicodeConflictingClientVersions()) {
            for (DirectoryVersion clientVersion : this.mapper.getMappingProblems().getUnicodeConflictingClientVersions()) {
                twc = new ThreeWayComparison();
                twc.setClientVersion(clientVersion);
                e = DriveExceptionCodes.CONFLICTING_PATH.create(clientVersion.getPath());
                LOG.warn("Client change refused due to unicode conflicting name: {}", (Object)clientVersion, (Object)e);
                syncResult.addActionForClient(new ErrorDirectoryAction(null, clientVersion, twc, e, true, false));
            }
        }
        return syncResult;
    }

    @Override
    protected int getMaxActions() {
        return DriveConfig.getInstance().getMaxDirectoryActions();
    }

    @Override
    protected int processServerChange(IntermediateSyncResult<DirectoryVersion> result, ThreeWayComparison<DirectoryVersion> comparison) throws OXException {
        switch (comparison.getServerChange()) {
            case DELETED: {
                String normalizedPathToDelete = PathNormalizer.normalize(comparison.getClientVersion().getPath()).toLowerCase();
                for (Map.Entry entry : this.mapper) {
                    String normalizedPath;
                    Change clientChange = entry.getValue().getClientChange();
                    if (Change.NONE == clientChange || Change.DELETED == clientChange || !(normalizedPath = PathNormalizer.normalize(entry.getKey()).toLowerCase()).startsWith(normalizedPathToDelete) || normalizedPath.equals(normalizedPathToDelete)) continue;
                    if (this.session.isTraceEnabled()) {
                        this.session.trace("Skipping action \"" + new RemoveDirectoryAction(comparison.getClientVersion(), comparison) + "\" due to conflicting client-side changes in subfolders.");
                    }
                    return 0;
                }
                result.addActionForClient(new RemoveDirectoryAction(comparison.getClientVersion(), comparison));
                return 1;
            }
            case MODIFIED: {
                String normalizedClientPath = PathNormalizer.normalize(comparison.getClientVersion().getPath());
                String normalizedServerPath = PathNormalizer.normalize(comparison.getServerVersion().getPath());
                if (normalizedClientPath.equalsIgnoreCase(normalizedServerPath) && !normalizedClientPath.equals(normalizedServerPath)) {
                    result.addActionForClient(new EditDirectoryAction(comparison.getClientVersion(), comparison.getServerVersion(), comparison));
                    if (!comparison.getClientVersion().getChecksum().equalsIgnoreCase(comparison.getServerVersion().getChecksum())) {
                        result.addActionForClient(new SyncDirectoryAction(comparison.getServerVersion(), comparison));
                        return 2;
                    }
                    return 1;
                }
                result.addActionForClient(new SyncDirectoryAction(comparison.getClientVersion(), comparison));
                return 1;
            }
            case NEW: {
                result.addActionForClient(new SyncDirectoryAction(comparison.getServerVersion(), comparison));
                return 1;
            }
        }
        return 0;
    }

    @Override
    protected int processClientChange(IntermediateSyncResult<DirectoryVersion> result, ThreeWayComparison<DirectoryVersion> comparison) throws OXException {
        switch (comparison.getClientChange()) {
            case DELETED: {
                if (this.mayDelete(comparison.getServerVersion(), true)) {
                    result.addActionForServer(new RemoveDirectoryAction(comparison.getServerVersion(), comparison));
                    result.addActionForClient(new AcknowledgeDirectoryAction(comparison.getOriginalVersion(), null, comparison));
                    return 1;
                }
                result.addActionForClient(new SyncDirectoryAction(comparison.getServerVersion(), comparison));
                OXException e = DriveExceptionCodes.NO_DELETE_DIRECTORY_PERMISSION.create(comparison.getServerVersion().getPath());
                LOG.warn("Client change refused for {}", (Object)comparison.getServerVersion(), (Object)e);
                result.addActionForClient(new ErrorDirectoryAction(comparison.getClientVersion(), comparison.getServerVersion(), comparison, e, false, false));
                return 2;
            }
            case NEW: {
                if (DriveUtils.isInvalidPath(comparison.getClientVersion().getPath())) {
                    OXException e = DriveExceptionCodes.INVALID_PATH.create(comparison.getClientVersion().getPath());
                    LOG.warn("Client change refused due to invalid path: {}", (Object)comparison.getClientVersion(), (Object)e);
                    result.addActionForClient(new ErrorDirectoryAction(null, comparison.getClientVersion(), comparison, e, true, false));
                    return 1;
                }
                if (DriveUtils.isIgnoredPath(this.session, comparison.getClientVersion().getPath())) {
                    OXException e = DriveExceptionCodes.IGNORED_PATH.create(comparison.getClientVersion().getPath());
                    LOG.warn("Client change refused due to ignored path: {}", (Object)comparison.getClientVersion(), (Object)e);
                    result.addActionForClient(new ErrorDirectoryAction(null, comparison.getClientVersion(), comparison, e, true, false));
                    return 1;
                }
                DirectoryVersion lastExistingParentVersion = this.getLastExistingParentVersion(comparison.getClientVersion().getPath());
                if (this.mayCreate(lastExistingParentVersion.getPath())) {
                    String directoryName = DirectorySynchronizer.getFirstDirectoryNameToCreate(lastExistingParentVersion, comparison.getClientVersion().getPath());
                    FileStorageFolder parentFolder = this.session.getStorage().getFolder(lastExistingParentVersion.getPath());
                    if (this.getNormalizedFilenames(parentFolder.getId()).contains(PathNormalizer.normalize(directoryName.toLowerCase()))) {
                        OXException e = DriveExceptionCodes.LEVEL_CONFLICTING_PATH.create(comparison.getClientVersion().getPath(), lastExistingParentVersion.getPath());
                        LOG.warn("Client change refused due to conflicting path: {}", (Object)comparison.getClientVersion(), (Object)e);
                        result.addActionForClient(new ErrorDirectoryAction(null, comparison.getClientVersion(), comparison, e, true, false));
                        return 1;
                    }
                    result.addActionForServer(new SyncDirectoryAction(comparison.getClientVersion(), comparison));
                    result.addActionForClient(new SyncDirectoryAction(comparison.getClientVersion(), comparison));
                    return 2;
                }
                OXException e = DriveExceptionCodes.NO_CREATE_DIRECTORY_PERMISSION.create(lastExistingParentVersion.getPath());
                LOG.warn("Client change refused due to missing permissions: {}", (Object)comparison.getClientVersion(), (Object)e);
                result.addActionForClient(new ErrorDirectoryAction(null, comparison.getClientVersion(), comparison, e, true, false));
                return 1;
            }
            case MODIFIED: {
                int nonTrivialChanges = 0;
                String normalizedClientPath = PathNormalizer.normalize(comparison.getClientVersion().getPath());
                String normalizedServerPath = PathNormalizer.normalize(comparison.getServerVersion().getPath());
                if (normalizedClientPath.equalsIgnoreCase(normalizedServerPath) && !normalizedClientPath.equals(normalizedServerPath)) {
                    result.addActionForServer(new EditDirectoryAction(comparison.getServerVersion(), comparison.getClientVersion(), comparison));
                    ++nonTrivialChanges;
                }
                if (!comparison.getClientVersion().getChecksum().equalsIgnoreCase(comparison.getServerVersion().getChecksum())) {
                    result.addActionForClient(new SyncDirectoryAction(comparison.getClientVersion(), comparison));
                    ++nonTrivialChanges;
                }
                return nonTrivialChanges;
            }
        }
        return 0;
    }

    @Override
    protected int processConflictingChange(IntermediateSyncResult<DirectoryVersion> result, ThreeWayComparison<DirectoryVersion> comparison) throws OXException {
        if (Change.DELETED == comparison.getServerChange() && Change.DELETED == comparison.getClientChange()) {
            result.addActionForClient(new AcknowledgeDirectoryAction(comparison.getOriginalVersion(), null, comparison));
            return 0;
        }
        if (!(Change.NEW != comparison.getClientChange() && Change.MODIFIED != comparison.getClientChange() || Change.NEW != comparison.getServerChange() && Change.MODIFIED != comparison.getServerChange())) {
            String normalizedServerPath;
            if (Change.NONE.equals((Object)Change.get(comparison.getClientVersion(), comparison.getServerVersion()))) {
                result.addActionForClient(new AcknowledgeDirectoryAction(comparison.getOriginalVersion(), comparison.getClientVersion(), comparison));
                if (!"d41d8cd98f00b204e9800998ecf8427e".equals(comparison.getClientVersion().getChecksum()) && Change.NEW.equals((Object)comparison.getClientChange()) && Change.NEW.equals((Object)comparison.getServerChange())) {
                    result.addActionForClient(new SyncDirectoryAction(comparison.getServerVersion(), comparison));
                    return 1;
                }
                return 0;
            }
            String normalizedClientPath = PathNormalizer.normalize(comparison.getClientVersion().getPath());
            if (normalizedClientPath.equalsIgnoreCase(normalizedServerPath = PathNormalizer.normalize(comparison.getServerVersion().getPath())) && !normalizedClientPath.equals(normalizedServerPath)) {
                result.addActionForClient(new EditDirectoryAction(comparison.getClientVersion(), comparison.getServerVersion(), comparison));
                if (!comparison.getClientVersion().getChecksum().equalsIgnoreCase(comparison.getServerVersion().getChecksum())) {
                    result.addActionForClient(new SyncDirectoryAction(comparison.getServerVersion(), comparison));
                    return 2;
                }
                return 1;
            }
            result.addActionForClient(new SyncDirectoryAction(comparison.getClientVersion(), comparison));
            return 1;
        }
        if (Change.DELETED == comparison.getClientChange() && (Change.MODIFIED == comparison.getServerChange() || Change.NEW == comparison.getServerChange())) {
            result.addActionForClient(new SyncDirectoryAction(comparison.getServerVersion(), comparison));
            return 1;
        }
        if ((Change.NEW == comparison.getClientChange() || Change.MODIFIED == comparison.getClientChange()) && Change.DELETED == comparison.getServerChange()) {
            DirectoryVersion lastExistingParentVersion = this.getLastExistingParentVersion(comparison.getClientVersion().getPath());
            if (this.mayCreate(lastExistingParentVersion.getPath())) {
                String directoryName = DirectorySynchronizer.getFirstDirectoryNameToCreate(lastExistingParentVersion, comparison.getClientVersion().getPath());
                FileStorageFolder parentFolder = this.session.getStorage().getFolder(lastExistingParentVersion.getPath());
                if (this.getNormalizedFilenames(parentFolder.getId()).contains(PathNormalizer.normalize(directoryName.toLowerCase()))) {
                    OXException e = DriveExceptionCodes.LEVEL_CONFLICTING_PATH.create(comparison.getClientVersion().getPath(), lastExistingParentVersion.getPath());
                    LOG.warn("Client change refused due to conflicting path: {}", (Object)comparison.getClientVersion(), (Object)e);
                    result.addActionForClient(new ErrorDirectoryAction(null, comparison.getClientVersion(), comparison, e, true, false));
                    return 1;
                }
                result.addActionForClient(new SyncDirectoryAction(comparison.getClientVersion(), comparison));
                return 1;
            }
            OXException e = DriveExceptionCodes.NO_CREATE_DIRECTORY_PERMISSION.create(lastExistingParentVersion.getPath());
            LOG.warn("Client change refused due to missing permissions: {}", (Object)comparison.getClientVersion(), (Object)e);
            result.addActionForClient(new ErrorDirectoryAction(null, comparison.getClientVersion(), comparison, e, true, false));
            return 1;
        }
        throw new UnsupportedOperationException("Not implemented: Server: " + (Object)((Object)comparison.getServerChange()) + ", Client: " + (Object)((Object)comparison.getClientChange()));
    }

    private boolean mayDelete(DirectoryVersion version, boolean checkSubfolders) throws OXException {
        if ("/".equals(version.getPath())) {
            return false;
        }
        FileStoragePermission ownPermission = this.session.getStorage().getOwnPermission(version.getPath());
        if (!ownPermission.isAdmin()) {
            return false;
        }
        if (!"d41d8cd98f00b204e9800998ecf8427e".equals(version.getChecksum())) {
            if (2 > ownPermission.getDeletePermission()) {
                return false;
            }
            if (2 == ownPermission.getDeletePermission()) {
                String folderID = this.session.getStorage().getFolderID(version.getPath());
                List<File> files = this.session.getStorage().getFilesInFolder(folderID, true, null, Arrays.asList(File.Field.CREATED_BY));
                for (File file : files) {
                    if (file.getCreatedBy() == this.session.getServerSession().getUserId()) continue;
                    return false;
                }
            }
        }
        if (checkSubfolders) {
            for (DirectoryVersion directoryVersion : this.getKnownSubDirectories(version)) {
                if (this.mayDelete(directoryVersion, false)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean mayCreate(String parentPath) throws OXException {
        return 8 <= this.session.getStorage().getOwnPermission(parentPath).getFolderPermission();
    }

    private List<DirectoryVersion> getKnownSubDirectories(DirectoryVersion version) {
        ArrayList<DirectoryVersion> subDirectories = new ArrayList<DirectoryVersion>();
        for (DirectoryVersion directoryVersion : this.mapper.getServerVersions()) {
            String candidatePath = directoryVersion.getPath();
            if (!candidatePath.startsWith(version.getPath()) || candidatePath.equals(version.getPath())) continue;
            subDirectories.add(directoryVersion);
        }
        return subDirectories;
    }

    private DirectoryVersion getLastExistingParentVersion(String path) {
        int idx;
        Collection serverVersions = this.mapper.getServerVersions();
        String currentPath = path;
        do {
            currentPath = 0 < (idx = currentPath.lastIndexOf(47)) ? currentPath.substring(0, idx) : "/";
            for (DirectoryVersion serverVersion : serverVersions) {
                if (!serverVersion.getPath().equals(currentPath)) continue;
                return serverVersion;
            }
        } while (0 < idx);
        return null;
    }

    private Set<String> getNormalizedFilenames(String folderID) throws OXException {
        Set<String> normalizedFilenames;
        if (null == this.normalizedFilesnamesPerFolder) {
            this.normalizedFilesnamesPerFolder = new HashMap<String, Set<String>>();
        }
        if (null == (normalizedFilenames = this.normalizedFilesnamesPerFolder.get(folderID))) {
            normalizedFilenames = DriveUtils.getNormalizedFileNames(this.session.getStorage().getFilesInFolder(folderID, true, null, Arrays.asList(File.Field.FILENAME)), true);
            this.normalizedFilesnamesPerFolder.put(folderID, normalizedFilenames);
        }
        return normalizedFilenames;
    }

    private static String getFirstDirectoryNameToCreate(DirectoryVersion lastExistingParentVersion, String pathToCreate) {
        String normalizedPathToCreate;
        int idx;
        String normalizedParentPath = PathNormalizer.normalize(lastExistingParentVersion.getPath());
        if (!"/".equals(normalizedParentPath)) {
            normalizedParentPath = normalizedParentPath + '/';
        }
        return 0 < (idx = (normalizedPathToCreate = PathNormalizer.normalize(pathToCreate).substring(normalizedParentPath.length())).indexOf(47)) ? normalizedPathToCreate.substring(0, idx) : normalizedPathToCreate;
    }
}

