/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.storage.filter;

import com.openexchange.drive.internal.PathNormalizer;
import com.openexchange.drive.storage.filter.DefaultFileFilter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.java.Strings;

public abstract class FileNameFilter
extends DefaultFileFilter {
    public static final FileNameFilter ACCEPT_ALL = new FileNameFilter(){

        @Override
        protected boolean accept(String fileName) throws OXException {
            return false == Strings.isEmpty((String)fileName);
        }
    };

    public static FileNameFilter byName(final String name, final boolean normalizeFileNames) {
        return new FileNameFilter(){

            @Override
            protected boolean accept(String fileName) throws OXException {
                return name.equals(fileName) || normalizeFileNames && PathNormalizer.equals(name, fileName);
            }
        };
    }

    protected abstract boolean accept(String var1) throws OXException;

    @Override
    public boolean accept(File file) throws OXException {
        return null != file && null != file.getFileName() && this.accept(file.getFileName());
    }
}

