/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.storage.execute;

import com.openexchange.drive.Action;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.DriveUtils;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.actions.AbstractAction;
import com.openexchange.drive.actions.ErrorFileAction;
import com.openexchange.drive.checksum.ChecksumProvider;
import com.openexchange.drive.checksum.FileChecksum;
import com.openexchange.drive.comparison.ServerFileVersion;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.storage.execute.BatchActionExecutor;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.java.UnsynchronizedByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileActionExecutor
extends BatchActionExecutor<FileVersion> {
    private static final int OPTIMISTIC_MOVE_TO_TEMP_THRESHOLD = 5;
    private static final int MOVE_TO_TEMP_LIMIT = 20;
    private static final Logger LOG = LoggerFactory.getLogger(FileActionExecutor.class);
    private final String path;

    public FileActionExecutor(SyncSession session, boolean transactional, boolean allowBatches, String path) {
        super(session, transactional, allowBatches);
        this.path = path;
    }

    @Override
    protected void batchExecute(Action action, List<AbstractAction<FileVersion>> actions) throws OXException {
        switch (action) {
            case REMOVE: {
                this.batchRemove(actions);
                break;
            }
            default: {
                for (AbstractAction<FileVersion> driveAction : actions) {
                    this.execute(driveAction);
                }
            }
        }
    }

    @Override
    protected void execute(AbstractAction<FileVersion> action) throws OXException {
        switch (action.getAction()) {
            case REMOVE: {
                this.remove(action);
                break;
            }
            case DOWNLOAD: {
                try {
                    this.download(action);
                    break;
                }
                catch (OXException e) {
                    LOG.warn("Got exception during server-side execution of download action: {}\nSession: {}, path: {}, action: {}", new Object[]{e.getMessage(), this.session, this.path, action});
                    if (DriveUtils.indicatesQuotaExceeded(e)) {
                        this.addNewActionsForClient(DriveUtils.handleQuotaExceeded(this.session, e, this.path, action.getVersion(), action.getNewVersion()));
                        break;
                    }
                    if (DriveUtils.indicatesFailedSave(e)) {
                        this.addNewActionForClient(new ErrorFileAction(null, action.getNewVersion(), null, this.path, e, true));
                        break;
                    }
                    throw e;
                }
            }
            case EDIT: {
                try {
                    this.edit(action);
                    break;
                }
                catch (OXException e) {
                    LOG.warn("Got exception during server-side execution of edit action: {}\nSession: {}, path: {}, action: {}", new Object[]{e.getMessage(), this.session, this.path, action});
                    if (DriveUtils.indicatesFailedSave(e)) {
                        this.addNewActionForClient(new ErrorFileAction(null, action.getNewVersion(), null, this.path, e, true));
                        break;
                    }
                    throw e;
                }
            }
            default: {
                throw new IllegalStateException("Can't perform action " + action + " on server");
            }
        }
    }

    private void edit(AbstractAction<FileVersion> action) throws OXException {
        File renamedFile;
        ServerFileVersion targetVersion = null != action.getParameters().get("targetVersion") ? ServerFileVersion.valueOf((FileVersion)action.getParameters().get("targetVersion"), this.path, this.session) : null;
        ServerFileVersion originalVersion = ServerFileVersion.valueOf(action.getVersion(), this.path, this.session);
        FileChecksum fileChecksum = originalVersion.getFileChecksum();
        if (null != targetVersion) {
            this.session.getChecksumStore().removeFileChecksum(targetVersion.getFileChecksum());
            renamedFile = this.session.getStorage().moveFile(originalVersion.getFile(), targetVersion.getFile());
        } else {
            renamedFile = this.session.getStorage().renameFile(originalVersion.getFile(), action.getNewVersion().getName());
        }
        fileChecksum.setFileID(DriveUtils.getFileID(renamedFile));
        fileChecksum.setVersion(renamedFile.getVersion());
        fileChecksum.setSequenceNumber(renamedFile.getSequenceNumber());
        FileChecksum updatedFileChecksum = this.session.getChecksumStore().updateFileChecksum(fileChecksum);
        action.setResultingVersion(new ServerFileVersion(renamedFile, updatedFileChecksum));
    }

    private void download(AbstractAction<FileVersion> action) throws OXException {
        File file;
        File reloadedSourceFile;
        if (null == action.getVersion() && "d41d8cd98f00b204e9800998ecf8427e".equals(action.getNewVersion().getChecksum())) {
            DefaultFile metadata = new DefaultFile();
            metadata.setFileSize(0L);
            metadata.setFileMD5Sum("d41d8cd98f00b204e9800998ecf8427e");
            metadata.setVersion("1");
            metadata.setVersionComment(this.session.getStorage().getVersionComment());
            UnsynchronizedByteArrayInputStream data = new UnsynchronizedByteArrayInputStream(new byte[0]);
            File createdFile = this.session.getStorage().createFile(this.path, action.getNewVersion().getName(), (File)metadata, (InputStream)data);
            FileChecksum insertedFileChecksum = this.session.getChecksumStore().insertFileChecksum(new FileChecksum(DriveUtils.getFileID(createdFile), createdFile.getVersion(), createdFile.getSequenceNumber(), "d41d8cd98f00b204e9800998ecf8427e"));
            action.setResultingVersion(new ServerFileVersion(createdFile, insertedFileChecksum));
            return;
        }
        ServerFileVersion sourceVersion = (ServerFileVersion)action.getParameters().get("sourceVersion");
        File sourceFile = sourceVersion.getFile();
        if (null == sourceFile.getVersion() && (null == (reloadedSourceFile = this.session.getStorage().getFile(sourceFile.getId(), sourceFile.getVersion())) || sourceFile.getSequenceNumber() != reloadedSourceFile.getSequenceNumber())) {
            throw DriveExceptionCodes.FILEVERSION_NOT_FOUND.create(sourceVersion.getName(), sourceVersion.getChecksum(), this.path);
        }
        File targetFile = null;
        if (null != action.getVersion() && null != (file = this.session.getStorage().getFileByName(this.path, action.getVersion().getName(), true)) && ChecksumProvider.matches(this.session, file, action.getVersion().getChecksum())) {
            targetFile = file;
        }
        if (null != targetFile) {
            this.session.getChecksumStore().removeFileChecksum(DriveUtils.getFileID(targetFile), targetFile.getVersion(), targetFile.getSequenceNumber());
        }
        if (sourceFile.isCurrentVersion() && FileActionExecutor.isFromTemp(this.session, sourceFile)) {
            File movedFile = null != targetFile ? this.session.getStorage().moveFile(sourceFile, targetFile) : this.session.getStorage().moveFile(sourceFile, action.getNewVersion().getName(), this.path);
            FileChecksum fileChecksum = sourceVersion.getFileChecksum();
            fileChecksum.setFileID(DriveUtils.getFileID(movedFile));
            fileChecksum.setVersion(movedFile.getVersion());
            fileChecksum.setSequenceNumber(movedFile.getSequenceNumber());
            FileChecksum updatedFileChecksum = this.session.getChecksumStore().updateFileChecksum(fileChecksum);
            action.setResultingVersion(new ServerFileVersion(movedFile, updatedFileChecksum));
        } else {
            try {
                File copiedFile = null != targetFile ? this.session.getStorage().copyFile(sourceFile, targetFile) : this.session.getStorage().copyFile(sourceFile, action.getNewVersion().getName(), this.path);
                FileChecksum insertedFileChecksum = this.session.getChecksumStore().insertFileChecksum(new FileChecksum(DriveUtils.getFileID(copiedFile), copiedFile.getVersion(), copiedFile.getSequenceNumber(), sourceVersion.getChecksum()));
                action.setResultingVersion(new ServerFileVersion(copiedFile, insertedFileChecksum));
            }
            catch (OXException e) {
                if ("FLS-0017".equals(e.getErrorCode())) {
                    this.session.getChecksumStore().removeFileChecksums(DriveUtils.getFileID(sourceFile));
                }
                throw e;
            }
        }
    }

    private void remove(AbstractAction<FileVersion> action) throws OXException {
        ServerFileVersion versionToRemove = ServerFileVersion.valueOf(action.getVersion(), this.path, this.session);
        FileChecksum fileChecksum = versionToRemove.getFileChecksum();
        if (this.session.getStorage().hasTrashFolder()) {
            this.session.getStorage().deleteFile(versionToRemove.getFile(), false);
            this.session.getChecksumStore().removeFileChecksum(fileChecksum);
        } else if (!this.session.hasTempFolder() || "d41d8cd98f00b204e9800998ecf8427e".equals(fileChecksum.getChecksum())) {
            this.session.getStorage().deleteFile(versionToRemove.getFile(), true);
            this.session.getChecksumStore().removeFileChecksum(fileChecksum);
        } else {
            try {
                File removedFile = this.session.getStorage().moveFile(versionToRemove.getFile(), versionToRemove.getChecksum(), "/.drive");
                if (versionToRemove.getChecksum().equals(removedFile.getFileName())) {
                    fileChecksum.setFileID(DriveUtils.getFileID(removedFile));
                    fileChecksum.setVersion(removedFile.getVersion());
                    fileChecksum.setSequenceNumber(removedFile.getSequenceNumber());
                    this.session.getChecksumStore().updateFileChecksum(fileChecksum);
                } else {
                    this.session.getStorage().deleteFile(removedFile, true);
                    this.session.getChecksumStore().removeFileChecksum(fileChecksum);
                }
            }
            catch (OXException e) {
                LOG.debug("Error moving file to temp folder - performing hard-delete instead.", (Throwable)e);
                this.session.getStorage().deleteFile(versionToRemove.getFile(), true);
                this.session.getChecksumStore().removeFileChecksum(fileChecksum);
            }
        }
    }

    private void batchRemove(List<AbstractAction<FileVersion>> removeActions) throws OXException {
        if (this.session.getStorage().hasTrashFolder()) {
            HashMap<File, FileChecksum> filesToRemove = new HashMap<File, FileChecksum>(removeActions.size());
            for (AbstractAction<FileVersion> action : removeActions) {
                if (!Action.REMOVE.equals((Object)action.getAction())) {
                    throw new IllegalArgumentException(action.getAction().toString());
                }
                ServerFileVersion fileVersion = ServerFileVersion.valueOf((FileVersion)action.getVersion(), this.path, this.session);
                filesToRemove.put(fileVersion.getFile(), fileVersion.getFileChecksum());
            }
            List<File> notRemovedFiles = this.session.getStorage().deleteFiles(new ArrayList<File>(filesToRemove.keySet()), false);
            for (File file : notRemovedFiles) {
                filesToRemove.remove(file);
            }
            if (0 < filesToRemove.size()) {
                this.session.getChecksumStore().removeFileChecksums(new ArrayList<FileChecksum>(filesToRemove.values()));
            }
        } else {
            List<FileChecksum> knownChecksums;
            FileStorageFolder tempFolder;
            ArrayList<ServerFileVersion> versionsToDelete = new ArrayList<ServerFileVersion>();
            ArrayList<ServerFileVersion> versionsToRemove = new ArrayList<ServerFileVersion>();
            HashSet<String> checksumsToBeRemoved = new HashSet<String>();
            for (AbstractAction<FileVersion> action : removeActions) {
                if (!Action.REMOVE.equals((Object)action.getAction())) {
                    throw new IllegalArgumentException(action.getAction().toString());
                }
                ServerFileVersion fileVersion = ServerFileVersion.valueOf((FileVersion)action.getVersion(), this.path, this.session);
                if (!this.session.hasTempFolder() || "d41d8cd98f00b204e9800998ecf8427e".equals(fileVersion.getChecksum()) || 20 <= versionsToRemove.size() || checksumsToBeRemoved.contains(fileVersion.getChecksum())) {
                    versionsToDelete.add(fileVersion);
                    continue;
                }
                versionsToRemove.add(fileVersion);
                checksumsToBeRemoved.add(fileVersion.getChecksum());
            }
            if (5 < versionsToRemove.size() && null != (tempFolder = this.session.getStorage().optFolder("/.drive", false)) && null != (knownChecksums = this.session.getChecksumStore().getFileChecksums(new FolderID(tempFolder.getId()))) && 0 < knownChecksums.size()) {
                Iterator iterator = versionsToRemove.iterator();
                while (iterator.hasNext()) {
                    ServerFileVersion versionToRemove = (ServerFileVersion)iterator.next();
                    boolean alreadyKnown = false;
                    for (FileChecksum knownChecksum : knownChecksums) {
                        if (!knownChecksum.getChecksum().equals(versionToRemove.getChecksum())) continue;
                        alreadyKnown = true;
                        break;
                    }
                    if (!alreadyKnown) continue;
                    versionsToDelete.add(versionToRemove);
                    iterator.remove();
                }
            }
            if (0 < versionsToRemove.size()) {
                ArrayList<FileChecksum> checksumsToUpdate = new ArrayList<FileChecksum>();
                for (ServerFileVersion versionToRemove : versionsToRemove) {
                    FileChecksum fileChecksum = versionToRemove.getFileChecksum();
                    try {
                        File removedFile = this.session.getStorage().moveFile(versionToRemove.getFile(), versionToRemove.getChecksum(), "/.drive");
                        if (versionToRemove.getChecksum().equals(removedFile.getFileName())) {
                            fileChecksum.setFileID(DriveUtils.getFileID(removedFile));
                            fileChecksum.setVersion(removedFile.getVersion());
                            fileChecksum.setSequenceNumber(removedFile.getSequenceNumber());
                            checksumsToUpdate.add(fileChecksum);
                            continue;
                        }
                        versionsToDelete.add(new ServerFileVersion(removedFile, fileChecksum));
                    }
                    catch (OXException e) {
                        LOG.debug("Error moving file to temp folder - performing hard-delete instead.", (Throwable)e);
                        versionsToDelete.add(versionToRemove);
                    }
                }
                if (0 < checksumsToUpdate.size()) {
                    this.session.getChecksumStore().updateFileChecksums(checksumsToUpdate);
                }
            }
            if (0 < versionsToDelete.size()) {
                ArrayList<FileChecksum> checksumsToRemove = new ArrayList<FileChecksum>();
                ArrayList<String> ids = new ArrayList<String>();
                long sequenceNumber = 0L;
                for (ServerFileVersion versionToDelete : versionsToDelete) {
                    ids.add(versionToDelete.getFile().getId());
                    sequenceNumber = Math.max(sequenceNumber, versionToDelete.getFile().getSequenceNumber());
                    checksumsToRemove.add(versionToDelete.getFileChecksum());
                }
                List notRemovedIDs = this.session.getStorage().getFileAccess().removeDocument(ids, sequenceNumber, true);
                for (String notRemovedID : notRemovedIDs) {
                }
                if (0 < checksumsToRemove.size()) {
                    this.session.getChecksumStore().removeFileChecksums(checksumsToRemove);
                }
            }
        }
    }

    private static boolean isFromTemp(SyncSession session, File file) throws OXException {
        if (session.hasTempFolder()) {
            String tempFolderID = session.getStorage().getFolderID("/.drive");
            if (tempFolderID.equals(file.getFolderId())) {
                return true;
            }
            FileStorageFolder folder = session.getStorage().getFolderAccess().getFolder(file.getFolderId());
            return null != folder && tempFolderID.equals(folder.getParentId());
        }
        return false;
    }
}

