/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.storage.execute;

import com.openexchange.drive.Action;
import com.openexchange.drive.DirectoryVersion;
import com.openexchange.drive.DriveUtils;
import com.openexchange.drive.actions.AbstractAction;
import com.openexchange.drive.actions.ErrorDirectoryAction;
import com.openexchange.drive.checksum.FileChecksum;
import com.openexchange.drive.comparison.ServerFileVersion;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.storage.execute.BatchActionExecutor;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStoragePermission;
import com.openexchange.file.storage.composition.FolderID;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DirectoryActionExecutor
extends BatchActionExecutor<DirectoryVersion> {
    public DirectoryActionExecutor(SyncSession session, boolean transactional, boolean allowBatches) {
        super(session, transactional, allowBatches);
    }

    @Override
    protected void batchExecute(Action action, List<AbstractAction<DirectoryVersion>> actions) throws OXException {
        switch (action) {
            case REMOVE: {
                this.batchRemove(actions);
                break;
            }
            default: {
                for (AbstractAction<DirectoryVersion> driveAction : actions) {
                    this.execute(driveAction);
                }
            }
        }
    }

    @Override
    protected void execute(AbstractAction<DirectoryVersion> action) throws OXException {
        switch (action.getAction()) {
            case EDIT: {
                this.edit(action);
                break;
            }
            case REMOVE: {
                this.remove(action);
                break;
            }
            case SYNC: {
                this.sync(action);
                break;
            }
            default: {
                throw new IllegalStateException("Can't perform action " + action + " on server");
            }
        }
    }

    private void sync(AbstractAction<DirectoryVersion> action) throws OXException {
        if (Boolean.TRUE.equals(action.getParameters().get("reset"))) {
            if (null == action.getVersion()) {
                for (Map.Entry<String, FileStorageFolder> entry : this.session.getStorage().getFolders().entrySet()) {
                    FolderID id = new FolderID(entry.getValue().getId());
                    this.session.getChecksumStore().removeDirectoryChecksum(id);
                    this.session.getChecksumStore().removeFileChecksumsInFolder(id);
                }
            } else {
                FileStorageFolder folder = this.session.getStorage().optFolder(action.getVersion().getPath(), false);
                if (null != folder) {
                    FolderID id = new FolderID(folder.getId());
                    this.session.getChecksumStore().removeDirectoryChecksum(id);
                    this.session.getChecksumStore().removeFileChecksumsInFolder(id);
                }
            }
        } else if (null != action.getVersion()) {
            try {
                this.session.getStorage().getFolderID(action.getVersion().getPath(), true);
            }
            catch (OXException e) {
                if (DriveUtils.indicatesFailedSave(e)) {
                    this.addNewActionForClient(new ErrorDirectoryAction(null, action.getVersion(), null, e, true, false));
                }
                throw e;
            }
        } else {
            throw new IllegalStateException("Can't perform action " + action + " on server");
        }
    }

    private void edit(AbstractAction<DirectoryVersion> action) throws OXException {
        String newFolderID;
        if (null == action.getNewVersion() && null != action.getVersion() && "d41d8cd98f00b204e9800998ecf8427e".equals(action.getVersion().getChecksum())) {
            try {
                this.session.getStorage().getFolderID(action.getVersion().getPath(), true);
                return;
            }
            catch (OXException e) {
                if (DriveUtils.indicatesFailedSave(e)) {
                    DirectoryVersion clientVersion = null != action.getComparison() && null != action.getComparison().getClientVersion() ? action.getComparison().getClientVersion() : action.getVersion();
                    this.addNewActionForClient(new ErrorDirectoryAction(null, clientVersion, null, e, true, false));
                    return;
                }
                throw e;
            }
        }
        String folderID = this.session.getStorage().getFolderID(action.getVersion().getPath());
        try {
            newFolderID = this.session.getStorage().moveFolder(action.getVersion().getPath(), action.getNewVersion().getPath());
        }
        catch (OXException e) {
            if (DriveUtils.indicatesFailedSave(e)) {
                this.addNewActionForClient(new ErrorDirectoryAction(action.getVersion(), action.getNewVersion(), null, e, true, false));
                return;
            }
            throw e;
        }
        if (!folderID.equals(newFolderID)) {
            this.session.getChecksumStore().updateFileChecksumFolders(new FolderID(folderID), new FolderID(newFolderID));
            this.session.getChecksumStore().updateDirectoryChecksumFolder(new FolderID(folderID), new FolderID(newFolderID));
        }
    }

    private void remove(AbstractAction<DirectoryVersion> action) throws OXException {
        if (this.session.getStorage().hasTrashFolder()) {
            String folderID = this.session.getStorage().deleteFolder(action.getVersion().getPath(), false);
            this.session.getChecksumStore().removeDirectoryChecksum(new FolderID(folderID));
            if (!"d41d8cd98f00b204e9800998ecf8427e".equals(action.getVersion().getChecksum())) {
                this.session.getChecksumStore().removeFileChecksumsInFolder(new FolderID(folderID));
            }
        } else if ("d41d8cd98f00b204e9800998ecf8427e".equals(action.getVersion().getChecksum())) {
            String folderID = this.session.getStorage().deleteFolder(action.getVersion().getPath(), true);
            this.session.getChecksumStore().removeDirectoryChecksum(new FolderID(folderID));
        } else if (this.session.hasTempFolder()) {
            FileStoragePermission sourceFolderPermission = this.session.getStorage().getOwnPermission(action.getVersion().getPath());
            FileStoragePermission targetFolderPermission = this.session.getStorage().getOwnPermission("/.drive");
            if (8 <= targetFolderPermission.getFolderPermission() && 128 <= sourceFolderPermission.getFolderPermission()) {
                String targetPath = "/.drive/" + action.getVersion().getChecksum();
                FileStorageFolder targetFolder = this.session.getStorage().optFolder(targetPath, false);
                if (null == targetFolder) {
                    String movedFolderID;
                    String currentFolderID = this.session.getStorage().getFolderID(action.getVersion().getPath());
                    if (!currentFolderID.equals(movedFolderID = this.session.getStorage().moveFolder(action.getVersion().getPath(), targetPath))) {
                        this.session.getChecksumStore().updateFileChecksumFolders(new FolderID(currentFolderID), new FolderID(movedFolderID));
                        this.session.getChecksumStore().updateDirectoryChecksumFolder(new FolderID(currentFolderID), new FolderID(movedFolderID));
                    }
                } else {
                    FolderID deletedFolderID = new FolderID(this.session.getStorage().deleteFolder(action.getVersion().getPath(), true));
                    this.session.getChecksumStore().removeDirectoryChecksum(deletedFolderID);
                    this.session.getChecksumStore().removeFileChecksumsInFolder(deletedFolderID);
                }
            } else {
                ArrayList<FileChecksum> checksumsToUpdate = new ArrayList<FileChecksum>();
                ArrayList<FileChecksum> checksumsToRemove = new ArrayList<FileChecksum>();
                ArrayList<File> filesToRemove = new ArrayList<File>();
                for (ServerFileVersion versionToRemove : this.session.getServerFiles(action.getVersion().getPath())) {
                    FileChecksum fileChecksum = versionToRemove.getFileChecksum();
                    File removedFile = this.session.getStorage().moveFile(versionToRemove.getFile(), versionToRemove.getChecksum(), "/.drive");
                    if (versionToRemove.getChecksum().equals(removedFile.getFileName())) {
                        fileChecksum.setFileID(DriveUtils.getFileID(removedFile));
                        fileChecksum.setVersion(removedFile.getVersion());
                        fileChecksum.setSequenceNumber(removedFile.getSequenceNumber());
                        checksumsToUpdate.add(fileChecksum);
                        continue;
                    }
                    checksumsToRemove.add(fileChecksum);
                    filesToRemove.add(removedFile);
                }
                if (0 < checksumsToUpdate.size()) {
                    this.session.getChecksumStore().updateFileChecksums(checksumsToUpdate);
                }
                if (0 < checksumsToRemove.size()) {
                    this.session.getChecksumStore().removeFileChecksums(checksumsToRemove);
                }
                if (0 < filesToRemove.size()) {
                    this.session.getStorage().deleteFiles(filesToRemove, true);
                }
                String folderID = this.session.getStorage().deleteFolder(action.getVersion().getPath(), true);
                this.session.getChecksumStore().removeDirectoryChecksum(new FolderID(folderID));
            }
        } else {
            String folderID = this.session.getStorage().deleteFolder(action.getVersion().getPath(), true);
            this.session.getChecksumStore().removeDirectoryChecksum(new FolderID(folderID));
            this.session.getChecksumStore().removeFileChecksumsInFolder(new FolderID(folderID));
        }
    }

    private void batchRemove(List<AbstractAction<DirectoryVersion>> removeActions) throws OXException {
        ArrayList<FolderID> removedFolderIDs = new ArrayList<FolderID>();
        ArrayList<FolderID[]> updatedFolderIDs = new ArrayList<FolderID[]>();
        for (AbstractAction<DirectoryVersion> action : removeActions) {
            String folderID;
            if (!Action.REMOVE.equals((Object)action.getAction())) {
                throw new IllegalStateException("Can't perform action " + action + " on server");
            }
            if (this.session.getStorage().hasTrashFolder()) {
                folderID = this.session.getStorage().deleteFolder(action.getVersion().getPath(), false);
                removedFolderIDs.add(new FolderID(folderID));
                continue;
            }
            if ("d41d8cd98f00b204e9800998ecf8427e".equals(action.getVersion().getChecksum()) || !this.session.hasTempFolder() || !this.mayMove(action.getVersion().getPath(), "/.drive")) {
                folderID = this.session.getStorage().deleteFolder(action.getVersion().getPath());
                removedFolderIDs.add(new FolderID(folderID));
                continue;
            }
            String targetPath = "/.drive/" + action.getVersion().getChecksum();
            FileStorageFolder targetFolder = this.session.getStorage().optFolder(targetPath, false);
            if (null == targetFolder) {
                String movedFolderID;
                String currentFolderID = this.session.getStorage().getFolderID(action.getVersion().getPath());
                if (currentFolderID.equals(movedFolderID = this.session.getStorage().moveFolder(action.getVersion().getPath(), targetPath))) continue;
                updatedFolderIDs.add(new FolderID[]{new FolderID(currentFolderID), new FolderID(movedFolderID)});
                continue;
            }
            String folderID2 = this.session.getStorage().deleteFolder(action.getVersion().getPath());
            removedFolderIDs.add(new FolderID(folderID2));
        }
        if (0 < removedFolderIDs.size()) {
            this.session.getChecksumStore().removeDirectoryChecksums(removedFolderIDs);
            this.session.getChecksumStore().removeFileChecksumsInFolders(removedFolderIDs);
        }
        if (0 < updatedFolderIDs.size()) {
            for (FolderID[] folderIDs : updatedFolderIDs) {
                this.session.getChecksumStore().updateDirectoryChecksumFolder(folderIDs[0], folderIDs[1]);
                this.session.getChecksumStore().updateFileChecksumFolders(folderIDs[0], folderIDs[1]);
            }
        }
    }

    private boolean mayMove(String fromPath, String toPath) throws OXException {
        return false == "/".equals(fromPath) && this.session.getStorage().getOwnPermission(fromPath).isAdmin() && 8 <= this.session.getStorage().getOwnPermission(toPath).getFolderPermission();
    }
}

