/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.storage.execute;

import com.openexchange.drive.Action;
import com.openexchange.drive.DriveVersion;
import com.openexchange.drive.actions.AbstractAction;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.storage.StorageOperation;
import com.openexchange.drive.storage.execute.AbstractActionExecutor;
import com.openexchange.exception.OXException;
import java.util.List;

public abstract class BatchActionExecutor<T extends DriveVersion>
extends AbstractActionExecutor<T> {
    protected final boolean allowBatches;

    protected BatchActionExecutor(SyncSession session, boolean transactional, boolean allowBatches) {
        super(session, transactional);
        this.allowBatches = allowBatches;
    }

    @Override
    public void execute(List<AbstractAction<T>> actions) throws OXException {
        if (null == actions || 0 == actions.size()) {
            return;
        }
        if (!this.allowBatches) {
            super.execute(actions);
            return;
        }
        int currentBatchStart = 0;
        Action currentAction = actions.get(0).getAction();
        for (int i = 1; i < actions.size(); ++i) {
            if (currentAction.equals((Object)actions.get(i).getAction())) continue;
            this.execute(currentAction, actions.subList(currentBatchStart, i));
            currentBatchStart = i;
            currentAction = actions.get(i).getAction();
        }
        this.execute(currentAction, actions.subList(currentBatchStart, actions.size()));
    }

    private void execute(final Action action, final List<AbstractAction<T>> actions) throws OXException {
        if (this.transactional) {
            this.session.getStorage().wrapInTransaction(new StorageOperation<Void>(){

                @Override
                public Void call() throws OXException {
                    if (1 == actions.size()) {
                        BatchActionExecutor.this.execute((AbstractAction)actions.get(0));
                    } else {
                        BatchActionExecutor.this.batchExecute(action, actions);
                    }
                    return null;
                }
            });
        } else if (1 == actions.size()) {
            this.execute(actions.get(0));
        } else {
            this.batchExecute(action, actions);
        }
    }

    protected abstract void batchExecute(Action var1, List<AbstractAction<T>> var2) throws OXException;
}

