/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.storage.execute;

import com.openexchange.drive.DriveVersion;
import com.openexchange.drive.actions.AbstractAction;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.storage.StorageOperation;
import com.openexchange.drive.storage.execute.ActionExecutor;
import com.openexchange.exception.OXException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractActionExecutor<T extends DriveVersion>
implements ActionExecutor<T> {
    protected final SyncSession session;
    protected final boolean transactional;
    private List<AbstractAction<T>> newActionsForClient;

    protected AbstractActionExecutor(SyncSession session, boolean transactional) {
        this.session = session;
        this.transactional = transactional;
    }

    protected void addNewActionForClient(AbstractAction<T> action) {
        if (null == this.newActionsForClient) {
            this.newActionsForClient = new ArrayList<AbstractAction<T>>();
        }
        this.newActionsForClient.add(action);
    }

    protected void addNewActionsForClient(Collection<? extends AbstractAction<T>> actions) {
        if (null == this.newActionsForClient) {
            this.newActionsForClient = new ArrayList<AbstractAction<T>>();
        }
        this.newActionsForClient.addAll(actions);
    }

    @Override
    public List<AbstractAction<T>> getNewActionsForClient() {
        return this.newActionsForClient;
    }

    @Override
    public void execute(List<AbstractAction<T>> actions) throws OXException {
        if (null == actions || 0 == actions.size()) {
            return;
        }
        for (final AbstractAction<T> action : actions) {
            if (this.transactional) {
                this.session.getStorage().wrapInTransaction(new StorageOperation<Void>(){

                    @Override
                    public Void call() throws OXException {
                        AbstractActionExecutor.this.execute(action);
                        return null;
                    }
                });
                continue;
            }
            this.execute(action);
        }
    }

    protected abstract void execute(AbstractAction<T> var1) throws OXException;
}

