/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.management;

import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.drive.DriveClientType;
import com.openexchange.drive.DriveClientVersion;
import com.openexchange.drive.DriveConstants;
import com.openexchange.drive.internal.DriveServiceLookup;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.server.Initialization;
import com.openexchange.tools.strings.TimeSpanParser;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriveConfig
implements Initialization {
    private static final Logger LOG = LoggerFactory.getLogger(DriveConfig.class);
    private static final DriveConfig instance = new DriveConfig();
    private final AtomicBoolean started = new AtomicBoolean();
    private boolean useTempFolder;
    private long cleanerInterval;
    private long cleanerMaxAge;
    private int maxBandwidth;
    private int maxBandwidthPerClient;
    private int maxConcurrentSyncOperations;
    private String directLinkQuota;
    private String directLinkHelp;
    private Pattern excludedFilenamesPattern;
    private Pattern excludedDirectoriesPattern;
    private String shortProductName;
    private int minApiVersion;
    private int maxDirectoryActions;
    private int maxFileActions;
    private String directLinkFragmentsFile;
    private String directLinkFile;
    private int[] previewImageSize;
    private int[] thumbnailImageSize;
    private String imageLinkImageFile;
    private String imageLinkAudioFile;
    private String imageLinkDocumentFile;
    private String directLinkFragmentsDirectory;
    private String directLinkDirectory;
    private String uiWebPath;
    private String dispatcherPrefix;
    private EnumMap<DriveClientType, DriveClientVersion> softMinimumVersions;
    private EnumMap<DriveClientType, DriveClientVersion> hardMinimumVersions;

    public static DriveConfig getInstance() {
        return instance;
    }

    private DriveConfig() {
    }

    public void start() throws OXException {
        if (!this.started.compareAndSet(false, true)) {
            LOG.warn("Already started - aborting.");
            return;
        }
        this.load(DriveServiceLookup.getService(ConfigurationService.class, true));
    }

    public void stop() throws OXException {
        if (!this.started.compareAndSet(true, false)) {
            LOG.warn("Not started - aborting.");
            return;
        }
    }

    public boolean isUseTempFolder() {
        return this.useTempFolder;
    }

    public long getCleanerInterval() {
        return this.cleanerInterval;
    }

    public long getCleanerMaxAge() {
        return this.cleanerMaxAge;
    }

    public int getMaxBandwidth() {
        return this.maxBandwidth;
    }

    public int getMaxBandwidthPerClient() {
        return this.maxBandwidthPerClient;
    }

    public int getMaxConcurrentSyncOperations() {
        return this.maxConcurrentSyncOperations;
    }

    public String getDirectLinkQuota() {
        return this.directLinkQuota;
    }

    public String getDirectLinkHelp() {
        return this.directLinkHelp;
    }

    public Pattern getExcludedFilenamesPattern() {
        return this.excludedFilenamesPattern;
    }

    public Pattern getExcludedDirectoriesPattern() {
        return this.excludedDirectoriesPattern;
    }

    public String getShortProductName() {
        return this.shortProductName;
    }

    public int getMinApiVersion() {
        return this.minApiVersion;
    }

    public int getMaxDirectoryActions() {
        return this.maxDirectoryActions;
    }

    public int getMaxFileActions() {
        return this.maxFileActions;
    }

    public String getDirectLinkFragmentsFile() {
        return this.directLinkFragmentsFile;
    }

    public String getDirectLinkFile() {
        return this.directLinkFile;
    }

    public int[] getThumbnailImageSize() {
        return this.thumbnailImageSize;
    }

    public int[] getPreviewImageSize() {
        return this.previewImageSize;
    }

    public String getImageLinkDocumentFile() {
        return this.imageLinkDocumentFile;
    }

    public String getDirectLinkDirectory() {
        return this.directLinkDirectory;
    }

    public String getDirectLinkFragmentsDirectory() {
        return this.directLinkFragmentsDirectory;
    }

    public String getImageLinkAudioFile() {
        return this.imageLinkAudioFile;
    }

    public String getImageLinkImageFile() {
        return this.imageLinkImageFile;
    }

    public String getUiWebPath() {
        return this.uiWebPath;
    }

    public String getDispatcherPrefix() {
        return this.dispatcherPrefix;
    }

    private void load(ConfigurationService configService) throws OXException {
        String maxBandwidthValue;
        this.minApiVersion = configService.getIntProperty("com.openexchange.drive.minApiVersion", DriveConstants.DEFAULT_MIN_API_VERSION);
        this.shortProductName = configService.getProperty("com.openexchange.drive.shortProductName", "OX Drive");
        try {
            this.excludedFilenamesPattern = Pattern.compile(configService.getProperty("com.openexchange.drive.excludedFilesPattern", "thumbs\\.db|desktop\\.ini|\\.ds_store|icon\\\r|\\.msngr_hstr_data_.*\\.log"), 66);
        }
        catch (PatternSyntaxException e) {
            throw ConfigurationExceptionCodes.INVALID_CONFIGURATION.create((Throwable)e, new Object[]{"com.openexchange.drive.excludedFilesPattern"});
        }
        try {
            this.excludedDirectoriesPattern = Pattern.compile(configService.getProperty("com.openexchange.drive.excludedDirectoriesPattern", "^.*/\\.msngr_hstr_data$"), 66);
        }
        catch (PatternSyntaxException e) {
            throw ConfigurationExceptionCodes.INVALID_CONFIGURATION.create((Throwable)e, new Object[]{"com.openexchange.drive.excludedDirectoriesPattern"});
        }
        this.useTempFolder = configService.getBoolProperty("com.openexchange.drive.useTempFolder", true);
        long MILLIS_PER_HOUR = 3600000L;
        String cleanerIntervalValue = configService.getProperty("com.openexchange.drive.cleaner.interval", "1D");
        try {
            this.cleanerInterval = TimeSpanParser.parseTimespan((String)cleanerIntervalValue);
        }
        catch (IllegalArgumentException e) {
            throw ConfigurationExceptionCodes.INVALID_CONFIGURATION.create((Throwable)e, new Object[]{cleanerIntervalValue});
        }
        if (3600000L > this.cleanerInterval) {
            LOG.warn("The configured interval of ''{}'' is smaller than the allowed minimum of one hour. Falling back to ''1h'' instead.", (Object)cleanerIntervalValue);
            this.cleanerInterval = 3600000L;
        }
        String cleanerMaxAgeValue = configService.getProperty("com.openexchange.drive.cleaner.maxAge", "1D");
        try {
            this.cleanerMaxAge = TimeSpanParser.parseTimespan((String)cleanerMaxAgeValue);
        }
        catch (IllegalArgumentException e) {
            throw ConfigurationExceptionCodes.INVALID_CONFIGURATION.create((Throwable)e, new Object[]{cleanerMaxAgeValue});
        }
        if (3600000L > this.cleanerMaxAge) {
            LOG.warn("The configured interval of ''{}'' is smaller than the allowed minimum of one hour. Falling back to ''1h'' instead.", (Object)cleanerMaxAgeValue);
            this.cleanerMaxAge = 3600000L;
        }
        this.maxBandwidth = Strings.isEmpty((String)(maxBandwidthValue = configService.getProperty("com.openexchange.drive.maxBandwidth"))) || "-1".equals(maxBandwidthValue) ? -1 : DriveConfig.parseBytes(maxBandwidthValue);
        String maxBandwidthPerClientValue = configService.getProperty("com.openexchange.drive.maxBandwidthPerClient");
        this.maxBandwidthPerClient = Strings.isEmpty((String)maxBandwidthPerClientValue) || "-1".equals(maxBandwidthPerClientValue) ? -1 : DriveConfig.parseBytes(maxBandwidthPerClientValue);
        this.maxConcurrentSyncOperations = configService.getIntProperty("com.openexchange.drive.maxConcurrentSyncOperations", -1);
        this.maxDirectoryActions = configService.getIntProperty("com.openexchange.drive.maxDirectoryActions", 1000);
        this.maxFileActions = configService.getIntProperty("com.openexchange.drive.maxFileActions", 500);
        this.directLinkQuota = configService.getProperty("com.openexchange.drive.directLinkQuota", "[protocol]://[hostname]");
        this.directLinkHelp = configService.getProperty("com.openexchange.drive.directLinkHelp", "[protocol]://[hostname]/[uiwebpath]/help/[locale]/index.html");
        this.directLinkFragmentsFile = configService.getProperty("com.openexchange.drive.directLinkFragmentsFile", "m=infostore&f=[folder]&i=[object]");
        this.directLinkFile = configService.getProperty("com.openexchange.drive.directLinkFile", "[protocol]://[hostname]/[uiwebpath]#[filefragments]");
        this.previewImageSize = DriveConfig.parseDimensions(configService.getProperty("com.openexchange.drive.previewImageSize", "800x800"));
        this.thumbnailImageSize = DriveConfig.parseDimensions(configService.getProperty("com.openexchange.drive.thumbnailImageSize", "100x100"));
        this.imageLinkImageFile = configService.getProperty("com.openexchange.drive.imageLinkImageFile", "[protocol]://[hostname]/[dispatcherPrefix]/files?action=document&folder=[folder]&id=[object]&version=[version]&delivery=download&scaleType=contain&width=[width]&height=[height]&rotate=true");
        this.imageLinkAudioFile = configService.getProperty("com.openexchange.drive.imageLinkAudioFile", "[protocol]://[hostname]/[dispatcherPrefix]/image/file/mp3Cover?folder=[folder]&id=[object]&version=[version]&delivery=download&scaleType=contain&width=[width]&height=[height]");
        this.imageLinkDocumentFile = configService.getProperty("com.openexchange.drive.imageLinkDocumentFile", "[protocol]://[hostname]/[dispatcherPrefix]/files?action=document&format=preview_image&folder=[folder]&id=[object]&version=[version]&delivery=download&scaleType=contain&width=[width]&height=[height]");
        this.directLinkFragmentsDirectory = configService.getProperty("com.openexchange.drive.directLinkFragmentsDirectory", "m=infostore&f=[folder]");
        this.directLinkDirectory = configService.getProperty("com.openexchange.drive.directLinkDirectory", "[protocol]://[hostname]/[uiwebpath]#[directoryfragments]");
        this.uiWebPath = configService.getProperty("com.openexchange.UIWebPath", "/ox6/index.html");
        this.dispatcherPrefix = configService.getProperty("com.openexchange.dispatcher.prefix", "ajax");
        this.softMinimumVersions = new EnumMap(DriveClientType.class);
        this.hardMinimumVersions = new EnumMap(DriveClientType.class);
        this.softMinimumVersions.put(DriveClientType.WINDOWS, DriveConfig.parseClientVersion(configService.getProperty("com.openexchange.drive.version.windows.softMinimum", configService.getProperty("com.openexchange.drive.windows.version", "0"))));
        this.hardMinimumVersions.put(DriveClientType.WINDOWS, DriveConfig.parseClientVersion(configService.getProperty("com.openexchange.drive.version.windows.hardMinimum", configService.getProperty("com.openexchange.drive.windows.minimumVersion", "0"))));
        this.softMinimumVersions.put(DriveClientType.MAC_OS, DriveConfig.parseClientVersion(configService.getProperty("com.openexchange.drive.version.macos.softMinimum", "0")));
        this.hardMinimumVersions.put(DriveClientType.MAC_OS, DriveConfig.parseClientVersion(configService.getProperty("com.openexchange.drive.version.macos.hardMinimum", "0")));
        this.softMinimumVersions.put(DriveClientType.ANDROID, DriveConfig.parseClientVersion(configService.getProperty("com.openexchange.drive.version.android.softMinimum", "0")));
        this.softMinimumVersions.put(DriveClientType.IOS, DriveConfig.parseClientVersion(configService.getProperty("com.openexchange.drive.version.ios.softMinimum", "0")));
        this.hardMinimumVersions.put(DriveClientType.ANDROID, DriveConfig.parseClientVersion(configService.getProperty("com.openexchange.drive.version.android.hardMinimum", "0")));
        this.hardMinimumVersions.put(DriveClientType.IOS, DriveConfig.parseClientVersion(configService.getProperty("com.openexchange.drive.version.ios.hardMinimum", "0")));
    }

    private static DriveClientVersion parseClientVersion(String value) throws OXException {
        try {
            return Strings.isEmpty((String)value) ? DriveClientVersion.VERSION_0 : new DriveClientVersion(value);
        }
        catch (IllegalArgumentException e) {
            throw ConfigurationExceptionCodes.INVALID_CONFIGURATION.create(new Object[]{value});
        }
    }

    private static int[] parseDimensions(String value) throws OXException {
        int idx = value.indexOf(120);
        if (1 > idx) {
            throw ConfigurationExceptionCodes.INVALID_CONFIGURATION.create(new Object[]{value});
        }
        try {
            return new int[]{Integer.parseInt(value.substring(0, idx)), Integer.parseInt(value.substring(idx + 1))};
        }
        catch (NumberFormatException e) {
            throw ConfigurationExceptionCodes.INVALID_CONFIGURATION.create(new Object[]{1, value});
        }
    }

    private static int parseBytes(String value) throws NumberFormatException {
        StringBuilder numberAllocator = new StringBuilder(8);
        StringBuilder unitAllocator = new StringBuilder(4);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isDigit(c) || '.' == c || '-' == c) {
                numberAllocator.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            unitAllocator.append(c);
        }
        double number = Double.parseDouble(numberAllocator.toString());
        if (0 < unitAllocator.length()) {
            String unit = unitAllocator.toString().toUpperCase();
            int exp = Arrays.asList("B", "KB", "MB", "GB").indexOf(unit);
            if (0 <= exp) {
                number *= Math.pow(1024.0, exp);
            } else {
                throw new NumberFormatException(value);
            }
        }
        if (2.147483647E9 >= number) {
            return (int)number;
        }
        throw new NumberFormatException(value);
    }

    public DriveClientVersion getSoftMinimumVersion(DriveClientType clientType) {
        DriveClientVersion version = this.softMinimumVersions.get((Object)clientType);
        return null != version ? version : DriveClientVersion.VERSION_0;
    }

    public DriveClientVersion getHardMinimumVersion(DriveClientType clientType) {
        DriveClientVersion version = this.hardMinimumVersions.get((Object)clientType);
        return null != version ? version : DriveClientVersion.VERSION_0;
    }
}

