/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal.throttle;

import com.openexchange.drive.internal.throttle.DriveTokenBucket;
import com.openexchange.java.Streams;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;

public class BucketInputStream
extends InputStream {
    private static final AtomicReference<DriveTokenBucket> tokenBucketReference = new AtomicReference();
    private final InputStream delegate;
    private final ServerSession session;

    public static void setTokenBucket(DriveTokenBucket tokenBucket) {
        DriveTokenBucket previousTokenBucket;
        if (null == tokenBucket && null != (previousTokenBucket = tokenBucketReference.get())) {
            previousTokenBucket.stop();
        }
        tokenBucketReference.set(tokenBucket);
    }

    public BucketInputStream(InputStream delegate, ServerSession session) {
        this.delegate = delegate;
        this.session = session;
    }

    @Override
    public int read() throws IOException {
        this.blockingWait(1);
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.blockingWait(len);
        return this.delegate.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        Streams.close((Closeable)this.delegate);
        super.close();
    }

    private void blockingWait(int length) throws IOException {
        DriveTokenBucket tokenBucket = tokenBucketReference.get();
        if (null != tokenBucket && tokenBucket.isEnabled()) {
            try {
                tokenBucket.takeBlocking(this.session, length);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
    }
}

