/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal;

import com.openexchange.drive.DriveConstants;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.checksum.ChecksumProvider;
import com.openexchange.drive.internal.DriveServiceLookup;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.storage.DriveStorage;
import com.openexchange.drive.storage.StorageOperation;
import com.openexchange.drive.sync.RenameTools;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageCapability;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.search.FileNameTerm;
import com.openexchange.file.storage.search.OrTerm;
import com.openexchange.file.storage.search.SearchTerm;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.java.Streams;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jonelo.jacksum.util.Service;

public class UploadHelper {
    private final SyncSession session;

    public UploadHelper(SyncSession session) {
        this.session = session;
    }

    public File perform(final String path, final FileVersion originalVersion, final FileVersion newVersion, final InputStream uploadStream, final String contentType, final long offset, final long totalLength, final Date created, final Date modified) throws OXException {
        if (null == originalVersion && 0L >= offset && 0L < totalLength && 65536L >= totalLength) {
            Map.Entry<File, String> uploadEntry = this.session.getStorage().wrapInTransaction(new StorageOperation<Map.Entry<File, String>>(){

                @Override
                public Map.Entry<File, String> call() throws OXException {
                    return UploadHelper.this.saveOptimistically(path, newVersion, uploadStream, contentType, created, modified);
                }
            });
            String checksum = uploadEntry.getValue();
            File uploadFile = uploadEntry.getKey();
            if (null == checksum) {
                checksum = ChecksumProvider.getChecksum(this.session, uploadFile).getChecksum();
            }
            if (!checksum.equals(newVersion.getChecksum())) {
                this.session.getStorage().deleteFile(uploadFile, true);
                throw DriveExceptionCodes.UPLOADED_FILE_CHECKSUM_ERROR.create(checksum, newVersion.getName(), newVersion.getChecksum());
            }
            return uploadFile;
        }
        Map.Entry<File, String> uploadEntry = this.session.getStorage().wrapInTransaction(new StorageOperation<Map.Entry<File, String>>(){

            @Override
            public Map.Entry<File, String> call() throws OXException {
                return UploadHelper.this.upload(path, newVersion, uploadStream, contentType, offset, totalLength);
            }
        });
        String checksum = uploadEntry.getValue();
        final File uploadFile = uploadEntry.getKey();
        if (-1L == totalLength || uploadFile.getFileSize() >= totalLength) {
            if (null == checksum) {
                checksum = ChecksumProvider.getChecksum(this.session, uploadFile).getChecksum();
            }
            if (!checksum.equals(newVersion.getChecksum())) {
                this.session.getStorage().deleteFile(uploadFile);
                throw DriveExceptionCodes.UPLOADED_FILE_CHECKSUM_ERROR.create(checksum, newVersion.getName(), newVersion.getChecksum());
            }
            uploadFile.setFileMD5Sum(checksum);
            final String md5 = checksum;
            return this.session.getStorage().wrapInTransaction(new StorageOperation<File>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public File call() throws OXException {
                    ArrayList<File.Field> fields;
                    DefaultFile file;
                    long sequenceNumber;
                    block5: {
                        block6: {
                            sequenceNumber = uploadFile.getSequenceNumber();
                            file = new DefaultFile();
                            fields = new ArrayList<File.Field>();
                            file.setFileName(newVersion.getName());
                            fields.add(File.Field.FILENAME);
                            file.setVersionComment(UploadHelper.this.session.getStorage().getVersionComment());
                            fields.add(File.Field.VERSION_COMMENT);
                            file.setFileSize(uploadFile.getFileSize());
                            fields.add(File.Field.FILE_SIZE);
                            file.setFileMD5Sum(md5);
                            fields.add(File.Field.FILE_MD5SUM);
                            if (null != contentType) {
                                file.setFileMIMEType(contentType);
                                fields.add(File.Field.FILE_MIMETYPE);
                            }
                            if (null != created) {
                                file.setCreated(created);
                                fields.add(File.Field.CREATED);
                            }
                            Date now = new Date();
                            file.setLastModified(null != modified && modified.before(now) ? modified : now);
                            fields.add(File.Field.LAST_MODIFIED);
                            if (null == originalVersion) break block5;
                            File originalFile = UploadHelper.this.session.getStorage().getFileByName(path, originalVersion.getName(), true);
                            if (null == originalFile || !ChecksumProvider.matches(UploadHelper.this.session, originalFile, originalVersion.getChecksum())) break block6;
                            file.setId(originalFile.getId());
                            file.setFolderId(originalFile.getFolderId());
                            if (null != originalFile.getTitle() && originalFile.getTitle().equals(originalFile.getFileName())) {
                                file.setTitle(newVersion.getName());
                                fields.add(File.Field.TITLE);
                            }
                            InputStream data = null;
                            try {
                                data = UploadHelper.this.session.getStorage().getFileAccess().getDocument(uploadFile.getId(), uploadFile.getVersion());
                                UploadHelper.this.session.getStorage().getFileAccess().saveDocument((File)file, data, sequenceNumber, fields);
                            }
                            catch (Throwable throwable) {
                                Streams.close(data);
                                throw throwable;
                            }
                            Streams.close((Closeable)data);
                            UploadHelper.this.session.getStorage().deleteFile(uploadFile, true);
                            return file;
                        }
                        file.setId(uploadFile.getId());
                        file.setFolderId(UploadHelper.this.session.getStorage().getFolderID(path, true));
                        fields.add(File.Field.FOLDER_ID);
                        String alternativeName = RenameTools.findRandomAlternativeName(newVersion.getName(), UploadHelper.this.session.getDeviceName());
                        file.setFileName(alternativeName);
                        file.setTitle(alternativeName);
                        fields.add(File.Field.TITLE);
                        UploadHelper.this.session.getStorage().getFileAccess().saveFileMetadata((File)file, sequenceNumber, fields);
                        return file;
                    }
                    file.setId(uploadFile.getId());
                    file.setFolderId(UploadHelper.this.session.getStorage().getFolderID(path, true));
                    fields.add(File.Field.FOLDER_ID);
                    file.setTitle(newVersion.getName());
                    fields.add(File.Field.TITLE);
                    UploadHelper.this.session.getStorage().getFileAccess().saveFileMetadata((File)file, sequenceNumber, fields);
                    return file;
                }
            });
        }
        return null;
    }

    private Map.Entry<File, String> saveOptimistically(String path, FileVersion newVersion, InputStream uploadStream, String contentType, Date created, Date modified) throws OXException {
        DefaultFile file = new DefaultFile();
        ArrayList<File.Field> fields = new ArrayList<File.Field>();
        file.setFolderId(this.session.getStorage().getFolderID(path, true));
        fields.add(File.Field.FOLDER_ID);
        file.setFileName(newVersion.getName());
        fields.add(File.Field.FILENAME);
        file.setVersionComment(this.session.getStorage().getVersionComment());
        fields.add(File.Field.VERSION_COMMENT);
        if (null != contentType) {
            file.setFileMIMEType(contentType);
            fields.add(File.Field.FILE_MIMETYPE);
        }
        if (null != created) {
            file.setCreated(created);
            fields.add(File.Field.CREATED);
        }
        Date now = new Date();
        file.setLastModified(null != modified && modified.before(now) ? modified : now);
        fields.add(File.Field.LAST_MODIFIED);
        if (this.session.isTraceEnabled()) {
            String fullPath = this.session.getRootFolderID().equals(file.getFolderId()) ? "/" + file.getFileName() : this.session.getStorage().getPath(file.getFolderId()) + '/' + file.getFileName();
            this.session.trace(this.session.getStorage().toString() + ">> " + fullPath);
        }
        String checksum = this.saveDocumentAndChecksum((File)file, uploadStream, -1L, fields, false);
        return new AbstractMap.SimpleEntry<DefaultFile, String>(file, checksum);
    }

    Map.Entry<File, String> upload(String path, FileVersion newVersion, InputStream uploadStream, String contentType, long offset, long totalLength) throws OXException {
        File uploadFile = this.getUploadFile(path, newVersion.getChecksum(), true);
        if (offset != uploadFile.getFileSize()) {
            throw DriveExceptionCodes.INVALID_FILE_OFFSET.create(offset);
        }
        String checksum = null;
        IDBasedFileAccess fileAccess = this.session.getStorage().getFileAccess();
        List<File.Field> modifiedFields = Arrays.asList(File.Field.FILE_SIZE, File.Field.FILE_MIMETYPE, File.Field.VERSION_COMMENT);
        uploadFile.setVersionComment(this.session.getStorage().getVersionComment());
        uploadFile.setFileMIMEType(contentType);
        uploadFile.setFileSize(totalLength - offset);
        if (this.session.isTraceEnabled()) {
            String fullPath = this.session.getRootFolderID().equals(uploadFile.getFolderId()) ? "/" + uploadFile.getFileName() : this.session.getStorage().getPath(uploadFile.getFolderId()) + '/' + uploadFile.getFileName();
            this.session.trace(this.session.getStorage().toString() + ">> " + fullPath);
        }
        if (0L == offset) {
            checksum = this.saveDocumentAndChecksum(uploadFile, uploadStream, uploadFile.getSequenceNumber(), modifiedFields, false);
        } else if (this.session.getStorage().supports(FileStorageCapability.RANDOM_FILE_ACCESS)) {
            fileAccess.saveDocument(uploadFile, uploadStream, uploadFile.getSequenceNumber(), modifiedFields, offset);
        } else {
            checksum = this.appendViaTemporaryFile(uploadFile, uploadStream);
        }
        uploadFile = fileAccess.getFileMetadata(uploadFile.getId(), uploadFile.getVersion());
        return new AbstractMap.SimpleEntry<File, String>(uploadFile, checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String appendViaTemporaryFile(File uploadFile, InputStream uploadStream) throws OXException {
        ManagedFile managedFile = null;
        try {
            InputStream inputStream = null;
            try {
                inputStream = this.session.getStorage().getDocument(uploadFile);
                managedFile = UploadHelper.concatenateToFile(inputStream, uploadStream);
            }
            catch (Throwable throwable) {
                Streams.close(inputStream);
                throw throwable;
            }
            Streams.close((Closeable)inputStream);
            List<File.Field> modifiedFields = Arrays.asList(File.Field.FILE_SIZE);
            uploadFile.setFileSize(managedFile.getFile().length());
            String string = this.saveDocumentAndChecksum(uploadFile, managedFile.getInputStream(), uploadFile.getSequenceNumber(), modifiedFields, true);
            return string;
        }
        finally {
            if (null != managedFile) {
                DriveServiceLookup.getService(ManagedFileManagement.class, true).removeByID(managedFile.getID());
            }
        }
    }

    private String saveDocumentAndChecksum(File file, InputStream inputStream, long sequenceNumber, List<File.Field> modifiedFields, boolean ignoreVersion) throws OXException {
        String string;
        DigestInputStream digestStream = null;
        try {
            digestStream = new DigestInputStream(inputStream, MessageDigest.getInstance("MD5"));
            IDBasedFileAccess fileAccess = this.session.getStorage().getFileAccess();
            if (ignoreVersion && this.session.getStorage().supports(FileStorageCapability.IGNORABLE_VERSION)) {
                fileAccess.saveDocument(file, (InputStream)digestStream, sequenceNumber, modifiedFields, true);
            } else {
                fileAccess.saveDocument(file, (InputStream)digestStream, sequenceNumber, modifiedFields);
            }
            byte[] digest = digestStream.getMessageDigest().digest();
            string = Service.format((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                throw DriveExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Streams.close(digestStream);
                throw throwable;
            }
        }
        Streams.close((Closeable)digestStream);
        return string;
    }

    private File getUploadFile(String path, String checksum, boolean createIfAbsent) throws OXException {
        String uploadFileName = UploadHelper.getUploadFilename(checksum);
        String uploadPath = this.session.hasTempFolder() ? "/.drive" : path;
        File uploadFile = this.session.getStorage().getFileByName(uploadPath, uploadFileName);
        if (null == uploadFile && createIfAbsent) {
            if (this.session.isTraceEnabled()) {
                this.session.trace("Creating new upload file at: " + DriveStorage.combine(uploadPath, uploadFileName));
            }
            if (null != (uploadFile = this.session.getStorage().createFile(uploadPath, uploadFileName)) && this.session.isTraceEnabled()) {
                this.session.trace("Upload file created: [" + uploadFile.getFolderId() + '/' + uploadFile.getId() + ']');
            }
        } else if (null != uploadFile && this.session.isTraceEnabled()) {
            this.session.trace("Using existing upload file at " + DriveStorage.combine(uploadPath, uploadFileName) + " [" + uploadFile.getFolderId() + '/' + uploadFile.getId() + "], current size: " + uploadFile.getFileSize() + ", last modified: " + (null != uploadFile.getLastModified() ? DriveConstants.LOG_DATE_FORMAT.get().format(uploadFile.getLastModified()) : "(unknown)"));
        }
        return null == uploadFile ? null : new DefaultFile(uploadFile);
    }

    public long getUploadOffset(String path, FileVersion file) throws OXException {
        List<Long> offsets = this.getUploadOffsets(path, Collections.singletonList(file));
        return null != offsets && 0 < offsets.size() ? offsets.get(0) : 0L;
    }

    public List<Long> getUploadOffsets(String path, List<FileVersion> fileVersions) throws OXException {
        if (null == fileVersions || 0 == fileVersions.size()) {
            return Collections.emptyList();
        }
        ArrayList<Long> uploadOffsets = new ArrayList<Long>(fileVersions.size());
        String uploadPath = this.session.hasTempFolder() ? "/.drive" : path;
        String folderID = this.session.getStorage().getFolderID(uploadPath, false);
        List<File> files = this.findUploadFiles(folderID, fileVersions);
        for (FileVersion fileVersion : fileVersions) {
            String fileName = UploadHelper.getUploadFilename(fileVersion.getChecksum());
            long offset = 0L;
            for (File file : files) {
                if (!fileName.equals(file.getFileName())) continue;
                offset = file.getFileSize();
                break;
            }
            uploadOffsets.add(offset);
        }
        return uploadOffsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> findUploadFiles(final String folderID, final List<FileVersion> fileVersions) throws OXException {
        ArrayList<File> files = new ArrayList<File>();
        final List<File.Field> fields = Arrays.asList(File.Field.FILENAME, File.Field.FILE_SIZE);
        SearchIterator<File> searchIterator = null;
        try {
            searchIterator = this.session.getStorage().wrapInTransaction(new StorageOperation<SearchIterator<File>>(){

                @Override
                public SearchIterator<File> call() throws OXException {
                    if (UploadHelper.this.session.getStorage().supports(FileStorageCapability.SEARCH_BY_TERM)) {
                        return UploadHelper.this.session.getStorage().getFileAccess().search(Collections.singletonList(folderID), UploadHelper.getSearchTermForUploadFiles(fileVersions), fields, null, FileStorageFileAccess.SortDirection.DEFAULT, -11, -11);
                    }
                    String pattern = 1 == fileVersions.size() ? UploadHelper.getUploadFilename(((FileVersion)fileVersions.get(0)).getChecksum()) : "*.drivepart";
                    return UploadHelper.this.session.getStorage().getFileAccess().search(pattern, fields, folderID, null, FileStorageFileAccess.SortDirection.DEFAULT, -11, -11);
                }
            });
            block3: while (searchIterator.hasNext()) {
                File file = (File)searchIterator.next();
                if (null == file || null == file.getFileName()) continue;
                for (FileVersion fileVersion : fileVersions) {
                    String uploadFilename = UploadHelper.getUploadFilename(fileVersion.getChecksum());
                    if (!uploadFilename.equals(file.getFileName())) continue;
                    files.add(file);
                    continue block3;
                }
            }
        }
        finally {
            SearchIterators.close(searchIterator);
        }
        return files;
    }

    private static SearchTerm<?> getSearchTermForUploadFiles(List<FileVersion> filesToUpload) {
        if (null == filesToUpload || 0 == filesToUpload.size()) {
            return null;
        }
        if (1 == filesToUpload.size()) {
            String fileName = UploadHelper.getUploadFilename(filesToUpload.get(0).getChecksum());
            return new FileNameTerm(fileName, false, false);
        }
        ArrayList<FileNameTerm> terms = new ArrayList<FileNameTerm>();
        for (FileVersion fileVersion : filesToUpload) {
            String fileName = UploadHelper.getUploadFilename(fileVersion.getChecksum());
            terms.add(new FileNameTerm(fileName, false, false));
        }
        return new OrTerm(terms);
    }

    private static String getUploadFilename(String checksum) {
        return '.' + checksum + ".drivepart";
    }

    private static ManagedFile concatenateToFile(InputStream firstStream, InputStream secondStream) throws OXException {
        ManagedFileManagement fileManagement = DriveServiceLookup.getService(ManagedFileManagement.class, true);
        ManagedFile managedFile = fileManagement.createManagedFile(fileManagement.newTempFile());
        FileOutputStream outputStream = null;
        try {
            int read;
            outputStream = new FileOutputStream(managedFile.getFile(), true);
            byte[] buffer = new byte[4096];
            while ((read = firstStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, read);
            }
            while ((read = secondStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, read);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            try {
                throw DriveExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Streams.close(outputStream);
                throw throwable;
            }
        }
        Streams.close((Closeable)outputStream);
        return managedFile;
    }
}

