/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal;

import com.openexchange.drive.DriveConstants;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracer {
    public static final int MAX_SIZE = 100000;
    private static final Logger LOG = LoggerFactory.getLogger(Tracer.class);
    private final StringBuilder traceLog;

    public Tracer(Boolean clientDiagnostics) {
        this.traceLog = null != clientDiagnostics && clientDiagnostics != false ? new StringBuilder() : null;
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            int remainingCapacity;
            String msg = String.valueOf(message);
            LOG.trace(msg);
            if (null != this.traceLog && 0 < (remainingCapacity = 100000 - this.traceLog.length())) {
                this.traceLog.append(DriveConstants.LOG_DATE_FORMAT.get().format(new Date())).append(" [").append(Thread.currentThread().getId()).append("] : ");
                if (msg.length() <= remainingCapacity) {
                    this.traceLog.append(msg.trim()).append("\n\n");
                } else {
                    this.traceLog.append(msg.substring(0, remainingCapacity)).append("\n... (truncated)");
                }
            }
        }
    }

    public String getTraceLog() {
        return null != this.traceLog ? this.traceLog.toString() : null;
    }

    public boolean isTraceEnabled() {
        return LOG.isTraceEnabled() || null != this.traceLog;
    }
}

