/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal;

import com.openexchange.drive.DriveConstants;
import com.openexchange.drive.DriveUtils;
import com.openexchange.drive.checksum.ChecksumStore;
import com.openexchange.drive.internal.DriveServiceLookup;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.management.DriveConfig;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.osgi.ExceptionUtils;
import com.openexchange.session.Session;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempCleaner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TempCleaner.class);
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final String PARAM_LAST_CLEANER_RUN = "com.openexchange.drive.lastCleanerRun";
    private static final List<File.Field> FILE_FIELDS = Arrays.asList(File.Field.LAST_MODIFIED, File.Field.CREATED, File.Field.ID, File.Field.FOLDER_ID, File.Field.SEQUENCE_NUMBER, File.Field.FILENAME);
    private final ServerSession session;
    private final ChecksumStore checksumStore;
    private final long minimumTimestamp;
    private final FileStorageFolder tempFolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpIfNeeded(SyncSession session) {
        block18: {
            Object parameter = session.getServerSession().getParameter(PARAM_LAST_CLEANER_RUN);
            if (null != parameter && Long.class.isInstance(parameter)) {
                long lastCleanerRun = (Long)parameter;
                LOG.debug("Last cleaner run for session {} at: {}", (Object)session, (Object)DriveConstants.LOG_DATE_FORMAT.get().format(new Date(lastCleanerRun)));
                long interval = DriveConfig.getInstance().getCleanerInterval();
                if (3600000L > interval) {
                    LOG.warn("The configured interval of '{}' is smaller than the allowed minimum of one hour. Falling back to '1h' instead.", (Object)interval);
                    interval = 3600000L;
                }
                if (System.currentTimeMillis() - lastCleanerRun < interval) {
                    LOG.debug("Cleaner interval time of '{}' not yet exceeded, not starting new run for session {}", (Object)interval, (Object)session);
                    return;
                }
            } else {
                LOG.debug("No previous cleaner run detected for session {}{}", (Object)session, (Object)Character.valueOf('.'));
            }
            try {
                FileStorageFolder tempFolder = session.getStorage().optFolder("/.drive", false);
                if (null == tempFolder) {
                    LOG.debug("No '.drive' folder found, nothing to do.");
                    return;
                }
                long maxAge = DriveConfig.getInstance().getCleanerMaxAge();
                if (3600000L > maxAge) {
                    LOG.warn("The configured maximum age of '{}' is smaller than the allowed minimum of one hour. Falling back to '1h' instead.", (Object)maxAge);
                    maxAge = 3600000L;
                }
                long minimumTimestamp = System.currentTimeMillis() - maxAge;
                if (null != tempFolder.getCreationDate() && minimumTimestamp <= tempFolder.getCreationDate().getTime()) {
                    LOG.debug("'.drive' was created within 'max age' interval, nothing to do.");
                    return;
                }
                LOG.info("Starting cleaner run for session {}{}", (Object)session, (Object)Character.valueOf('.'));
                TempCleaner tempCleaner = new TempCleaner(session.getServerSession(), session.getChecksumStore(), tempFolder, minimumTimestamp);
                ThreadPoolService threadPoolService = DriveServiceLookup.getService(ThreadPoolService.class);
                if (null != threadPoolService) {
                    try {
                        threadPoolService.getExecutor().submit(tempCleaner);
                        break block18;
                    }
                    catch (RejectedExecutionException e) {
                        LOG.error("Unable to execute temp cleaner", (Throwable)e);
                        session.getServerSession().setParameter(PARAM_LAST_CLEANER_RUN, (Object)System.currentTimeMillis());
                        return;
                    }
                }
                new Thread(tempCleaner).run();
            }
            catch (OXException e) {
                LOG.error("Error starting temp cleaner", (Throwable)e);
            }
            finally {
                session.getServerSession().setParameter(PARAM_LAST_CLEANER_RUN, (Object)System.currentTimeMillis());
            }
        }
    }

    public TempCleaner(ServerSession session, ChecksumStore checksumStore, FileStorageFolder tempFolder, long minimumTimestamp) {
        this.session = session;
        this.checksumStore = checksumStore;
        this.minimumTimestamp = minimumTimestamp;
        this.tempFolder = tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (null == this.tempFolder) {
                return;
            }
            boolean deleteAll = true;
            IDBasedFileAccessFactory fileAccessFactory = DriveServiceLookup.getService(IDBasedFileAccessFactory.class, true);
            IDBasedFileAccess fileAccess = fileAccessFactory.createAccess((Session)this.session);
            ArrayList<File> filesToDelete = new ArrayList<File>();
            TimedResult documents = fileAccess.getDocuments(this.tempFolder.getId(), FILE_FIELDS, null, FileStorageFileAccess.SortDirection.DEFAULT);
            if (null == documents) {
                return;
            }
            SearchIterator searchIterator = null;
            try {
                searchIterator = documents.results();
                while (searchIterator.hasNext()) {
                    File file = (File)searchIterator.next();
                    if (!(null != file.getLastModified() && this.minimumTimestamp <= file.getLastModified().getTime() || null != file.getCreated() && this.minimumTimestamp <= file.getCreated().getTime())) {
                        filesToDelete.add(file);
                        continue;
                    }
                    deleteAll = false;
                }
            }
            finally {
                if (null != searchIterator) {
                    searchIterator.close();
                }
            }
            IDBasedFolderAccessFactory folderAccessFactory = DriveServiceLookup.getService(IDBasedFolderAccessFactory.class, true);
            IDBasedFolderAccess folderAccess = folderAccessFactory.createAccess((Session)this.session);
            ArrayList<FileStorageFolder> foldersToDelete = new ArrayList<FileStorageFolder>();
            FileStorageFolder[] subfolders = folderAccess.getSubfolders(this.tempFolder.getId(), true);
            if (null != subfolders && 0 < subfolders.length) {
                for (FileStorageFolder subfolder : subfolders) {
                    if (!(null != subfolder.getLastModifiedDate() && this.minimumTimestamp <= subfolder.getLastModifiedDate().getTime() || null != subfolder.getCreationDate() && this.minimumTimestamp <= subfolder.getCreationDate().getTime())) {
                        foldersToDelete.add(subfolder);
                        continue;
                    }
                    deleteAll = false;
                }
            }
            if (deleteAll) {
                LOG.debug("Detected all folders ({}) and files ({}) in temp folder being outdated, removing '.drive' folder completely.", (Object)foldersToDelete.size(), (Object)filesToDelete.size());
                ArrayList<FolderID> folderIDs = new ArrayList<FolderID>(1 + foldersToDelete.size());
                folderIDs.add(new FolderID(this.tempFolder.getId()));
                for (FileStorageFolder folder : foldersToDelete) {
                    folderIDs.add(new FolderID(folder.getId()));
                }
                folderAccess.deleteFolder(this.tempFolder.getId(), true);
                this.checksumStore.removeFileChecksumsInFolders(folderIDs);
                this.checksumStore.removeDirectoryChecksums(folderIDs);
            } else if (0 < foldersToDelete.size() || 0 < filesToDelete.size()) {
                LOG.debug("Detected {} folder(s) and {} file(s) in temp folder being outdated, cleaning up.", (Object)foldersToDelete.size(), (Object)filesToDelete.size());
                for (FileStorageFolder folder : foldersToDelete) {
                    FolderID id = new FolderID(folder.getId());
                    folderAccess.deleteFolder(folder.getId(), true);
                    this.checksumStore.removeFileChecksumsInFolder(id);
                    this.checksumStore.removeDirectoryChecksum(id);
                }
                if (0 < filesToDelete.size()) {
                    ArrayList<String> ids = new ArrayList<String>(filesToDelete.size());
                    long sequenceNumber = 0L;
                    for (File file : filesToDelete) {
                        ids.add(file.getId());
                        sequenceNumber = Math.max(sequenceNumber, file.getSequenceNumber());
                    }
                    List notDeleted = fileAccess.removeDocument(ids, sequenceNumber, true);
                    for (File file : filesToDelete) {
                        if (null != notDeleted && notDeleted.contains(file.getId())) continue;
                        this.checksumStore.removeFileChecksums(DriveUtils.getFileID(file));
                    }
                }
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            LOG.error("error during temp cleaner run", t);
        }
    }
}

