/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal;

import com.openexchange.drive.DirectoryPattern;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.DriveFileField;
import com.openexchange.drive.DriveSession;
import com.openexchange.drive.DriveUtils;
import com.openexchange.drive.FilePattern;
import com.openexchange.drive.checksum.ChecksumProvider;
import com.openexchange.drive.checksum.ChecksumStore;
import com.openexchange.drive.checksum.DirectoryChecksum;
import com.openexchange.drive.checksum.FileChecksum;
import com.openexchange.drive.checksum.rdb.RdbChecksumStore;
import com.openexchange.drive.comparison.ServerDirectoryVersion;
import com.openexchange.drive.comparison.ServerFileVersion;
import com.openexchange.drive.internal.DirectLinkGenerator;
import com.openexchange.drive.internal.Tracer;
import com.openexchange.drive.management.DriveConfig;
import com.openexchange.drive.storage.DriveStorage;
import com.openexchange.drive.storage.StorageOperation;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.groupware.notify.hostname.HostData;
import com.openexchange.tools.session.ServerSession;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jonelo.jacksum.algorithm.MD;

public class SyncSession {
    private final DriveSession session;
    private final Tracer tracer;
    private ChecksumStore checksumStore;
    private DriveStorage storage;
    private DirectLinkGenerator linkGenerator;
    private Boolean hasTempFolder;

    public SyncSession(DriveSession session) {
        this.session = session;
        this.tracer = new Tracer(session.isDiagnostics());
        if (this.isTraceEnabled()) {
            this.trace("Creating new sync session for user " + session.getServerSession().getLoginName() + " (" + session.getServerSession().getUserId() + ") in context " + session.getServerSession().getContextId() + ", root folder ID is " + session.getRootFolderID() + " via client " + (Object)((Object)session.getClientType()) + " v" + session.getClientVersion());
        }
    }

    public ServerSession getServerSession() {
        return this.session.getServerSession();
    }

    public List<DriveFileField> getFields() {
        return this.session.getFields();
    }

    public DriveStorage getStorage() {
        if (null == this.storage) {
            this.storage = new DriveStorage(this);
        }
        return this.storage;
    }

    public String getRootFolderID() {
        return this.session.getRootFolderID();
    }

    public ChecksumStore getChecksumStore() throws OXException {
        if (null == this.checksumStore) {
            this.checksumStore = new RdbChecksumStore(this.getServerSession().getContextId());
        }
        return this.checksumStore;
    }

    public MD newMD5() throws OXException {
        try {
            return new MD("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw DriveExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
    }

    public String getDeviceName() {
        return this.session.getDeviceName();
    }

    public DriveSession getDriveSession() {
        return this.session;
    }

    public HostData getHostData() {
        return this.session.getHostData();
    }

    public DirectLinkGenerator getLinkGenerator() {
        if (null == this.linkGenerator) {
            this.linkGenerator = new DirectLinkGenerator(this);
        }
        return this.linkGenerator;
    }

    public void trace(Object message) {
        this.tracer.trace(message);
    }

    public String getDiagnosticsLog() {
        return this.tracer.getTraceLog();
    }

    public boolean isTraceEnabled() {
        return this.tracer.isTraceEnabled();
    }

    public boolean hasTempFolder() throws OXException {
        if (null == this.hasTempFolder) {
            if (!DriveConfig.getInstance().isUseTempFolder()) {
                this.trace("Temporary folder for upload is disabled by configuration.");
                this.hasTempFolder = Boolean.FALSE;
            } else {
                FileStorageFolder rootFolder;
                FileStorageFolder tempFolder = this.getStorage().optFolder("/.drive", false);
                if (null == tempFolder && null != (rootFolder = this.getStorage().getFolder("/")).getOwnPermission() && 8 <= rootFolder.getOwnPermission().getDeletePermission() && 4 <= rootFolder.getOwnPermission().getFolderPermission() && 4 <= rootFolder.getOwnPermission().getFolderPermission() && 4 <= rootFolder.getOwnPermission().getDeletePermission()) {
                    try {
                        tempFolder = this.getStorage().optFolder("/.drive", true);
                    }
                    catch (OXException e) {
                        this.trace("Error creating temporary folder for uploads: " + e.getMessage());
                    }
                }
                if (null == tempFolder) {
                    this.trace("No temporary folder available for uploads.");
                    this.hasTempFolder = Boolean.FALSE;
                } else if (null != tempFolder.getOwnPermission() && 4 <= tempFolder.getOwnPermission().getFolderPermission() && 4 <= tempFolder.getOwnPermission().getFolderPermission() && 4 <= tempFolder.getOwnPermission().getDeletePermission()) {
                    this.trace("Using folder '" + tempFolder + "' for temporary uploads.");
                    this.hasTempFolder = Boolean.TRUE;
                } else {
                    this.trace("Temporary folder for uploads found, but not enough permissions for current user.");
                    this.hasTempFolder = Boolean.FALSE;
                }
            }
        }
        return this.hasTempFolder;
    }

    public List<ServerFileVersion> getServerFiles(String path) throws OXException {
        FileStorageFolder folder = this.getStorage().getFolder(path);
        if (null == folder || null == folder.getOwnPermission() || 2 > folder.getOwnPermission().getReadPermission()) {
            return Collections.emptyList();
        }
        List<File> files = this.getStorage().getFilesInFolder(folder.getId());
        List<FileChecksum> checksums = ChecksumProvider.getChecksums(this, folder.getId(), files);
        ArrayList<ServerFileVersion> serverFiles = new ArrayList<ServerFileVersion>(files.size());
        for (int i = 0; i < files.size(); ++i) {
            serverFiles.add(new ServerFileVersion(files.get(i), checksums.get(i)));
        }
        return serverFiles;
    }

    public List<ServerDirectoryVersion> getServerDirectories() throws OXException {
        return this.getStorage().wrapInTransaction(new StorageOperation<List<ServerDirectoryVersion>>(){

            @Override
            public List<ServerDirectoryVersion> call() throws OXException {
                return SyncSession.this.getServerDirectoryVersions();
            }
        });
    }

    private List<ServerDirectoryVersion> getServerDirectoryVersions() throws OXException {
        StringBuilder stringBuilder = this.isTraceEnabled() ? new StringBuilder("Server directories:\n") : null;
        Map<String, FileStorageFolder> folders = this.getStorage().getFolders();
        ArrayList<String> folderIDs = new ArrayList<String>(folders.size());
        for (Map.Entry<String, FileStorageFolder> entry : folders.entrySet()) {
            String path = entry.getKey();
            if (DriveUtils.isInvalidPath(path)) {
                this.trace("Skipping invalid server directory: " + entry.getKey());
                continue;
            }
            if (DriveUtils.isIgnoredPath(this, path)) {
                this.trace("Skipping ignored server directory: " + entry.getKey());
                continue;
            }
            folderIDs.add(entry.getValue().getId());
        }
        List<DirectoryChecksum> checksums = ChecksumProvider.getChecksums(this, folderIDs);
        ArrayList<ServerDirectoryVersion> serverDirectories = new ArrayList<ServerDirectoryVersion>(folderIDs.size());
        for (int i = 0; i < folderIDs.size(); ++i) {
            ServerDirectoryVersion directoryVersion = new ServerDirectoryVersion(this.getStorage().getPath((String)folderIDs.get(i)), checksums.get(i));
            serverDirectories.add(directoryVersion);
            if (!this.isTraceEnabled()) continue;
            stringBuilder.append(" [").append(directoryVersion.getDirectoryChecksum().getFolderID()).append("] ").append(directoryVersion.getPath()).append(" | ").append(directoryVersion.getChecksum()).append(" (").append(directoryVersion.getDirectoryChecksum().getSequenceNumber()).append(")\n");
        }
        if (this.isTraceEnabled()) {
            this.trace(stringBuilder);
        }
        return serverDirectories;
    }

    public int getExclusionFilterHash() {
        List<FilePattern> fileExclusions;
        int prime = 31;
        int result = 1;
        List<DirectoryPattern> directoryExclusions = this.session.getDirectoryExclusions();
        if (null != directoryExclusions && 0 < directoryExclusions.size()) {
            result = 31 * result + ((Object)directoryExclusions).hashCode();
        }
        if (null != (fileExclusions = this.session.getFileExclusions()) && 0 < fileExclusions.size()) {
            result = 31 * result + ((Object)fileExclusions).hashCode();
        }
        return 1 == result ? 0 : result;
    }

    public String toString() {
        return this.session.getServerSession().getLoginName() + " [" + this.session.getServerSession().getContextId() + ':' + this.session.getServerSession().getUserId() + "] # " + this.session.getRootFolderID();
    }
}

