/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal;

import com.openexchange.tools.io.IOTools;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PartialInputStream
extends FilterInputStream {
    private final long length;
    private long bytesRead;

    public PartialInputStream(InputStream in, long offset, long length) throws IOException {
        super(in);
        this.length = length;
        IOTools.reallyBloodySkip((InputStream)this, (long)offset);
        this.bytesRead = 0L;
    }

    public PartialInputStream(InputStream in, long offset) throws IOException {
        this(in, offset, -1L);
    }

    @Override
    public int read() throws IOException {
        if (-1L != this.length && this.bytesRead >= this.length) {
            return -1;
        }
        int read = super.read();
        if (-1 != read) {
            ++this.bytesRead;
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (-1L != this.length && this.bytesRead >= this.length) {
            return -1;
        }
        int toRead = -1L == this.length ? len : Math.min((int)(this.length - this.bytesRead), len);
        int read = super.read(b, off, toRead);
        if (-1 != read) {
            this.bytesRead += (long)read;
        }
        return read;
    }
}

