/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal;

import com.openexchange.drive.DirectoryVersion;
import com.openexchange.drive.DriveConstants;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.FileVersion;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import java.util.Collection;

public class DriveVersionValidator {
    public static void validateFileVersions(FileVersion ... fileVersions) throws OXException {
        if (null != fileVersions && 0 < fileVersions.length) {
            for (FileVersion fileVersion : fileVersions) {
                DriveVersionValidator.validateFileVersion(fileVersion);
            }
        }
    }

    public static void validateFileVersions(Collection<FileVersion> fileVersions) throws OXException {
        if (null != fileVersions && 0 < fileVersions.size()) {
            for (FileVersion fileVersion : fileVersions) {
                DriveVersionValidator.validateFileVersion(fileVersion);
            }
        }
    }

    public static void validateFileVersion(FileVersion fileVersion) throws OXException {
        if (null == fileVersion) {
            throw DriveExceptionCodes.INVALID_FILEVERSION.create("", "");
        }
        if (Strings.isEmpty((String)fileVersion.getChecksum()) || Strings.isEmpty((String)fileVersion.getName())) {
            throw DriveExceptionCodes.INVALID_FILEVERSION.create(fileVersion.getName(), fileVersion.getChecksum());
        }
        if (!DriveConstants.CHECKSUM_VALIDATION_PATTERN.matcher(fileVersion.getChecksum()).matches()) {
            throw DriveExceptionCodes.INVALID_FILEVERSION.create(fileVersion.getName(), fileVersion.getChecksum());
        }
    }

    public static void validateDirectoryVersions(DirectoryVersion ... directoryVersions) throws OXException {
        if (null != directoryVersions && 0 < directoryVersions.length) {
            for (DirectoryVersion directoryVersion : directoryVersions) {
                DriveVersionValidator.validateDirectoryVersion(directoryVersion);
            }
        }
    }

    public static void validateDirectoryVersions(Collection<DirectoryVersion> directoryVersions) throws OXException {
        if (null != directoryVersions && 0 < directoryVersions.size()) {
            for (DirectoryVersion directoryVersion : directoryVersions) {
                DriveVersionValidator.validateDirectoryVersion(directoryVersion);
            }
        }
    }

    public static void validateDirectoryVersion(DirectoryVersion directoryVersion) throws OXException {
        if (null == directoryVersion) {
            throw DriveExceptionCodes.INVALID_DIRECTORYVERSION.create("", "");
        }
        if (Strings.isEmpty((String)directoryVersion.getChecksum()) || Strings.isEmpty((String)directoryVersion.getPath())) {
            throw DriveExceptionCodes.INVALID_DIRECTORYVERSION.create(directoryVersion.getPath(), directoryVersion.getChecksum());
        }
        if (!DriveConstants.CHECKSUM_VALIDATION_PATTERN.matcher(directoryVersion.getChecksum()).matches()) {
            throw DriveExceptionCodes.INVALID_DIRECTORYVERSION.create(directoryVersion.getPath(), directoryVersion.getChecksum());
        }
    }

    private DriveVersionValidator() {
    }
}

