/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal;

import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.drive.Action;
import com.openexchange.drive.DirectoryMetadata;
import com.openexchange.drive.DirectoryPattern;
import com.openexchange.drive.DirectoryVersion;
import com.openexchange.drive.DriveClientVersion;
import com.openexchange.drive.DriveConstants;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.DriveFileField;
import com.openexchange.drive.DriveFileMetadata;
import com.openexchange.drive.DriveQuota;
import com.openexchange.drive.DriveService;
import com.openexchange.drive.DriveSession;
import com.openexchange.drive.DriveSettings;
import com.openexchange.drive.DriveUtils;
import com.openexchange.drive.FilePattern;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.SyncResult;
import com.openexchange.drive.actions.AbstractAction;
import com.openexchange.drive.actions.AbstractFileAction;
import com.openexchange.drive.actions.AcknowledgeFileAction;
import com.openexchange.drive.actions.EditFileAction;
import com.openexchange.drive.actions.ErrorDirectoryAction;
import com.openexchange.drive.actions.ErrorFileAction;
import com.openexchange.drive.checksum.ChecksumProvider;
import com.openexchange.drive.checksum.DirectoryChecksum;
import com.openexchange.drive.checksum.FileChecksum;
import com.openexchange.drive.comparison.Change;
import com.openexchange.drive.comparison.DirectoryVersionMapper;
import com.openexchange.drive.comparison.FileVersionMapper;
import com.openexchange.drive.comparison.FilteringDirectoryVersionMapper;
import com.openexchange.drive.comparison.FilteringFileVersionMapper;
import com.openexchange.drive.comparison.ServerDirectoryVersion;
import com.openexchange.drive.comparison.ServerFileVersion;
import com.openexchange.drive.internal.DefaultDirectoryMetadata;
import com.openexchange.drive.internal.DownloadHelper;
import com.openexchange.drive.internal.DriveMetadataFactory;
import com.openexchange.drive.internal.DriveQuotaImpl;
import com.openexchange.drive.internal.DriveVersionValidator;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.internal.TempCleaner;
import com.openexchange.drive.internal.UploadHelper;
import com.openexchange.drive.internal.tracking.SyncTracker;
import com.openexchange.drive.management.DriveConfig;
import com.openexchange.drive.storage.execute.DirectoryActionExecutor;
import com.openexchange.drive.storage.execute.FileActionExecutor;
import com.openexchange.drive.sync.DefaultSyncResult;
import com.openexchange.drive.sync.IntermediateSyncResult;
import com.openexchange.drive.sync.Synchronizer;
import com.openexchange.drive.sync.optimize.OptimizingDirectorySynchronizer;
import com.openexchange.drive.sync.optimize.OptimizingFileSynchronizer;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.Quota;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.version.Version;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriveServiceImpl
implements DriveService {
    private static final Logger LOG = LoggerFactory.getLogger(DriveServiceImpl.class);

    public DriveServiceImpl() {
        LOG.debug("initialized.");
    }

    @Override
    public SyncResult<DirectoryVersion> syncFolders(DriveSession session, List<DirectoryVersion> originalVersions, List<DirectoryVersion> clientVersions) throws OXException {
        List<AbstractAction<Object>> actionsForClient;
        DriveClientVersion softVersionLimit;
        List newActionsForClient;
        IntermediateSyncResult<DirectoryVersion> syncResult;
        SyncSession driveSession;
        DriveClientVersion hardVersionLimit;
        if (session.getApiVersion() < DriveConfig.getInstance().getMinApiVersion()) {
            OXException error = DriveExceptionCodes.CLIENT_OUTDATED.create();
            LOG.warn("Client synchronization aborted for {}", (Object)session, (Object)error);
            ArrayList actionsForClient2 = new ArrayList(1);
            actionsForClient2.add(new ErrorDirectoryAction(null, null, null, error, false, true));
            return new DefaultSyncResult<DirectoryVersion>(actionsForClient2, error.getLogMessage());
        }
        DriveClientVersion clientVersion = session.getClientVersion();
        if (null != clientVersion && 0 > clientVersion.compareTo(hardVersionLimit = DriveConfig.getInstance().getHardMinimumVersion(session.getClientType()))) {
            OXException error = DriveExceptionCodes.CLIENT_VERSION_OUTDATED.create(clientVersion, hardVersionLimit);
            LOG.warn("Client synchronization aborted for {}", (Object)session, (Object)error);
            ArrayList actionsForClient3 = new ArrayList(1);
            actionsForClient3.add(new ErrorDirectoryAction(null, null, null, error, false, true));
            return new DefaultSyncResult<DirectoryVersion>(actionsForClient3, error.getLogMessage());
        }
        long start = System.currentTimeMillis();
        DriveVersionValidator.validateDirectoryVersions(originalVersions);
        DriveVersionValidator.validateDirectoryVersions(clientVersions);
        int retryCount = 0;
        while (true) {
            driveSession = new SyncSession(session);
            syncResult = DriveServiceImpl.syncDirectories(driveSession, originalVersions, clientVersions, driveSession.getServerDirectories());
            if (0 == retryCount) {
                syncResult = new SyncTracker(driveSession).trackAndCheck(syncResult);
            }
            newActionsForClient = null;
            try {
                DirectoryActionExecutor executor = new DirectoryActionExecutor(driveSession, true, retryCount < 5);
                executor.execute(syncResult.getActionsForServer());
                newActionsForClient = executor.getNewActionsForClient();
            }
            catch (OXException e) {
                if (0 == retryCount || DriveServiceImpl.tryAgain(e) && retryCount < 5) {
                    int delay = 1000 * ++retryCount;
                    driveSession.trace("Got exception during execution of server actions (" + e.getMessage() + "), trying again in " + delay + "ms" + (1 == retryCount ? "..." : " (" + retryCount + '/' + 5 + ")..."));
                    DriveServiceImpl.delay(delay);
                    continue;
                }
                driveSession.trace("Got exception during execution of server actions (" + e.getMessage() + ")");
                LOG.warn("Got exception during execution of server actions\nPrevious sync result:\n{}", syncResult, (Object)e);
                throw e;
            }
            break;
        }
        if (syncResult.isEmpty()) {
            TempCleaner.cleanUpIfNeeded(driveSession);
        }
        if (null != clientVersion && 0 > clientVersion.compareTo(softVersionLimit = DriveConfig.getInstance().getSoftMinimumVersion(session.getClientType()))) {
            OXException error = DriveExceptionCodes.CLIENT_VERSION_UPDATE_AVAILABLE.create(clientVersion, softVersionLimit);
            LOG.trace("Client upgrade available for {}", (Object)session, (Object)error);
            syncResult.addActionForClient(new ErrorDirectoryAction(null, null, null, error, false, false));
        }
        if (null != newActionsForClient) {
            actionsForClient = newActionsForClient;
            if (driveSession.isTraceEnabled()) {
                driveSession.trace("Execution of server actions resulted in new actions for client. New actions for client:");
                driveSession.trace(new DefaultSyncResult(actionsForClient, ""));
            }
        } else {
            actionsForClient = syncResult.getActionsForClient();
        }
        if (driveSession.isTraceEnabled()) {
            driveSession.trace("syncFolders with " + syncResult.length() + " resulting action(s) completed after " + (System.currentTimeMillis() - start) + "ms.");
        }
        return new DefaultSyncResult<DirectoryVersion>(actionsForClient, driveSession.getDiagnosticsLog());
    }

    @Override
    public SyncResult<FileVersion> syncFiles(DriveSession session, String path, List<FileVersion> originalVersions, List<FileVersion> clientVersions) throws OXException {
        List<AbstractAction<Object>> actionsForClient;
        List newActionsForClient;
        IntermediateSyncResult<FileVersion> syncResult;
        SyncSession driveSession;
        long start = System.currentTimeMillis();
        DriveVersionValidator.validateFileVersions(originalVersions);
        DriveVersionValidator.validateFileVersions(clientVersions);
        int retryCount = 0;
        while (true) {
            driveSession = new SyncSession(session);
            driveSession.getStorage().createFolder(path);
            syncResult = DriveServiceImpl.syncFiles(driveSession, path, originalVersions, clientVersions, driveSession.getServerFiles(path));
            if (0 == retryCount) {
                syncResult = new SyncTracker(driveSession).track(syncResult, path);
            }
            newActionsForClient = null;
            try {
                FileActionExecutor executor = new FileActionExecutor(driveSession, true, retryCount < 5, path);
                executor.execute(syncResult.getActionsForServer());
                newActionsForClient = executor.getNewActionsForClient();
            }
            catch (OXException e) {
                if (0 == retryCount || DriveServiceImpl.tryAgain(e) && retryCount < 5) {
                    int delay = 1000 * ++retryCount;
                    driveSession.trace("Got exception during execution of server actions (" + e.getMessage() + "), trying again in " + delay + "ms" + (1 == retryCount ? "..." : " (" + retryCount + '/' + 5 + ")..."));
                    DriveServiceImpl.delay(delay);
                    continue;
                }
                throw e;
            }
            break;
        }
        if (null != newActionsForClient) {
            actionsForClient = newActionsForClient;
            if (driveSession.isTraceEnabled()) {
                driveSession.trace("Execution of server actions resulted in new actions for client. New actions for client:");
                driveSession.trace(new DefaultSyncResult(actionsForClient, ""));
            }
        } else {
            actionsForClient = syncResult.getActionsForClient();
        }
        if (driveSession.isTraceEnabled()) {
            driveSession.trace("syncFiles with " + syncResult.length() + " resulting action(s) completed after " + (System.currentTimeMillis() - start) + "ms.");
        }
        return new DefaultSyncResult<FileVersion>(actionsForClient, driveSession.getDiagnosticsLog());
    }

    @Override
    public IFileHolder download(DriveSession session, String path, FileVersion fileVersion, long offset, long length) throws OXException {
        DriveVersionValidator.validateFileVersion(fileVersion);
        SyncSession syncSession = new SyncSession(session);
        LOG.debug("Handling download: file version: {}, offset: {}, length: {}", new Object[]{fileVersion, offset, length});
        AbstractFileAction action = new AbstractFileAction(null, fileVersion, null){

            @Override
            public Action getAction() {
                return Action.DOWNLOAD;
            }
        };
        action.getParameters().put("offset", offset);
        action.getParameters().put("length", length);
        new SyncTracker(syncSession).track(new IntermediateSyncResult<FileVersion>(Collections.emptyList(), Collections.singletonList(action)), path);
        return new DownloadHelper(syncSession).perform(path, fileVersion, offset, length);
    }

    @Override
    public SyncResult<FileVersion> upload(DriveSession session, String path, InputStream uploadStream, FileVersion originalVersion, FileVersion newVersion, String contentType, long offset, long totalLength, Date created, Date modified) throws OXException {
        SyncSession syncSession;
        DriveVersionValidator.validateFileVersion(newVersion);
        if (null != originalVersion) {
            DriveVersionValidator.validateFileVersion(originalVersion);
        }
        if ((syncSession = new SyncSession(session)).isTraceEnabled()) {
            syncSession.trace("Handling upload: original version: " + originalVersion + ", new version: " + newVersion + ", offset: " + offset + ", total length: " + totalLength + ", created: " + (null != created ? DriveConstants.LOG_DATE_FORMAT.get().format(created) : "") + ", modified: " + (null != modified ? DriveConstants.LOG_DATE_FORMAT.get().format(modified) : ""));
        }
        IntermediateSyncResult<FileVersion> syncResult = new IntermediateSyncResult<FileVersion>();
        File createdFile = null;
        try {
            createdFile = new UploadHelper(syncSession).perform(path, originalVersion, newVersion, uploadStream, contentType, offset, totalLength, created, modified);
        }
        catch (OXException e) {
            LOG.warn("Got exception during upload ({})\nSession: {}, path: {}, original version: {}, new version: {}, offset: {}, total length: {}", new Object[]{e.getMessage(), syncSession, path, originalVersion, newVersion, offset, totalLength});
            if (DriveUtils.indicatesQuotaExceeded(e)) {
                syncResult.addActionsForClient(DriveUtils.handleQuotaExceeded(syncSession, e, path, originalVersion, newVersion));
            }
            if (DriveUtils.indicatesFailedSave(e)) {
                syncResult.addActionForClient(new ErrorFileAction(null, newVersion, null, path, e, true));
            }
            throw e;
        }
        if (null != createdFile) {
            FileChecksum fileChecksum = syncSession.getChecksumStore().insertFileChecksum(new FileChecksum(DriveUtils.getFileID(createdFile), createdFile.getVersion(), createdFile.getSequenceNumber(), newVersion.getChecksum()));
            syncSession.getChecksumStore().removeDirectoryChecksum(new FolderID(createdFile.getFolderId()));
            ServerFileVersion createdVersion = new ServerFileVersion(createdFile, fileChecksum);
            if (newVersion.getName().equals(createdFile.getFileName())) {
                syncResult.addActionForClient(new AcknowledgeFileAction(syncSession, originalVersion, createdVersion, null, path));
            } else {
                syncResult.addActionForClient(new EditFileAction(newVersion, createdVersion, null, path));
            }
        }
        if (syncSession.isTraceEnabled()) {
            syncSession.trace(syncResult);
        }
        syncResult = new SyncTracker(syncSession).track(syncResult, path);
        return new DefaultSyncResult<FileVersion>(syncResult.getActionsForClient(), syncSession.getDiagnosticsLog());
    }

    @Override
    public DriveQuota getQuota(DriveSession session) throws OXException {
        return this.getSettings(session).getQuota();
    }

    @Override
    public DriveSettings getSettings(DriveSession session) throws OXException {
        SyncSession syncSession = new SyncSession(session);
        LOG.debug("Handling get-settings for '{}'", (Object)session);
        DriveSettings settings = new DriveSettings();
        Quota[] quota = syncSession.getStorage().getQuota();
        LOG.debug("Got quota for root folder '{}': {}", (Object)session.getRootFolderID(), (Object)quota);
        settings.setQuota(new DriveQuotaImpl(quota, syncSession.getLinkGenerator().getQuotaLink()));
        settings.setHelpLink(syncSession.getLinkGenerator().getHelpLink());
        settings.setServerVersion(Version.getInstance().getVersionString());
        settings.setMinApiVersion(String.valueOf(DriveConfig.getInstance().getMinApiVersion()));
        settings.setSupportedApiVersion(String.valueOf(DriveConstants.SUPPORTED_API_VERSION));
        return settings;
    }

    @Override
    public List<DriveFileMetadata> getFileMetadata(DriveSession session, String path, List<FileVersion> fileVersions, List<DriveFileField> fields) throws OXException {
        SyncSession syncSession = new SyncSession(session);
        if (null == fileVersions) {
            return DriveMetadataFactory.getFileMetadata(syncSession, syncSession.getServerFiles(path), fields);
        }
        if (1 == fileVersions.size()) {
            ServerFileVersion serverFile = ServerFileVersion.valueOf(fileVersions.get(0), path, syncSession);
            return Collections.singletonList(DriveMetadataFactory.getFileMetadata(syncSession, serverFile, fields));
        }
        ArrayList<DriveFileMetadata> metadata = new ArrayList<DriveFileMetadata>(fileVersions.size());
        List<ServerFileVersion> serverFiles = syncSession.getServerFiles(path);
        for (FileVersion requestedVersion : fileVersions) {
            ServerFileVersion matchingVersion = null;
            for (ServerFileVersion serverFileVersion : serverFiles) {
                if (!Change.NONE.equals((Object)Change.get(serverFileVersion, requestedVersion))) continue;
                matchingVersion = serverFileVersion;
                break;
            }
            if (null == matchingVersion) {
                throw DriveExceptionCodes.FILEVERSION_NOT_FOUND.create(requestedVersion.getName(), requestedVersion.getChecksum(), path);
            }
            metadata.add(DriveMetadataFactory.getFileMetadata(syncSession, matchingVersion, fields));
        }
        return metadata;
    }

    @Override
    public DirectoryMetadata getDirectoryMetadata(DriveSession session, String path) throws OXException {
        SyncSession syncSession = new SyncSession(session);
        String folderID = syncSession.getStorage().getFolderID(path);
        List<DirectoryChecksum> checksums = ChecksumProvider.getChecksums(syncSession, Arrays.asList(folderID));
        if (null == checksums || 0 == checksums.size()) {
            throw DriveExceptionCodes.PATH_NOT_FOUND.create(path);
        }
        return new DefaultDirectoryMetadata(syncSession, new ServerDirectoryVersion(path, checksums.get(0)));
    }

    private static IntermediateSyncResult<DirectoryVersion> syncDirectories(SyncSession session, List<? extends DirectoryVersion> originalVersions, List<? extends DirectoryVersion> clientVersions, List<? extends DirectoryVersion> serverVersions) throws OXException {
        List<DirectoryPattern> directoryExclusions = session.getDriveSession().getDirectoryExclusions();
        DirectoryVersionMapper mapper = null == directoryExclusions || 0 == directoryExclusions.size() ? new DirectoryVersionMapper((Collection<? extends DirectoryVersion>)originalVersions, (Collection<? extends DirectoryVersion>)clientVersions, (Collection<? extends DirectoryVersion>)serverVersions) : new FilteringDirectoryVersionMapper(directoryExclusions, originalVersions, clientVersions, serverVersions);
        if (session.isTraceEnabled()) {
            StringBuilder allocator = new StringBuilder("Directory versions mapped to:\n");
            allocator.append(mapper).append('\n');
            session.trace(allocator);
        }
        OptimizingDirectorySynchronizer synchronizer = new OptimizingDirectorySynchronizer(session, mapper);
        IntermediateSyncResult<DirectoryVersion> syncResult = ((Synchronizer)synchronizer).sync();
        if (session.isTraceEnabled()) {
            session.trace(syncResult);
        }
        return syncResult;
    }

    private static IntermediateSyncResult<FileVersion> syncFiles(SyncSession session, String path, List<? extends FileVersion> originalVersions, List<? extends FileVersion> clientVersions, List<? extends FileVersion> serverVersions) throws OXException {
        List<FilePattern> fileExclusions = session.getDriveSession().getFileExclusions();
        FileVersionMapper mapper = null == fileExclusions || 0 == fileExclusions.size() ? new FileVersionMapper((Collection<? extends FileVersion>)originalVersions, (Collection<? extends FileVersion>)clientVersions, (Collection<? extends FileVersion>)serverVersions) : new FilteringFileVersionMapper(path, fileExclusions, originalVersions, clientVersions, serverVersions);
        if (session.isTraceEnabled()) {
            StringBuilder allocator = new StringBuilder("File versions in directory " + path + " mapped to:\n");
            allocator.append(mapper).append('\n');
            session.trace(allocator);
        }
        OptimizingFileSynchronizer synchronizer = new OptimizingFileSynchronizer(session, mapper, path);
        IntermediateSyncResult<FileVersion> syncResult = ((Synchronizer)synchronizer).sync();
        if (session.isTraceEnabled()) {
            session.trace(syncResult);
        }
        return syncResult;
    }

    private static boolean tryAgain(OXException e) {
        if (null == e) {
            return false;
        }
        return Category.CATEGORY_TRY_AGAIN.equals(e.getCategory()) || Category.CATEGORY_CONFLICT.equals(e.getCategory()) || "FLD-0008".equals(e.getErrorCode()) || "DRV-0007".equals(e.getErrorCode());
    }

    private static void delay(long millis) throws OXException {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OXException((Throwable)e);
        }
    }
}

