/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal;

import com.openexchange.drive.DriveFileField;
import com.openexchange.drive.DriveFileMetadata;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.comparison.ServerFileVersion;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import java.util.ArrayList;
import java.util.List;

public class DriveMetadataFactory {
    public static DriveFileMetadata getFileMetadata(SyncSession session, String path, FileVersion fileVersion, List<DriveFileField> fields) throws OXException {
        return DriveMetadataFactory.getFileMetadata(session, ServerFileVersion.valueOf(fileVersion, path, session), fields);
    }

    public static DriveFileMetadata getFileMetadata(SyncSession session, ServerFileVersion fileVersion, List<DriveFileField> fields) {
        DriveFileMetadata fileMetadata = new DriveFileMetadata();
        fileMetadata.setChecksum(fileVersion.getChecksum());
        fileMetadata.setFileName(fileVersion.getName());
        File file = fileVersion.getFile();
        if (null != file) {
            if (null == fields || fields.contains((Object)DriveFileField.CREATED)) {
                fileMetadata.setCreated(file.getCreated());
            }
            if (null == fields || fields.contains((Object)DriveFileField.MODIFIED)) {
                fileMetadata.setModified(file.getCreated());
            }
            if (null == fields || fields.contains((Object)DriveFileField.CONTENT_TYPE)) {
                fileMetadata.setMimeType(file.getFileMIMEType());
            }
            if (null == fields || fields.contains((Object)DriveFileField.DIRECT_LINK)) {
                fileMetadata.setDirectLink(session.getLinkGenerator().getFileLink(file));
            }
            if (null == fields || fields.contains((Object)DriveFileField.DIRECT_LINK_FRAGMENTS)) {
                fileMetadata.setDirectLinkFragments(session.getLinkGenerator().getFileLinkFragments(file));
            }
            if (null == fields || fields.contains((Object)DriveFileField.PREVIEW_LINK)) {
                fileMetadata.setPreviewLink(session.getLinkGenerator().getFilePreviewLink(file));
            }
        }
        return fileMetadata;
    }

    public static List<DriveFileMetadata> getFileMetadata(SyncSession session, List<ServerFileVersion> fileVersions, List<DriveFileField> fields) {
        ArrayList<DriveFileMetadata> metadata = new ArrayList<DriveFileMetadata>(fileVersions.size());
        for (ServerFileVersion fileVersion : fileVersions) {
            metadata.add(DriveMetadataFactory.getFileMetadata(session, fileVersion, fields));
        }
        return metadata;
    }
}

