/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.internal;

import com.openexchange.capabilities.CapabilityService;
import com.openexchange.capabilities.CapabilitySet;
import com.openexchange.drive.internal.DriveServiceLookup;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.drive.management.DriveConfig;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.java.Strings;
import com.openexchange.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectLinkGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DirectLinkGenerator.class);
    private final SyncSession session;
    private Boolean documentPreview;

    public DirectLinkGenerator(SyncSession session) {
        this.session = session;
    }

    public String getQuotaLink() {
        return DriveConfig.getInstance().getDirectLinkQuota().replaceAll("\\[protocol\\]", this.session.getHostData().isSecure() ? "https" : "http").replaceAll("\\[hostname\\]", this.session.getHostData().getHost()).replaceAll("\\[uiwebpath\\]", this.getWebpath()).replaceAll("\\[dispatcherPrefix\\]", this.getDispatcherPrefix()).replaceAll("\\[contextid\\]", String.valueOf(this.session.getServerSession().getContextId())).replaceAll("\\[userid\\]", String.valueOf(this.session.getServerSession().getUserId())).replaceAll("\\[login\\]", String.valueOf(this.session.getServerSession().getLogin()));
    }

    public String getHelpLink() {
        return DriveConfig.getInstance().getDirectLinkHelp().replaceAll("\\[protocol\\]", this.session.getHostData().isSecure() ? "https" : "http").replaceAll("\\[hostname\\]", this.session.getHostData().getHost()).replaceAll("\\[uiwebpath\\]", this.getWebpath()).replaceAll("\\[dispatcherPrefix\\]", this.getDispatcherPrefix()).replaceAll("\\[contextid\\]", String.valueOf(this.session.getServerSession().getContextId())).replaceAll("\\[userid\\]", String.valueOf(this.session.getServerSession().getUserId())).replaceAll("\\[login\\]", String.valueOf(this.session.getServerSession().getLogin())).replaceAll("\\[locale\\]", String.valueOf(this.session.getDriveSession().getLocale()));
    }

    public String getFileLinkFragments(File file) {
        return this.getFileLinkFragments(file.getFolderId(), file.getId());
    }

    public String getFileLinkFragments(String folderID, String objectID) {
        return DriveConfig.getInstance().getDirectLinkFragmentsFile().replaceAll("\\[folder\\]", folderID).replaceAll("\\[object\\]", objectID);
    }

    public String getFileLink(File file) {
        return this.getFileLink(file.getFolderId(), file.getId());
    }

    public String getFileLink(String folderID, String objectID) {
        return DriveConfig.getInstance().getDirectLinkFile().replaceAll("\\[protocol\\]", this.session.getHostData().isSecure() ? "https" : "http").replaceAll("\\[hostname\\]", this.session.getHostData().getHost()).replaceAll("\\[uiwebpath\\]", this.getWebpath()).replaceAll("\\[filefragments\\]", this.getFileLinkFragments(folderID, objectID));
    }

    public String getFilePreviewLink(File file) {
        int[] dimensions = DriveConfig.getInstance().getPreviewImageSize();
        return this.getFileImageLink(file, dimensions[0], dimensions[1]);
    }

    public String getFileThumbnailLink(File file) {
        int[] dimensions = DriveConfig.getInstance().getThumbnailImageSize();
        return this.getFileImageLink(file, dimensions[0], dimensions[1]);
    }

    private String getFileImageLink(File file, int width, int height) {
        String mimeType = file.getFileMIMEType();
        if (!Strings.isEmpty((String)mimeType)) {
            if (mimeType.matches("(?i)^(image\\/(gif|png|jpe?g|bmp|tiff))$")) {
                return DriveConfig.getInstance().getImageLinkImageFile().replaceAll("\\[protocol\\]", this.session.getHostData().isSecure() ? "https" : "http").replaceAll("\\[hostname\\]", this.session.getHostData().getHost()).replaceAll("\\[dispatcherPrefix\\]", this.getDispatcherPrefix()).replaceAll("\\[folder\\]", file.getFolderId()).replaceAll("\\[object\\]", file.getId()).replaceAll("\\[version\\]", null == file.getVersion() ? "0" : file.getVersion()).replaceAll("\\[width\\]", String.valueOf(width)).replaceAll("\\[height\\]", String.valueOf(height));
            }
            if (mimeType.matches("(?i)^audio\\/(mpeg|m4a|m4b|mp3|ogg|oga|opus|x-m4a)$")) {
                return DriveConfig.getInstance().getImageLinkAudioFile().replaceAll("\\[protocol\\]", this.session.getHostData().isSecure() ? "https" : "http").replaceAll("\\[hostname\\]", this.session.getHostData().getHost()).replaceAll("\\[dispatcherPrefix\\]", this.getDispatcherPrefix()).replaceAll("\\[folder\\]", file.getFolderId()).replaceAll("\\[object\\]", file.getId()).replaceAll("\\[version\\]", null == file.getVersion() ? "0" : file.getVersion()).replaceAll("\\[width\\]", String.valueOf(width)).replaceAll("\\[height\\]", String.valueOf(height));
            }
            if ((mimeType.matches("(?i)^application\\/.*(ms-word|ms-excel|ms-powerpoint|msword|msexcel|mspowerpoint|openxmlformats|opendocument|pdf|rtf).*$") || mimeType.matches("(?i)^text\\/.*(rtf|plain).*$")) && this.hasDocumentPreview()) {
                return DriveConfig.getInstance().getImageLinkDocumentFile().replaceAll("\\[protocol\\]", this.session.getHostData().isSecure() ? "https" : "http").replaceAll("\\[hostname\\]", this.session.getHostData().getHost()).replaceAll("\\[dispatcherPrefix\\]", this.getDispatcherPrefix()).replaceAll("\\[folder\\]", file.getFolderId()).replaceAll("\\[object\\]", file.getId()).replaceAll("\\[version\\]", null == file.getVersion() ? "0" : file.getVersion()).replaceAll("\\[width\\]", String.valueOf(width)).replaceAll("\\[height\\]", String.valueOf(height));
            }
        }
        return null;
    }

    public String getDirectoryLinkFragments(String folderID) {
        return DriveConfig.getInstance().getDirectLinkFragmentsDirectory().replaceAll("\\[folder\\]", folderID);
    }

    public String getDirectoryLink(String folderID) {
        return DriveConfig.getInstance().getDirectLinkDirectory().replaceAll("\\[protocol\\]", this.session.getHostData().isSecure() ? "https" : "http").replaceAll("\\[hostname\\]", this.session.getHostData().getHost()).replaceAll("\\[uiwebpath\\]", this.getWebpath()).replaceAll("\\[directoryfragments\\]", this.getDirectoryLinkFragments(folderID));
    }

    private boolean hasDocumentPreview() {
        if (null == this.documentPreview) {
            this.documentPreview = Boolean.FALSE;
            CapabilityService capabilityService = DriveServiceLookup.getService(CapabilityService.class);
            if (null != capabilityService) {
                try {
                    CapabilitySet capabilities = capabilityService.getCapabilities((Session)this.session.getServerSession());
                    if (null != capabilities && capabilities.contains("document_preview")) {
                        this.documentPreview = Boolean.TRUE;
                    }
                }
                catch (OXException e) {
                    LOG.warn("Error determining capabilities", (Throwable)e);
                }
            }
        }
        return this.documentPreview;
    }

    private String getWebpath() {
        return DirectLinkGenerator.trimSlashes(DriveConfig.getInstance().getUiWebPath());
    }

    private String getDispatcherPrefix() {
        return DirectLinkGenerator.trimSlashes(DriveConfig.getInstance().getDispatcherPrefix());
    }

    private static String trimSlashes(String path) {
        if (null != path && 0 < path.length()) {
            if ('/' == path.charAt(0)) {
                path = path.substring(1);
            }
            if (0 < path.length() && '/' == path.charAt(path.length() - 1)) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }
}

