/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.comparison;

import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.checksum.ChecksumProvider;
import com.openexchange.drive.checksum.FileChecksum;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;

public class ServerFileVersion
implements FileVersion {
    private final File file;
    private final FileChecksum checksum;

    public ServerFileVersion(File file, FileChecksum checksum) {
        this.checksum = checksum;
        this.file = file;
    }

    @Override
    public String getChecksum() {
        return this.checksum.getChecksum();
    }

    @Override
    public String getName() {
        return this.file.getFileName();
    }

    public File getFile() {
        return this.file;
    }

    public FileChecksum getFileChecksum() {
        return this.checksum;
    }

    public String toString() {
        return this.getName() + " | " + this.getChecksum() + " [" + this.file.getFolderId() + '/' + this.file.getId() + ']';
    }

    public static ServerFileVersion valueOf(FileVersion fileVersion, String path, SyncSession session) throws OXException {
        if (ServerFileVersion.class.isInstance(fileVersion)) {
            return (ServerFileVersion)fileVersion;
        }
        File file = session.getStorage().getFileByName(path, fileVersion.getName(), true);
        if (null != file) {
            FileChecksum fileChecksum = ChecksumProvider.getChecksum(session, file);
            if (fileVersion.getChecksum().equals(fileChecksum.getChecksum())) {
                return new ServerFileVersion(file, fileChecksum);
            }
        }
        throw DriveExceptionCodes.FILEVERSION_NOT_FOUND.create(fileVersion.getName(), fileVersion.getChecksum(), path);
    }
}

