/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.comparison;

import com.openexchange.drive.FilePattern;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.comparison.FileVersionMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilteringFileVersionMapper
extends FileVersionMapper {
    public FilteringFileVersionMapper(String path, List<FilePattern> fileExclusions, Collection<? extends FileVersion> originalVersions, Collection<? extends FileVersion> clientVersions, Collection<? extends FileVersion> serverVersions) {
        super(FilteringFileVersionMapper.filterExclusions(path, originalVersions, fileExclusions), clientVersions, FilteringFileVersionMapper.filterExclusions(path, serverVersions, fileExclusions));
    }

    @Override
    protected String getKey(FileVersion version) {
        return version.getName();
    }

    private static Collection<? extends FileVersion> filterExclusions(String path, Collection<? extends FileVersion> fileVersions, List<FilePattern> fileExclusions) {
        if (null == fileExclusions || 0 == fileExclusions.size()) {
            return fileVersions;
        }
        ArrayList<FileVersion> filteredVersions = new ArrayList<FileVersion>(fileVersions.size());
        for (FileVersion fileVersion : fileVersions) {
            if (FilteringFileVersionMapper.matchesAny(path, fileVersion, fileExclusions)) continue;
            filteredVersions.add(fileVersion);
        }
        return filteredVersions;
    }

    private static boolean matchesAny(String path, FileVersion fileVersion, List<FilePattern> patterns) {
        String name = fileVersion.getName();
        for (FilePattern fileExclusion : patterns) {
            if (!fileExclusion.matches(path, name)) continue;
            return true;
        }
        return false;
    }
}

