/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.comparison;

import com.openexchange.drive.DirectoryVersion;
import com.openexchange.drive.DriveVersion;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.internal.PathNormalizer;

public enum Change {
    NONE,
    NEW,
    DELETED,
    MODIFIED;


    public static Change get(DriveVersion originalVersion, DriveVersion currentVersion) {
        if (null == currentVersion && null == originalVersion) {
            return NONE;
        }
        if (null == currentVersion) {
            return DELETED;
        }
        if (null == originalVersion) {
            return NEW;
        }
        if (!Change.equalsByChecksum(originalVersion, currentVersion) || !Change.equalsByName(originalVersion, currentVersion)) {
            return MODIFIED;
        }
        return NONE;
    }

    private static boolean equalsByName(DriveVersion v1, DriveVersion v2) {
        String name2;
        String name1;
        if (FileVersion.class.isInstance(v1) && FileVersion.class.isInstance(v2)) {
            name1 = ((FileVersion)v1).getName();
            name2 = ((FileVersion)v2).getName();
        } else if (DirectoryVersion.class.isInstance(v1) && DirectoryVersion.class.isInstance(v2)) {
            name1 = ((DirectoryVersion)v1).getPath();
            name2 = ((DirectoryVersion)v2).getPath();
        } else {
            throw new UnsupportedOperationException("incompatible drive versions");
        }
        return PathNormalizer.equals(name1, name2);
    }

    private static boolean equalsByChecksum(DriveVersion v1, DriveVersion v2) {
        if (null == v1) {
            return null == v2;
        }
        if (null == v2) {
            return null == v1;
        }
        return null == v1.getChecksum() ? null == v2.getChecksum() : v1.getChecksum().equalsIgnoreCase(v2.getChecksum());
    }
}

