/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.checksum.rdb;

import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.checksum.rdb.DirectoryChecksumsAddUserAndETagColumnTask;
import com.openexchange.drive.checksum.rdb.DirectoryChecksumsAddViewColumnTask;
import com.openexchange.drive.checksum.rdb.DirectoryChecksumsReIndexTask;
import com.openexchange.drive.checksum.rdb.DriveCreateTableTask;
import com.openexchange.drive.checksum.rdb.FileChecksumsReIndexTask;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.groupware.update.UpdateTaskV2;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQL {
    public static final Logger LOG = LoggerFactory.getLogger(SQL.class);
    public static final String INSERT_FILE_CHECKSUM_STMT = "INSERT INTO fileChecksums (uuid,cid,folder,file,version,sequence,checksum) VALUES (UNHEX(?),?,REVERSE(?),REVERSE(?),?,?,UNHEX(?));";
    public static final String UPDATE_FILE_CHECKSUM_STMT = "UPDATE fileChecksums SET folder=REVERSE(?),file=REVERSE(?),version=?,sequence=?,checksum=UNHEX(?) WHERE uuid=UNHEX(?) AND cid=?;";
    public static final String UPDATE_FILE_CHECKSUM_FOLDERS_STMT = "UPDATE fileChecksums SET folder=REVERSE(?) WHERE cid=? AND folder=REVERSE(?);";
    public static final String DELETE_FILE_CHECKSUMS_IN_FOLDER_STMT = "DELETE FROM fileChecksums WHERE cid=? AND folder=REVERSE(?);";
    public static final String DELETE_FILE_CHECKSUM_STMT = "DELETE FROM fileChecksums WHERE cid=? AND folder=REVERSE(?) AND file=REVERSE(?) AND version=? AND sequence=?;";
    public static final String DELETE_FILE_CHECKSUMS_STMT = "DELETE FROM fileChecksums WHERE cid=? AND folder=REVERSE(?) AND file=REVERSE(?);";
    public static final String SELECT_FILE_CHECKSUM_STMT = "SELECT LOWER(HEX(uuid)),LOWER(HEX(checksum)) FROM fileChecksums WHERE cid=? AND folder=REVERSE(?) AND file=REVERSE(?) AND version=? AND sequence=?;";
    public static final String SELECT_FILE_CHECKSUMS_IN_FOLDER_STMT = "SELECT LOWER(HEX(uuid)),REVERSE(file),version,sequence,LOWER(HEX(checksum)) FROM fileChecksums WHERE cid=? AND folder=REVERSE(?);";
    public static final String SELECT_MATCHING_FILE_CHECKSUMS_STMT = "SELECT LOWER(HEX(uuid)),REVERSE(folder),REVERSE(file),version,sequence FROM fileChecksums WHERE cid=? AND checksum=UNHEX(?);";
    public static final String INSERT_DIRECTORY_CHECKSUM_STMT = "INSERT INTO directoryChecksums (uuid,cid,user,view,folder,sequence,etag,checksum) VALUES (UNHEX(?),?,?,?,REVERSE(?),?,?,UNHEX(?));";
    public static final String UPDATE_DIRECTORY_CHECKSUM_STMT = "UPDATE directoryChecksums SET folder=REVERSE(?),sequence=?,etag=?,checksum=UNHEX(?) WHERE cid=? AND uuid=UNHEX(?);";
    public static final String UPDATE_DIRECTORY_CHECKSUM_FOLDER_STMT = "UPDATE directoryChecksums SET folder=REVERSE(?) WHERE cid=? AND folder=REVERSE(?);";
    public static final String DELETE_DIRECTORY_CHECKSUM_STMT = "DELETE FROM directoryChecksums WHERE cid=? AND folder=REVERSE(?);";

    public static String getCreateFileChecksumsTableStmt() {
        return "CREATE TABLE fileChecksums (uuid BINARY(16) NOT NULL,cid INT4 UNSIGNED NOT NULL,folder VARCHAR(512) NOT NULL,file VARCHAR(255) NOT NULL,version VARCHAR(255),sequence BIGINT(20) NOT NULL,checksum BINARY(16) NOT NULL,PRIMARY KEY (cid, uuid),INDEX (cid, folder),INDEX (cid, checksum)) ENGINE=InnoDB DEFAULT CHARSET=ascii;";
    }

    public static String getCreateDirectoryChecksumsTableStmt() {
        return "CREATE TABLE directoryChecksums (uuid BINARY(16) NOT NULL,cid INT4 UNSIGNED NOT NULL,user INT4 UNSIGNED DEFAULT NULL,view INT NOT NULL DEFAULT 0,folder VARCHAR(512) NOT NULL,sequence BIGINT(20) DEFAULT NULL,etag VARCHAR(255) DEFAULT NULL,checksum BINARY(16) NOT NULL,PRIMARY KEY (cid, uuid),INDEX (cid, user, folder),INDEX (cid, checksum)) ENGINE=InnoDB DEFAULT CHARSET=ascii;";
    }

    public static UpdateTaskV2[] getUpdateTasks() {
        return new UpdateTaskV2[]{new DriveCreateTableTask(), new DirectoryChecksumsAddUserAndETagColumnTask(), new DirectoryChecksumsReIndexTask(), new FileChecksumsReIndexTask(), new DirectoryChecksumsAddViewColumnTask()};
    }

    public static final String DELETE_FILE_CHECKSUMS_STMT(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM fileChecksums WHERE cid=? AND uuid");
        return SQL.appendPlaceholders(stringBuilder, length).append(';').toString();
    }

    public static final String INSERT_FILE_CHECKSUMS_STMT(int count) {
        StringBuilder allocator = new StringBuilder();
        allocator.append("INSERT INTO fileChecksums (uuid,cid,folder,file,version,sequence,checksum) ");
        if (0 < count) {
            allocator.append("VALUES (UNHEX(?),?,REVERSE(?),REVERSE(?),?,?,UNHEX(?))");
        }
        for (int i = 1; i < count; ++i) {
            allocator.append(",(UNHEX(?),?,REVERSE(?),REVERSE(?),?,?,UNHEX(?))");
        }
        allocator.append(';');
        return allocator.toString();
    }

    public static final String DELETE_FILE_CHECKSUMS_IN_FOLDER_STMT(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM fileChecksums WHERE cid=? AND folder");
        return SQL.appendPlaceholders(stringBuilder, length).append(';').toString();
    }

    public static final String DELETE_DIRECTORY_CHECKSUMS_STMT(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM directoryChecksums WHERE cid=? AND folder");
        return SQL.appendPlaceholders(stringBuilder, length).append(';').toString();
    }

    public static final String SELECT_DIRECTORY_CHECKSUMS_STMT(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT LOWER(HEX(uuid)),REVERSE(folder),sequence,etag,LOWER(HEX(checksum)) FROM directoryChecksums ");
        stringBuilder.append("WHERE cid=? AND user=? AND folder");
        return SQL.appendPlaceholders(stringBuilder, length).append(" AND view=?;").toString();
    }

    public static final String SELECT_MATCHING_FILE_CHECKSUMS_STMT(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT LOWER(HEX(uuid)),REVERSE(folder),REVERSE(file),version,sequence,LOWER(HEX(checksum)) ");
        stringBuilder.append("FROM fileChecksums WHERE cid=? AND checksum");
        return SQL.appendPlaceholders(stringBuilder, length).append(';').toString();
    }

    public static ResultSet logExecuteQuery(PreparedStatement stmt) throws SQLException {
        if (!LOG.isDebugEnabled()) {
            return stmt.executeQuery();
        }
        long start = System.currentTimeMillis();
        ResultSet resultSet = stmt.executeQuery();
        LOG.debug("executeQuery: {} - {} ms elapsed.", (Object)stmt.toString(), (Object)(System.currentTimeMillis() - start));
        return resultSet;
    }

    public static int logExecuteUpdate(PreparedStatement stmt) throws SQLException {
        if (!LOG.isDebugEnabled()) {
            return stmt.executeUpdate();
        }
        long start = System.currentTimeMillis();
        int rowCount = stmt.executeUpdate();
        LOG.debug("executeUpdate: {} - {} rows affected, {} ms elapsed.", new Object[]{stmt.toString(), rowCount, System.currentTimeMillis() - start});
        return rowCount;
    }

    public static FolderID unescapeFolder(String escaped) throws OXException {
        return new FolderID(SQL.unescape(escaped));
    }

    public static FileID unescapeFile(FolderID folderID, String escaped) throws OXException {
        return new FileID(folderID.getService(), folderID.getAccountId(), folderID.getFolderId(), SQL.unescape(escaped));
    }

    public static String escapeFolder(FolderID folderID) throws OXException {
        return SQL.escape(folderID.toUniqueID());
    }

    public static String escapeFolder(FileID fileID) throws OXException {
        return SQL.escapeFolder(new FolderID(fileID.getService(), fileID.getAccountId(), fileID.getFolderId()));
    }

    public static String escapeFile(FileID fileID) throws OXException {
        return SQL.escape(fileID.getFileId());
    }

    public static String escape(String value) throws OXException {
        if (null == value) {
            return null;
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
    }

    public static String unescape(String value) throws OXException {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
    }

    public static byte[] getBytes(String checksum) {
        int length = checksum.length();
        byte[] bytes = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            bytes[i / 2] = (byte)((Character.digit(checksum.charAt(i), 16) << 4) + Character.digit(checksum.charAt(i + 1), 16));
        }
        return bytes;
    }

    private static StringBuilder appendPlaceholders(StringBuilder stringBuilder, int count) {
        if (0 >= count) {
            throw new IllegalArgumentException("count");
        }
        if (1 == count) {
            stringBuilder.append("=?");
        } else {
            stringBuilder.append(" IN (?");
            for (int i = 1; i < count; ++i) {
                stringBuilder.append(",?");
            }
            stringBuilder.append(')');
        }
        return stringBuilder;
    }

    private SQL() {
    }
}

