/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.checksum.rdb;

import com.openexchange.database.DatabaseService;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.checksum.ChecksumStore;
import com.openexchange.drive.checksum.DirectoryChecksum;
import com.openexchange.drive.checksum.FileChecksum;
import com.openexchange.drive.checksum.rdb.SQL;
import com.openexchange.drive.internal.DriveServiceLookup;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.java.Strings;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class RdbChecksumStore
implements ChecksumStore {
    private static final int DELETE_CHUNK_SIZE = 50;
    private static final int INSERT_CHUNK_SIZE = 50;
    private static final int SELECT_WHERE_IN_CHUNK_SIZE = 500;
    private final int contextID;
    private final DatabaseService databaseService;

    public RdbChecksumStore(int contextID) throws OXException {
        this.contextID = contextID;
        this.databaseService = DriveServiceLookup.getService(DatabaseService.class, true);
    }

    @Override
    public FileChecksum insertFileChecksum(FileChecksum fileChecksum) throws OXException {
        if (null != fileChecksum.getUuid()) {
            throw new IllegalArgumentException("New file checksums must not contain an UUID");
        }
        Connection connection = this.databaseService.getWritable(this.contextID);
        try {
            fileChecksum.setUuid(RdbChecksumStore.newUid());
            if (0 == RdbChecksumStore.insertFileChecksum(connection, this.contextID, fileChecksum)) {
                throw DriveExceptionCodes.DB_ERROR.create("File checksum not added: " + fileChecksum);
            }
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backWritable(this.contextID, connection);
        }
        return fileChecksum;
    }

    @Override
    public List<FileChecksum> insertFileChecksums(List<FileChecksum> fileChecksums) throws OXException {
        Connection connection = this.databaseService.getWritable(this.contextID);
        try {
            for (int i = 0; i < fileChecksums.size(); i += 50) {
                int length = Math.min(fileChecksums.size(), i + 50) - i;
                FileChecksum[] checksums = new FileChecksum[length];
                for (int j = 0; j < length; ++j) {
                    FileChecksum checksum = fileChecksums.get(i + j);
                    if (null != checksum.getUuid()) {
                        throw new IllegalArgumentException("New file checksums must not contain an UUID");
                    }
                    checksum.setUuid(RdbChecksumStore.newUid());
                    checksums[j] = checksum;
                }
                int inserted = RdbChecksumStore.insertFileChecksums(connection, this.contextID, checksums);
                if (checksums.length == inserted) continue;
                throw DriveExceptionCodes.DB_ERROR.create(String.valueOf(checksums.length - inserted) + " file checksums not inserted");
            }
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backWritable(this.contextID, connection);
        }
        return fileChecksums;
    }

    @Override
    public FileChecksum updateFileChecksum(FileChecksum fileChecksum) throws OXException {
        return this.updateFileChecksums(Collections.singletonList(fileChecksum)).get(0);
    }

    @Override
    public List<FileChecksum> updateFileChecksums(List<FileChecksum> fileChecksums) throws OXException {
        Connection connection = this.databaseService.getWritable(this.contextID);
        try {
            for (FileChecksum fileChecksum : fileChecksums) {
                if (null == fileChecksum.getUuid()) {
                    throw new IllegalArgumentException("Updating file checksums requires an existing UUID");
                }
                RdbChecksumStore.updateFileChecksum(connection, this.contextID, fileChecksum);
            }
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backWritable(this.contextID, connection);
        }
        return fileChecksums;
    }

    @Override
    public int updateFileChecksumFolders(FolderID folderID, FolderID newFolderID) throws OXException {
        Connection connection = this.databaseService.getWritable(this.contextID);
        try {
            int n = RdbChecksumStore.updateFileChecksumFolders(connection, this.contextID, folderID, newFolderID);
            return n;
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backWritable(this.contextID, connection);
        }
    }

    @Override
    public boolean removeFileChecksum(FileChecksum fileChecksum) throws OXException {
        return 0 < this.removeFileChecksums(Collections.singletonList(fileChecksum));
    }

    @Override
    public int removeFileChecksums(List<FileChecksum> fileChecksums) throws OXException {
        Connection connection = this.databaseService.getWritable(this.contextID);
        try {
            int deleted = 0;
            for (int i = 0; i < fileChecksums.size(); i += 50) {
                int length = Math.min(fileChecksums.size(), i + 50) - i;
                String[] uuids = new String[length];
                for (int j = 0; j < length; ++j) {
                    String uuid = fileChecksums.get(i + j).getUuid();
                    if (null == uuid) {
                        throw new IllegalArgumentException("Removing file checksums requires an existing UUID");
                    }
                    uuids[j] = uuid;
                }
                deleted += RdbChecksumStore.deleteFileChecksums(connection, this.contextID, uuids);
            }
            int n = deleted;
            return n;
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backWritable(this.contextID, connection);
        }
    }

    @Override
    public int removeFileChecksumsInFolder(FolderID folderID) throws OXException {
        return this.removeFileChecksumsInFolders(Collections.singletonList(folderID));
    }

    @Override
    public int removeFileChecksumsInFolders(List<FolderID> folderIDs) throws OXException {
        Connection connection = this.databaseService.getWritable(this.contextID);
        try {
            int n = RdbChecksumStore.deleteFileChecksumsInFolders(connection, this.contextID, folderIDs.toArray(new FolderID[folderIDs.size()]));
            return n;
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backWritable(this.contextID, connection);
        }
    }

    @Override
    public boolean removeFileChecksum(FileID fileID, String version, long sequenceNumber) throws OXException {
        Connection connection = this.databaseService.getWritable(this.contextID);
        try {
            boolean bl = 0 < RdbChecksumStore.deleteFileChecksum(connection, this.contextID, fileID, version, sequenceNumber);
            return bl;
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backWritable(this.contextID, connection);
        }
    }

    @Override
    public int removeFileChecksums(FileID fileID) throws OXException {
        Connection connection = this.databaseService.getWritable(this.contextID);
        try {
            int n = RdbChecksumStore.deleteFileChecksums(connection, this.contextID, fileID);
            return n;
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backWritable(this.contextID, connection);
        }
    }

    @Override
    public int removeFileChecksums(FileID ... fileIDs) throws OXException {
        int deleted = 0;
        Connection connection = this.databaseService.getWritable(this.contextID);
        try {
            for (FileID fileID : fileIDs) {
                deleted += RdbChecksumStore.deleteFileChecksums(connection, this.contextID, fileID);
            }
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backWritable(this.contextID, connection);
        }
        return deleted;
    }

    @Override
    public FileChecksum getFileChecksum(FileID fileID, String version, long sequenceNumber) throws OXException {
        Connection connection = this.databaseService.getReadOnly(this.contextID);
        try {
            FileChecksum fileChecksum = RdbChecksumStore.selectFileChecksum(connection, this.contextID, fileID, version, sequenceNumber);
            return fileChecksum;
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backReadOnly(this.contextID, connection);
        }
    }

    @Override
    public List<FileChecksum> getFileChecksums(FolderID folderID) throws OXException {
        Connection connection = this.databaseService.getReadOnly(this.contextID);
        try {
            List<FileChecksum> list = RdbChecksumStore.selectFileChecksumsInFolder(connection, this.contextID, folderID);
            return list;
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backReadOnly(this.contextID, connection);
        }
    }

    @Override
    public Map<String, List<FileChecksum>> getMatchingFileChecksums(List<String> checksums) throws OXException {
        if (null == checksums) {
            return Collections.emptyMap();
        }
        HashMap<String, List<FileChecksum>> matchingChecksums = new HashMap<String, List<FileChecksum>>();
        Connection connection = this.databaseService.getReadOnly(this.contextID);
        try {
            for (int i = 0; i < checksums.size(); i += 500) {
                int length = Math.min(checksums.size(), i + 500) - i;
                matchingChecksums.putAll(RdbChecksumStore.selectMatchingFileChecksums(connection, this.contextID, checksums.subList(i, i + length)));
            }
            HashMap<String, List<FileChecksum>> i = matchingChecksums;
            return i;
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backReadOnly(this.contextID, connection);
        }
    }

    @Override
    public DirectoryChecksum insertDirectoryChecksum(DirectoryChecksum directoryChecksum) throws OXException {
        return this.insertDirectoryChecksums(Collections.singletonList(directoryChecksum)).get(0);
    }

    @Override
    public List<DirectoryChecksum> insertDirectoryChecksums(List<DirectoryChecksum> directoryChecksums) throws OXException {
        Connection connection = this.databaseService.getWritable(this.contextID);
        try {
            for (DirectoryChecksum directoryChecksum : directoryChecksums) {
                if (null != directoryChecksum.getUuid()) {
                    throw new IllegalArgumentException("New directory checksums must not contain an UUID");
                }
                directoryChecksum.setUuid(RdbChecksumStore.newUid());
                if (0 != RdbChecksumStore.insertDirectoryChecksum(connection, this.contextID, directoryChecksum)) continue;
                throw DriveExceptionCodes.DB_ERROR.create("File checksum not added: " + directoryChecksum);
            }
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backWritable(this.contextID, connection);
        }
        return directoryChecksums;
    }

    @Override
    public List<DirectoryChecksum> updateDirectoryChecksums(List<DirectoryChecksum> directoryChecksums) throws OXException {
        Connection connection = this.databaseService.getWritable(this.contextID);
        try {
            for (DirectoryChecksum directoryChecksum : directoryChecksums) {
                if (null == directoryChecksum.getUuid()) {
                    throw new IllegalArgumentException("Updating directory checksums requires an existing UUID");
                }
                RdbChecksumStore.updateDirectoryChecksum(connection, this.contextID, directoryChecksum);
            }
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backWritable(this.contextID, connection);
        }
        return directoryChecksums;
    }

    @Override
    public DirectoryChecksum updateDirectoryChecksum(DirectoryChecksum directoryChecksum) throws OXException {
        return this.updateDirectoryChecksums(Collections.singletonList(directoryChecksum)).get(0);
    }

    @Override
    public boolean updateDirectoryChecksumFolder(FolderID folderID, FolderID newFolderID) throws OXException {
        Connection connection = this.databaseService.getWritable(this.contextID);
        try {
            boolean bl = 0 < RdbChecksumStore.updateDirectoryChecksumFolder(connection, this.contextID, folderID, newFolderID);
            return bl;
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backWritable(this.contextID, connection);
        }
    }

    @Override
    public boolean removeDirectoryChecksum(FolderID folderID) throws OXException {
        return 0 < this.removeDirectoryChecksums(Collections.singletonList(folderID));
    }

    @Override
    public int removeDirectoryChecksums(List<FolderID> folderIDs) throws OXException {
        Connection connection = this.databaseService.getWritable(this.contextID);
        try {
            int n = RdbChecksumStore.deleteDirectoryChecksums(connection, this.contextID, folderIDs.toArray(new FolderID[folderIDs.size()]));
            return n;
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backWritable(this.contextID, connection);
        }
    }

    @Override
    public DirectoryChecksum getDirectoryChecksum(int userID, FolderID folderID, int view) throws OXException {
        List<DirectoryChecksum> directoryChecksums = this.getDirectoryChecksums(userID, Collections.singletonList(folderID), view);
        return 1 == directoryChecksums.size() ? directoryChecksums.get(0) : null;
    }

    @Override
    public List<DirectoryChecksum> getDirectoryChecksums(int userID, List<FolderID> folderIDs, int view) throws OXException {
        Connection connection = this.databaseService.getReadOnly(this.contextID);
        try {
            List<DirectoryChecksum> list = RdbChecksumStore.selectDirectoryChecksums(connection, this.contextID, userID, folderIDs.toArray(new FolderID[folderIDs.size()]), view);
            return list;
        }
        catch (SQLException e) {
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            this.databaseService.backReadOnly(this.contextID, connection);
        }
    }

    private static String newUid() {
        return UUIDs.getUnformattedString((UUID)UUID.randomUUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int insertFileChecksum(Connection connection, int cid, FileChecksum fileChecksum) throws SQLException, OXException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("INSERT INTO fileChecksums (uuid,cid,folder,file,version,sequence,checksum) VALUES (UNHEX(?),?,REVERSE(?),REVERSE(?),?,?,UNHEX(?));");
            stmt.setString(1, fileChecksum.getUuid());
            stmt.setInt(2, cid);
            stmt.setString(3, SQL.escapeFolder(fileChecksum.getFileID()));
            stmt.setString(4, SQL.escapeFile(fileChecksum.getFileID()));
            stmt.setString(5, fileChecksum.getVersion());
            stmt.setLong(6, fileChecksum.getSequenceNumber());
            stmt.setString(7, fileChecksum.getChecksum());
            int n = SQL.logExecuteUpdate(stmt);
            return n;
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int insertFileChecksums(Connection connection, int cid, FileChecksum[] fileChecksums) throws SQLException, OXException {
        int n;
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(SQL.INSERT_FILE_CHECKSUMS_STMT(fileChecksums.length));
            int parameterIndex = 1;
            for (FileChecksum fileChecksum : fileChecksums) {
                stmt.setString(parameterIndex++, fileChecksum.getUuid());
                stmt.setInt(parameterIndex++, cid);
                stmt.setString(parameterIndex++, SQL.escapeFolder(fileChecksum.getFileID()));
                stmt.setString(parameterIndex++, SQL.escapeFile(fileChecksum.getFileID()));
                stmt.setString(parameterIndex++, fileChecksum.getVersion());
                stmt.setLong(parameterIndex++, fileChecksum.getSequenceNumber());
                stmt.setString(parameterIndex++, fileChecksum.getChecksum());
            }
            n = SQL.logExecuteUpdate(stmt);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff((Statement)stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateFileChecksum(Connection connection, int cid, FileChecksum fileChecksum) throws SQLException, OXException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("UPDATE fileChecksums SET folder=REVERSE(?),file=REVERSE(?),version=?,sequence=?,checksum=UNHEX(?) WHERE uuid=UNHEX(?) AND cid=?;");
            stmt.setString(1, SQL.escapeFolder(fileChecksum.getFileID()));
            stmt.setString(2, SQL.escapeFile(fileChecksum.getFileID()));
            stmt.setString(3, fileChecksum.getVersion());
            stmt.setLong(4, fileChecksum.getSequenceNumber());
            stmt.setString(5, fileChecksum.getChecksum());
            stmt.setString(6, fileChecksum.getUuid());
            stmt.setInt(7, cid);
            int n = SQL.logExecuteUpdate(stmt);
            return n;
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateFileChecksumFolders(Connection connection, int cid, FolderID folder, FolderID newFolder) throws SQLException, OXException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("UPDATE fileChecksums SET folder=REVERSE(?) WHERE cid=? AND folder=REVERSE(?);");
            stmt.setString(1, SQL.escapeFolder(newFolder));
            stmt.setInt(2, cid);
            stmt.setString(3, SQL.escapeFolder(folder));
            int n = SQL.logExecuteUpdate(stmt);
            return n;
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int deleteFileChecksums(Connection connection, int cid, String[] uuids) throws SQLException {
        int n;
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(SQL.DELETE_FILE_CHECKSUMS_STMT(uuids.length));
            stmt.setInt(1, cid);
            for (int i = 0; i < uuids.length; ++i) {
                stmt.setBytes(i + 2, SQL.getBytes(uuids[i]));
            }
            n = SQL.logExecuteUpdate(stmt);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff((Statement)stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int deleteFileChecksumsInFolders(Connection connection, int cid, FolderID[] folderIDs) throws SQLException, OXException {
        int n;
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(SQL.DELETE_FILE_CHECKSUMS_IN_FOLDER_STMT(folderIDs.length));
            stmt.setInt(1, cid);
            for (int i = 0; i < folderIDs.length; ++i) {
                stmt.setString(i + 2, Strings.reverse((String)SQL.escapeFolder(folderIDs[i])));
            }
            n = SQL.logExecuteUpdate(stmt);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff((Statement)stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int deleteFileChecksum(Connection connection, int cid, FileID file, String version, long sequence) throws SQLException, OXException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("DELETE FROM fileChecksums WHERE cid=? AND folder=REVERSE(?) AND file=REVERSE(?) AND version=? AND sequence=?;");
            stmt.setInt(1, cid);
            stmt.setString(2, SQL.escapeFolder(file));
            stmt.setString(3, SQL.escapeFile(file));
            stmt.setString(4, version);
            stmt.setLong(5, sequence);
            int n = SQL.logExecuteUpdate(stmt);
            return n;
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int deleteFileChecksums(Connection connection, int cid, FileID file) throws SQLException, OXException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("DELETE FROM fileChecksums WHERE cid=? AND folder=REVERSE(?) AND file=REVERSE(?);");
            stmt.setInt(1, cid);
            stmt.setString(2, SQL.escapeFolder(file));
            stmt.setString(3, SQL.escapeFile(file));
            int n = SQL.logExecuteUpdate(stmt);
            return n;
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileChecksum selectFileChecksum(Connection connection, int cid, FileID file, String version, long sequence) throws SQLException, OXException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("SELECT LOWER(HEX(uuid)),LOWER(HEX(checksum)) FROM fileChecksums WHERE cid=? AND folder=REVERSE(?) AND file=REVERSE(?) AND version=? AND sequence=?;");
            stmt.setInt(1, cid);
            stmt.setString(2, SQL.escapeFolder(file));
            stmt.setString(3, SQL.escapeFile(file));
            stmt.setString(4, version);
            stmt.setLong(5, sequence);
            ResultSet resultSet = SQL.logExecuteQuery(stmt);
            if (resultSet.next()) {
                FileChecksum fileChecksum = new FileChecksum();
                fileChecksum.setFileID(file);
                fileChecksum.setVersion(version);
                fileChecksum.setSequenceNumber(sequence);
                fileChecksum.setUuid(resultSet.getString(1));
                fileChecksum.setChecksum(resultSet.getString(2));
                FileChecksum fileChecksum2 = fileChecksum;
                return fileChecksum2;
            }
            FileChecksum fileChecksum = null;
            return fileChecksum;
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileChecksum> selectFileChecksumsInFolder(Connection connection, int cid, FolderID folder) throws SQLException, OXException {
        ArrayList<FileChecksum> fileChecksums = new ArrayList<FileChecksum>();
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("SELECT LOWER(HEX(uuid)),REVERSE(file),version,sequence,LOWER(HEX(checksum)) FROM fileChecksums WHERE cid=? AND folder=REVERSE(?);");
            stmt.setInt(1, cid);
            stmt.setString(2, SQL.escapeFolder(folder));
            ResultSet resultSet = SQL.logExecuteQuery(stmt);
            while (resultSet.next()) {
                FileChecksum fileChecksum = new FileChecksum();
                fileChecksum.setUuid(resultSet.getString(1));
                fileChecksum.setFileID(SQL.unescapeFile(folder, resultSet.getString(2)));
                fileChecksum.setVersion(resultSet.getString(3));
                fileChecksum.setSequenceNumber(resultSet.getLong(4));
                fileChecksum.setChecksum(resultSet.getString(5));
                fileChecksums.add(fileChecksum);
            }
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
        }
        return fileChecksums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, List<FileChecksum>> selectMatchingFileChecksums(Connection connection, int cid, List<String> checksums) throws SQLException, OXException {
        HashMap<String, List<FileChecksum>> fileChecksums = new HashMap<String, List<FileChecksum>>();
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(SQL.SELECT_MATCHING_FILE_CHECKSUMS_STMT(checksums.size()));
            stmt.setInt(1, cid);
            for (int i = 0; i < checksums.size(); ++i) {
                stmt.setBytes(i + 2, SQL.getBytes(checksums.get(i)));
            }
            ResultSet resultSet = SQL.logExecuteQuery(stmt);
            while (resultSet.next()) {
                FileChecksum fileChecksum = new FileChecksum();
                fileChecksum.setUuid(resultSet.getString(1));
                FolderID folderID = SQL.unescapeFolder(resultSet.getString(2));
                fileChecksum.setFileID(SQL.unescapeFile(folderID, resultSet.getString(3)));
                fileChecksum.setVersion(resultSet.getString(4));
                fileChecksum.setSequenceNumber(resultSet.getLong(5));
                String checksum = resultSet.getString(6);
                fileChecksum.setChecksum(checksum);
                ArrayList<FileChecksum> matchingChecksums = (ArrayList<FileChecksum>)fileChecksums.get(checksum);
                if (null == matchingChecksums) {
                    matchingChecksums = new ArrayList<FileChecksum>();
                    fileChecksums.put(checksum, matchingChecksums);
                }
                matchingChecksums.add(fileChecksum);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff((Statement)stmt);
        return fileChecksums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int insertDirectoryChecksum(Connection connection, int cid, DirectoryChecksum directoryChecksum) throws SQLException, OXException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("INSERT INTO directoryChecksums (uuid,cid,user,view,folder,sequence,etag,checksum) VALUES (UNHEX(?),?,?,?,REVERSE(?),?,?,UNHEX(?));");
            stmt.setString(1, directoryChecksum.getUuid());
            stmt.setInt(2, cid);
            stmt.setInt(3, directoryChecksum.getUserID());
            stmt.setInt(4, directoryChecksum.getView());
            stmt.setString(5, SQL.escapeFolder(directoryChecksum.getFolderID()));
            stmt.setLong(6, directoryChecksum.getSequenceNumber());
            stmt.setString(7, directoryChecksum.getETag());
            stmt.setString(8, directoryChecksum.getChecksum());
            int n = SQL.logExecuteUpdate(stmt);
            return n;
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateDirectoryChecksum(Connection connection, int cid, DirectoryChecksum directoryChecksum) throws SQLException, OXException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("UPDATE directoryChecksums SET folder=REVERSE(?),sequence=?,etag=?,checksum=UNHEX(?) WHERE cid=? AND uuid=UNHEX(?);");
            stmt.setString(1, SQL.escapeFolder(directoryChecksum.getFolderID()));
            stmt.setLong(2, directoryChecksum.getSequenceNumber());
            stmt.setString(3, directoryChecksum.getETag());
            stmt.setString(4, directoryChecksum.getChecksum());
            stmt.setInt(5, cid);
            stmt.setString(6, directoryChecksum.getUuid());
            int n = SQL.logExecuteUpdate(stmt);
            return n;
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateDirectoryChecksumFolder(Connection connection, int cid, FolderID folder, FolderID newFolder) throws SQLException, OXException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("UPDATE directoryChecksums SET folder=REVERSE(?) WHERE cid=? AND folder=REVERSE(?);");
            stmt.setString(1, SQL.escapeFolder(newFolder));
            stmt.setInt(2, cid);
            stmt.setString(3, SQL.escapeFolder(folder));
            int n = SQL.logExecuteUpdate(stmt);
            return n;
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int deleteDirectoryChecksums(Connection connection, int cid, FolderID[] folderIDs) throws SQLException, OXException {
        int n;
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(SQL.DELETE_DIRECTORY_CHECKSUMS_STMT(folderIDs.length));
            stmt.setInt(1, cid);
            for (int i = 0; i < folderIDs.length; ++i) {
                stmt.setString(i + 2, Strings.reverse((String)SQL.escapeFolder(folderIDs[i])));
            }
            n = SQL.logExecuteUpdate(stmt);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff((Statement)stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DirectoryChecksum> selectDirectoryChecksums(Connection connection, int cid, int user, FolderID[] folderIDs, int view) throws SQLException, OXException {
        ArrayList<DirectoryChecksum> directoryChecksums = new ArrayList<DirectoryChecksum>();
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(SQL.SELECT_DIRECTORY_CHECKSUMS_STMT(folderIDs.length));
            int parameterIndex = 1;
            stmt.setInt(parameterIndex++, cid);
            stmt.setInt(parameterIndex++, user);
            for (int i = 0; i < folderIDs.length; ++i) {
                stmt.setString(parameterIndex++, Strings.reverse((String)SQL.escapeFolder(folderIDs[i])));
            }
            stmt.setInt(parameterIndex++, view);
            ResultSet resultSet = SQL.logExecuteQuery(stmt);
            while (resultSet.next()) {
                DirectoryChecksum directoryChecksum = new DirectoryChecksum();
                directoryChecksum.setUserID(user);
                directoryChecksum.setView(view);
                directoryChecksum.setUuid(resultSet.getString(1));
                directoryChecksum.setFolderID(SQL.unescapeFolder(resultSet.getString(2)));
                directoryChecksum.setSequenceNumber(resultSet.getLong(3));
                directoryChecksum.setETag(resultSet.getString(4));
                directoryChecksum.setChecksum(resultSet.getString(5));
                directoryChecksums.add(directoryChecksum);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff((Statement)stmt);
        return directoryChecksums;
    }
}

