/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.checksum.rdb;

import com.openexchange.database.DatabaseService;
import com.openexchange.drive.DriveExceptionCodes;
import com.openexchange.drive.checksum.rdb.DriveCreateTableService;
import com.openexchange.drive.internal.DriveServiceLookup;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class DriveCreateTableTask
extends UpdateTaskAdapter {
    public void perform(PerformParameters params) throws OXException {
        DatabaseService dbService = DriveServiceLookup.getService(DatabaseService.class);
        if (dbService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        int contextId = params.getContextId();
        Connection writeCon = dbService.getForUpdateTask(contextId);
        PreparedStatement stmt = null;
        boolean transactional = false;
        try {
            writeCon.setAutoCommit(false);
            transactional = true;
            String[] tableNames = DriveCreateTableService.getTablesToCreate();
            String[] createStmts = DriveCreateTableService.getCreateStmts();
            for (int i = 0; i < tableNames.length; ++i) {
                try {
                    if (DBUtils.tableExists((Connection)writeCon, (String)tableNames[i])) continue;
                    stmt = writeCon.prepareStatement(createStmts[i]);
                    stmt.executeUpdate();
                    continue;
                }
                catch (SQLException e) {
                    throw UpdateExceptionCodes.SQL_PROBLEM.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
            writeCon.commit();
        }
        catch (OXException e) {
            if (transactional) {
                DBUtils.rollback((Connection)writeCon);
            }
            throw e;
        }
        catch (Exception e) {
            if (transactional) {
                DBUtils.rollback((Connection)writeCon);
            }
            throw DriveExceptionCodes.DB_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            if (transactional) {
                DBUtils.autocommit((Connection)writeCon);
            }
            dbService.backForUpdateTask(contextId, writeCon);
        }
    }

    public String[] getDependencies() {
        return new String[0];
    }
}

