/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.checksum.rdb;

import com.openexchange.database.DatabaseService;
import com.openexchange.drive.checksum.rdb.DirectoryChecksumsAddUserAndETagColumnTask;
import com.openexchange.drive.internal.DriveServiceLookup;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class DirectoryChecksumsReIndexTask
extends UpdateTaskAdapter {
    public String[] getDependencies() {
        return new String[]{DirectoryChecksumsAddUserAndETagColumnTask.class.getName()};
    }

    public void perform(PerformParameters params) throws OXException {
        int contextID = params.getContextId();
        DatabaseService dbService = DriveServiceLookup.getService(DatabaseService.class);
        Connection connection = dbService.getForUpdateTask(contextID);
        boolean committed = false;
        try {
            connection.setAutoCommit(false);
            String oldIndexName = Tools.existsIndex((Connection)connection, (String)"directoryChecksums", (String[])new String[]{"checksum", "cid"});
            if (null != oldIndexName) {
                Tools.dropIndex((Connection)connection, (String)"directoryChecksums", (String)oldIndexName);
            }
            if (null != (oldIndexName = Tools.existsIndex((Connection)connection, (String)"directoryChecksums", (String[])new String[]{"folder", "cid"}))) {
                Tools.dropIndex((Connection)connection, (String)"directoryChecksums", (String)oldIndexName);
            }
            Tools.createIndex((Connection)connection, (String)"directoryChecksums", (String[])new String[]{"cid", "checksum"});
            Tools.createIndex((Connection)connection, (String)"directoryChecksums", (String[])new String[]{"cid", "user", "folder"});
            connection.commit();
            committed = true;
        }
        catch (SQLException e) {
            DBUtils.rollback((Connection)connection);
            throw UpdateExceptionCodes.SQL_PROBLEM.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (RuntimeException e) {
            DBUtils.rollback((Connection)connection);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            DBUtils.autocommit((Connection)connection);
            if (committed) {
                dbService.backForUpdateTask(contextID, connection);
            } else {
                dbService.backForUpdateTaskAfterReading(contextID, connection);
            }
        }
    }
}

