/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.checksum.events;

import com.openexchange.drive.checksum.events.DelayedChecksumInvalidation;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class DelayedChecksumInvalidationQueue
extends AbstractQueue<DelayedChecksumInvalidation>
implements BlockingQueue<DelayedChecksumInvalidation> {
    final transient ReentrantLock lock = new ReentrantLock();
    private final transient Condition available = this.lock.newCondition();
    final PriorityQueue<DelayedChecksumInvalidation> q = new PriorityQueue();
    final Set<DelayedChecksumInvalidation> contained = new HashSet<DelayedChecksumInvalidation>(64);

    public DelayedChecksumInvalidationQueue() {
    }

    public DelayedChecksumInvalidationQueue(Collection<? extends DelayedChecksumInvalidation> c) {
        this.addAll(c);
    }

    @Override
    public boolean add(DelayedChecksumInvalidation e) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(DelayedChecksumInvalidation e) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.contained.contains(e)) {
                boolean bl = true;
                return bl;
            }
            DelayedChecksumInvalidation first = this.q.peek();
            this.q.offer(e);
            this.contained.add(e);
            if (first == null || e.compareTo(first) < 0) {
                this.available.signalAll();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void put(DelayedChecksumInvalidation e) {
        this.offer(e);
    }

    @Override
    public boolean offer(DelayedChecksumInvalidation e, long timeout, TimeUnit unit) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DelayedChecksumInvalidation poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            DelayedChecksumInvalidation first = this.q.peek();
            if (first == null || first.getDelay(TimeUnit.NANOSECONDS) > 0L) {
                DelayedChecksumInvalidation delayedChecksumInvalidation = null;
                return delayedChecksumInvalidation;
            }
            DelayedChecksumInvalidation x = this.q.poll();
            assert (x != null);
            this.contained.remove(x);
            if (this.q.size() != 0) {
                this.available.signalAll();
            }
            DelayedChecksumInvalidation delayedChecksumInvalidation = x;
            return delayedChecksumInvalidation;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public DelayedChecksumInvalidation take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                DelayedChecksumInvalidation first;
                if ((first = this.q.peek()) == null) {
                    this.available.await();
                    continue;
                }
                long delay = first.getDelay(TimeUnit.NANOSECONDS);
                if (delay > 0L) {
                    this.available.awaitNanos(delay);
                    continue;
                }
                DelayedChecksumInvalidation x = this.q.poll();
                assert (x != null);
                this.contained.remove(x);
                if (this.q.size() != 0) {
                    this.available.signalAll();
                }
                DelayedChecksumInvalidation delayedChecksumInvalidation = x;
                return delayedChecksumInvalidation;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public DelayedChecksumInvalidation poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                DelayedChecksumInvalidation first;
                if ((first = this.q.peek()) == null) {
                    if (nanos <= 0L) {
                        DelayedChecksumInvalidation delayedChecksumInvalidation = null;
                        return delayedChecksumInvalidation;
                    }
                    nanos = this.available.awaitNanos(nanos);
                    continue;
                }
                long delay = first.getDelay(TimeUnit.NANOSECONDS);
                if (delay > 0L) {
                    if (nanos <= 0L) {
                        DelayedChecksumInvalidation delayedChecksumInvalidation = null;
                        return delayedChecksumInvalidation;
                    }
                    if (delay > nanos) {
                        delay = nanos;
                    }
                    long timeLeft = this.available.awaitNanos(delay);
                    nanos -= delay - timeLeft;
                    continue;
                }
                DelayedChecksumInvalidation x = this.q.poll();
                assert (x != null);
                this.contained.remove(x);
                if (this.q.size() != 0) {
                    this.available.signalAll();
                }
                DelayedChecksumInvalidation delayedChecksumInvalidation = x;
                return delayedChecksumInvalidation;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DelayedChecksumInvalidation peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            DelayedChecksumInvalidation delayedChecksumInvalidation = this.q.peek();
            return delayedChecksumInvalidation;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.q.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super DelayedChecksumInvalidation> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            DelayedChecksumInvalidation first;
            int n = 0;
            while ((first = this.q.peek()) != null && first.getDelay(TimeUnit.NANOSECONDS) <= 0L) {
                DelayedChecksumInvalidation polled = this.q.poll();
                this.contained.remove(polled);
                c.add(polled);
                ++n;
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super DelayedChecksumInvalidation> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            DelayedChecksumInvalidation first;
            int n;
            for (n = 0; n < maxElements && (first = this.q.peek()) != null && first.getDelay(TimeUnit.NANOSECONDS) <= 0L; ++n) {
                DelayedChecksumInvalidation polled = this.q.poll();
                this.contained.remove(polled);
                c.add(polled);
            }
            if (n > 0) {
                this.available.signalAll();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.q.clear();
            this.contained.clear();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            T[] TArray = this.q.toArray(a);
            return TArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean removed = this.q.remove(o);
            if (removed) {
                this.contained.remove(o);
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<DelayedChecksumInvalidation> iterator() {
        return new Itr(this.toArray());
    }

    private class Itr
    implements Iterator<DelayedChecksumInvalidation> {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public DelayedChecksumInvalidation next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return (DelayedChecksumInvalidation)this.array[this.cursor++];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            Object x = this.array[this.lastRet];
            this.lastRet = -1;
            DelayedChecksumInvalidationQueue.this.lock.lock();
            try {
                Iterator<DelayedChecksumInvalidation> it = DelayedChecksumInvalidationQueue.this.q.iterator();
                while (it.hasNext()) {
                    if (it.next() != x) continue;
                    it.remove();
                    DelayedChecksumInvalidationQueue.this.contained.remove(x);
                    return;
                }
            }
            finally {
                DelayedChecksumInvalidationQueue.this.lock.unlock();
            }
        }
    }
}

