/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.checksum.events;

import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.FolderID;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DelayedChecksumInvalidation
implements Delayed {
    private static final int DELAY_MSEC = 2000;
    private final FileID fileID;
    private final FolderID folderID;
    private final int contextID;
    private final String topic;
    private final long stamp;
    private final int hash;

    public DelayedChecksumInvalidation(int contextID, String topic, FolderID folderID, FileID fileID) {
        this.contextID = contextID;
        this.topic = topic;
        this.fileID = fileID;
        this.folderID = folderID;
        this.stamp = System.currentTimeMillis();
        int prime = 31;
        int result = 1;
        result = 31 * result + contextID;
        result = 31 * result + (fileID == null ? 0 : fileID.hashCode());
        result = 31 * result + (folderID == null ? 0 : folderID.hashCode());
        this.hash = result = 31 * result + (topic == null ? 0 : topic.hashCode());
    }

    public DelayedChecksumInvalidation(int contextID, String topic, FileID fileID) {
        this(contextID, topic, null, fileID);
    }

    public DelayedChecksumInvalidation(int contextID, String topic, FolderID folderID) {
        this(contextID, topic, folderID, null);
    }

    public FileID getFileID() {
        return this.fileID;
    }

    public FolderID getFolderID() {
        return this.folderID;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getContextID() {
        return this.contextID;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelayedChecksumInvalidation)) {
            return false;
        }
        DelayedChecksumInvalidation other = (DelayedChecksumInvalidation)obj;
        if (this.contextID != other.contextID) {
            return false;
        }
        if (this.fileID == null ? other.fileID != null : !this.fileID.equals((Object)other.fileID)) {
            return false;
        }
        if (this.folderID == null ? other.folderID != null : !this.folderID.equals((Object)other.folderID)) {
            return false;
        }
        return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
    }

    @Override
    public int compareTo(Delayed o) {
        long thisStamp = this.stamp;
        long otherStamp = ((DelayedChecksumInvalidation)o).stamp;
        return thisStamp < otherStamp ? -1 : (thisStamp == otherStamp ? 0 : 1);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(2000L - (System.currentTimeMillis() - this.stamp), TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return "DelayedChecksumInvalidation [fileID=" + this.fileID + ", folderID=" + this.folderID + ", contextID=" + this.contextID + ", topic=" + this.topic + "]";
    }
}

