/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.checksum.events;

import com.openexchange.drive.DriveClientType;
import com.openexchange.drive.DriveUtils;
import com.openexchange.drive.checksum.events.DelayedChecksumInvalidation;
import com.openexchange.drive.checksum.events.DelayedChecksumInvalidationQueue;
import com.openexchange.drive.checksum.rdb.RdbChecksumStore;
import com.openexchange.drive.internal.DriveServiceLookup;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageEventHelper;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.java.Strings;
import com.openexchange.server.Initialization;
import com.openexchange.session.Session;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedChecksumEventListener
implements EventHandler,
Initialization {
    private static final Logger LOG = LoggerFactory.getLogger(DelayedChecksumEventListener.class);
    private static final int TRIGGER_INTERVAL = 2000;
    private static final DelayedChecksumEventListener instance = new DelayedChecksumEventListener();
    private final DelayedChecksumInvalidationQueue invalidationQueue;
    private final AtomicBoolean started = new AtomicBoolean();
    private ScheduledTimerTask timerTask;

    public static String[] getHandledTopics() {
        return new String[]{"com/openexchange/groupware/infostore/delete", "com/openexchange/groupware/infostore/update", "com/openexchange/groupware/infostore/insert", "com/openexchange/groupware/fsfolder/delete", "com/openexchange/groupware/fsfolder/update"};
    }

    public static DelayedChecksumEventListener getInstance() {
        return instance;
    }

    private DelayedChecksumEventListener() {
        this.invalidationQueue = new DelayedChecksumInvalidationQueue();
    }

    public void start() throws OXException {
        if (!this.started.compareAndSet(false, true)) {
            LOG.warn("Already started - aborting.");
            return;
        }
        TimerService timerService = DriveServiceLookup.getService(TimerService.class);
        this.timerTask = timerService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    DelayedChecksumEventListener.this.triggerChecksumInvalidation();
                }
                catch (Exception e) {
                    LOG.warn("Error triggering checksum invalidations", (Throwable)e);
                }
            }
        }, 2000L, 2000L);
    }

    public void stop() throws OXException {
        if (!this.started.compareAndSet(true, false)) {
            LOG.warn("Not started - aborting.");
            return;
        }
        if (null != this.timerTask) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }

    public void handleEvent(final Event event) {
        try {
            Session session = FileStorageEventHelper.extractSession((Event)event);
            if (null == session || DelayedChecksumEventListener.isDriveSession(session)) {
                return;
            }
            LOG.debug("{}", new Object(){

                public String toString() {
                    return FileStorageEventHelper.createDebugMessage((String)"event", (Event)event);
                }
            });
            int contextID = session.getContextId();
            String topic = event.getTopic();
            if ("com/openexchange/groupware/infostore/delete".equals(topic) || "com/openexchange/groupware/infostore/update".equals(topic) || "com/openexchange/groupware/infostore/insert".equals(topic)) {
                String serviceID = FileStorageEventHelper.extractService((Event)event);
                String accountID = FileStorageEventHelper.extractAccountId((Event)event);
                String folderID = FileStorageEventHelper.extractFolderId((Event)event);
                String objectID = FileStorageEventHelper.extractObjectId((Event)event);
                String fileName = (String)event.getProperty("fileName");
                if (!Strings.isEmpty((String)fileName) && (DriveUtils.isInvalidFileName(fileName) || DriveUtils.isIgnoredFileName(fileName))) {
                    LOG.trace("Skipping event processing for ignored file: {}", (Object)fileName);
                    return;
                }
                this.invalidationQueue.offer(new DelayedChecksumInvalidation(contextID, topic, new FolderID(serviceID, accountID, folderID), new FileID(serviceID, accountID, folderID, objectID)));
            } else if ("com/openexchange/groupware/fsfolder/delete".equals(topic) || "com/openexchange/groupware/fsfolder/update".equals(topic)) {
                String serviceID = FileStorageEventHelper.extractService((Event)event);
                String accountID = FileStorageEventHelper.extractAccountId((Event)event);
                String folderID = FileStorageEventHelper.extractFolderId((Event)event);
                this.invalidationQueue.offer(new DelayedChecksumInvalidation(contextID, topic, new FolderID(serviceID, accountID, folderID), null));
            }
        }
        catch (OXException e) {
            LOG.warn("unexpected error during event handling", (Throwable)e);
        }
    }

    private void triggerChecksumInvalidation() {
        DelayedChecksumInvalidation invalidation = this.invalidationQueue.poll();
        if (null != invalidation) {
            ArrayList<DelayedChecksumInvalidation> invalidations = new ArrayList<DelayedChecksumInvalidation>();
            do {
                invalidations.add(invalidation);
            } while (null != (invalidation = this.invalidationQueue.poll()));
            this.invalidateChecksums(invalidations);
        }
    }

    private void invalidateChecksums(List<DelayedChecksumInvalidation> invalidations) {
        if (null != invalidations && 0 < invalidations.size()) {
            HashMap<Integer, Set<FolderID>> directoryChecksumsToInvalidate = new HashMap<Integer, Set<FolderID>>();
            HashMap<Integer, Set<FileID>> fileChecksumsToInvalidate = new HashMap<Integer, Set<FileID>>();
            HashMap<Integer, Set<FolderID>> fileChecksumsInFolderToInvalidate = new HashMap<Integer, Set<FolderID>>();
            for (DelayedChecksumInvalidation invalidation : invalidations) {
                Set<FolderID> folderIDs;
                String topic = invalidation.getTopic();
                Integer contextID = invalidation.getContextID();
                if ("com/openexchange/groupware/infostore/delete".equals(topic) || "com/openexchange/groupware/infostore/update".equals(topic) || "com/openexchange/groupware/infostore/insert".equals(topic)) {
                    if (null != invalidation.getFolderID()) {
                        folderIDs = (HashSet<FolderID>)directoryChecksumsToInvalidate.get(contextID);
                        if (null == folderIDs) {
                            folderIDs = new HashSet<FolderID>();
                            directoryChecksumsToInvalidate.put(contextID, folderIDs);
                        }
                        folderIDs.add(invalidation.getFolderID());
                    }
                    if (!"com/openexchange/groupware/infostore/delete".equals(topic) && (!"com/openexchange/groupware/infostore/update".equals(topic) || null == invalidation.getFileID())) continue;
                    HashSet<FileID> fileIDs = (HashSet<FileID>)fileChecksumsToInvalidate.get(contextID);
                    if (null == fileIDs) {
                        fileIDs = new HashSet<FileID>();
                        fileChecksumsToInvalidate.put(contextID, fileIDs);
                    }
                    fileIDs.add(invalidation.getFileID());
                    continue;
                }
                if (!"com/openexchange/groupware/fsfolder/delete".equals(topic) && !"com/openexchange/groupware/fsfolder/update".equals(topic)) continue;
                folderIDs = (Set)directoryChecksumsToInvalidate.get(contextID);
                if (null == folderIDs) {
                    folderIDs = new HashSet();
                    directoryChecksumsToInvalidate.put(contextID, folderIDs);
                }
                folderIDs.add(invalidation.getFolderID());
                folderIDs = (Set)fileChecksumsInFolderToInvalidate.get(contextID);
                if (null == folderIDs) {
                    folderIDs = new HashSet();
                    fileChecksumsInFolderToInvalidate.put(contextID, folderIDs);
                }
                folderIDs.add(invalidation.getFolderID());
            }
            DelayedChecksumEventListener.invalidateDirectoryChecksums(directoryChecksumsToInvalidate);
            DelayedChecksumEventListener.invalidateFileChecksums(fileChecksumsToInvalidate);
            DelayedChecksumEventListener.invalidateFileChecksumsInFolder(fileChecksumsInFolderToInvalidate);
        }
    }

    private static void invalidateDirectoryChecksums(Map<Integer, Set<FolderID>> directoryChecksumsToInvalidate) {
        if (0 < directoryChecksumsToInvalidate.size()) {
            try {
                for (Map.Entry<Integer, Set<FolderID>> entry : directoryChecksumsToInvalidate.entrySet()) {
                    RdbChecksumStore checksumStore = new RdbChecksumStore(entry.getKey());
                    LOG.debug("Invalidating directory checksums for {} folders in context {}...", (Object)entry.getValue().size(), (Object)entry.getKey());
                    checksumStore.removeDirectoryChecksums(new ArrayList<FolderID>((Collection)entry.getValue()));
                }
            }
            catch (OXException e) {
                LOG.warn("Error invalidating directory checksums", (Throwable)e);
            }
        }
    }

    private static void invalidateFileChecksums(Map<Integer, Set<FileID>> fileChecksumsToInvalidate) {
        if (0 < fileChecksumsToInvalidate.size()) {
            try {
                for (Map.Entry<Integer, Set<FileID>> entry : fileChecksumsToInvalidate.entrySet()) {
                    RdbChecksumStore checksumStore = new RdbChecksumStore(entry.getKey());
                    LOG.debug("Invalidating file checksums for {} files in context {}...", (Object)entry.getValue().size(), (Object)entry.getKey());
                    checksumStore.removeFileChecksums(entry.getValue().toArray(new FileID[entry.getValue().size()]));
                }
            }
            catch (OXException e) {
                LOG.warn("Error invalidating file checksums", (Throwable)e);
            }
        }
    }

    private static void invalidateFileChecksumsInFolder(Map<Integer, Set<FolderID>> fileChecksumsInFolderToInvalidate) {
        if (0 < fileChecksumsInFolderToInvalidate.size()) {
            try {
                for (Map.Entry<Integer, Set<FolderID>> entry : fileChecksumsInFolderToInvalidate.entrySet()) {
                    RdbChecksumStore checksumStore = new RdbChecksumStore(entry.getKey());
                    LOG.debug("Invalidating file checksums for {} folders in context {}...", (Object)entry.getValue().size(), (Object)entry.getKey());
                    checksumStore.removeFileChecksumsInFolders(new ArrayList<FolderID>((Collection)entry.getValue()));
                }
            }
            catch (OXException e) {
                LOG.warn("Error invalidating file checksums in folder", (Throwable)e);
            }
        }
    }

    private static boolean isDriveSession(Session session) {
        return null != session && false == DriveClientType.UNKNOWN.equals((Object)DriveClientType.parse(session.getClient()));
    }
}

