/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.actions;

import com.openexchange.drive.Action;
import com.openexchange.drive.DriveAction;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.actions.AbstractFileAction;
import com.openexchange.drive.comparison.ThreeWayComparison;

public class EditFileAction
extends AbstractFileAction {
    private int sortKey;

    public EditFileAction(FileVersion file, FileVersion newFile, ThreeWayComparison<FileVersion> comparison, String path) {
        this(file, newFile, comparison, path, 0);
    }

    public EditFileAction(FileVersion file, FileVersion newFile, ThreeWayComparison<FileVersion> comparison, String path, int sortKey) {
        this(file, newFile, comparison, path, sortKey, true);
    }

    public EditFileAction(FileVersion file, FileVersion newFile, ThreeWayComparison<FileVersion> comparison, String path, boolean acknowledge) {
        this(file, newFile, comparison, path, 0, acknowledge);
    }

    public EditFileAction(FileVersion file, FileVersion newFile, ThreeWayComparison<FileVersion> comparison, String path, int sortKey, boolean acknowledge) {
        super(file, newFile, comparison);
        this.sortKey = sortKey;
        this.parameters.put("path", path);
        if (!acknowledge) {
            this.parameters.put("acknowledge", acknowledge);
        }
    }

    @Override
    public Action getAction() {
        return Action.EDIT;
    }

    public int getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(int sortKey) {
        this.sortKey = sortKey;
    }

    @Override
    public int compareTo(DriveAction<FileVersion> other) {
        int result = super.compareTo(other);
        if (0 != result) {
            return result;
        }
        if (EditFileAction.class.isInstance(other)) {
            EditFileAction otherEditFileAction = (EditFileAction)other;
            result = this.getSortKey() - otherEditFileAction.getSortKey();
            if (0 != result) {
                return result;
            }
            if (null != this.getNewVersion() && null != otherEditFileAction.getNewVersion()) {
                result = -1 * ((FileVersion)this.getNewVersion()).getName().compareTo(((FileVersion)otherEditFileAction.getNewVersion()).getName());
            }
            if (0 != result) {
                return result;
            }
        }
        return result;
    }
}

