/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive.actions;

import com.openexchange.drive.Action;
import com.openexchange.drive.DriveFileField;
import com.openexchange.drive.FileVersion;
import com.openexchange.drive.actions.AbstractAction;
import com.openexchange.drive.comparison.ThreeWayComparison;
import com.openexchange.drive.internal.SyncSession;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import java.util.List;
import java.util.Map;

public abstract class AbstractFileAction
extends AbstractAction<FileVersion> {
    protected AbstractFileAction(FileVersion version, FileVersion newVersion, ThreeWayComparison<FileVersion> comparison) {
        super(version, newVersion, comparison);
    }

    protected void applyMetadataParameters(File file, SyncSession session) {
        if (null != file) {
            List<DriveFileField> fields;
            this.parameters.put("totalLength", file.getFileSize());
            if (null != file.getCreated()) {
                this.parameters.put("created", file.getCreated().getTime());
            }
            if (null != file.getLastModified()) {
                this.parameters.put("modified", file.getLastModified().getTime());
            }
            if (null != (fields = session.getFields())) {
                String previewLink;
                String thumbnailLink;
                String directLinkFragments;
                String directLink;
                String contentType;
                if (fields.contains((Object)DriveFileField.CONTENT_TYPE) && null != (contentType = file.getFileMIMEType())) {
                    this.parameters.put("contentType", contentType);
                }
                if (fields.contains((Object)DriveFileField.DIRECT_LINK) && null != (directLink = session.getLinkGenerator().getFileLink(file))) {
                    this.parameters.put("directLink", directLink);
                }
                if (fields.contains((Object)DriveFileField.DIRECT_LINK_FRAGMENTS) && null != (directLinkFragments = session.getLinkGenerator().getFileLinkFragments(file))) {
                    this.parameters.put("directLinkFragments", directLinkFragments);
                }
                if (fields.contains((Object)DriveFileField.THUMBNAIL_LINK) && null != (thumbnailLink = session.getLinkGenerator().getFileThumbnailLink(file))) {
                    this.parameters.put("thumbnailLink", thumbnailLink);
                }
                if (fields.contains((Object)DriveFileField.PREVIEW_LINK) && null != (previewLink = session.getLinkGenerator().getFilePreviewLink(file))) {
                    this.parameters.put("previewLink", previewLink);
                }
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + FileVersion.class.hashCode();
        Action action = this.getAction();
        result = 31 * result + (null == action ? 0 : action.hashCode());
        if (null != this.version) {
            result = 31 * result + ((FileVersion)this.version).getChecksum().hashCode();
            result = 31 * result + ((FileVersion)this.version).getName().hashCode();
        }
        if (null != this.newVersion) {
            result = 31 * result + ((FileVersion)this.newVersion).getChecksum().hashCode();
            result = 31 * result + ((FileVersion)this.newVersion).getName().hashCode();
        }
        if (null != this.parameters) {
            for (Map.Entry parameter : this.parameters.entrySet()) {
                String key = (String)parameter.getKey();
                Object value = parameter.getValue();
                if ("error".equals(key) && null != value && OXException.class.isInstance(value)) {
                    result = 31 * result + (null == key ? 0 : key.hashCode()) ^ ((OXException)value).getErrorCode().hashCode();
                    continue;
                }
                result = 31 * result + (null == key ? 0 : key.hashCode()) ^ (null == value ? 0 : value.hashCode());
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractFileAction)) {
            return false;
        }
        AbstractFileAction other = (AbstractFileAction)obj;
        if (this.newVersion == null ? other.newVersion != null : !((FileVersion)this.newVersion).equals(other.newVersion)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !((FileVersion)this.version).equals(other.version));
    }
}

