/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.drive;

import com.openexchange.file.storage.File;
import com.openexchange.java.util.TimeZones;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class DriveConstants {
    public static final String ROOT_PATH = "/";
    public static final char PATH_SEPARATOR = '/';
    public static final String TEMP_PATH = "/.drive";
    public static final String FILEPART_EXTENSION = ".drivepart";
    public static final List<File.Field> FILE_FIELDS = Arrays.asList(File.Field.ID, File.Field.FOLDER_ID, File.Field.LAST_MODIFIED, File.Field.TITLE, File.Field.FILENAME, File.Field.FILE_MD5SUM, File.Field.FILE_SIZE, File.Field.VERSION, File.Field.SEQUENCE_NUMBER, File.Field.FILE_MIMETYPE, File.Field.CREATED);
    public static final String EMPTY_MD5 = "d41d8cd98f00b204e9800998ecf8427e";
    public static final int MAX_RETRIES = 5;
    public static final int RETRY_BASEDELAY = 1000;
    public static final long OPTIMISTIC_UPLOAD_SIZE_THRESHOLD = 65536L;
    public static final int MAX_PATH_SEGMENT_LENGTH = 255;
    public static int DEFAULT_MIN_API_VERSION = 1;
    public static int SUPPORTED_API_VERSION = 2;
    public static final ThreadLocal<SimpleDateFormat> LOG_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            dateFormat.setTimeZone(TimeZones.UTC);
            return dateFormat;
        }
    };
    public static final Pattern CHECKSUM_VALIDATION_PATTERN = Pattern.compile("^[0-9a-f]{32}\\z");
    public static final Pattern FILENAME_VALIDATION_PATTERN = Pattern.compile("^                                # Anchor to start of string.        \n(?!                              # Assert filename is not: CON, PRN, \n  (?:                            # AUX, NUL, COM1, COM2, COM3, COM4, \n    CON|PRN|AUX|NUL|             # COM5, COM6, COM7, COM8, COM9,     \n    COM[1-9]|LPT[1-9]            # LPT1, LPT2, LPT3, LPT4, LPT5,     \n  )                              # LPT6, LPT7, LPT8, and LPT9...     \n  (?:\\.[^.]*)?                  # followed by optional extension    \n  $                              # and end of string                 \n)                                # End negative lookahead assertion. \n[^<>:/?*\"\\\\|\\x00-\\x1F]*     # Zero or more valid filename chars.\n[^<>:/?*\"\\\\|\\x00-\\x1F\\ .]  # Last char is not a space or dot.  \n$                                # Anchor to end of string.            ", 70);
    public static final Pattern PATH_VALIDATION_PATTERN = Pattern.compile("^(?:/|(?:/[^<>:/?*\"\\\\|\\x00-\\x1F]*[^<>:/?*\"\\\\|\\x00-\\x1F\\ .])+)$", 66);
}

