/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.parser;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderChildObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.TestException;
import com.openexchange.webdav.xml.XmlServlet;
import com.openexchange.webdav.xml.parser.FolderChildParser;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class FolderParser
extends FolderChildParser {
    public void parse(FolderObject folder, Element eProp) throws OXException, OXException {
        if (FolderParser.hasElement(eProp.getChild("title", XmlServlet.NS))) {
            folder.setFolderName(FolderParser.getValue(eProp.getChild("title", XmlServlet.NS)));
        }
        if (FolderParser.hasElement(eProp.getChild("type", XmlServlet.NS))) {
            String type = FolderParser.getValue(eProp.getChild("type", XmlServlet.NS));
            if (type.equals("private") || type.equals("shared")) {
                folder.setType(1);
            } else if (type.equals("public")) {
                folder.setType(2);
            } else {
                throw OXException.general((String)("unknown value in type: " + type));
            }
        }
        if (FolderParser.hasElement(eProp.getChild("module", XmlServlet.NS))) {
            String module = eProp.getChild("module", XmlServlet.NS).getValue();
            if (module.equals("calendar")) {
                folder.setModule(2);
            } else if (module.equals("contact")) {
                folder.setModule(3);
            } else if (module.equals("task")) {
                folder.setModule(1);
            } else if (module.equals("unbound")) {
                folder.setModule(4);
            } else {
                throw OXException.general((String)("unknown value in module: " + module));
            }
        }
        if (FolderParser.hasElement(eProp.getChild("defaultfolder", XmlServlet.NS))) {
            folder.setDefaultFolder(FolderParser.getValueAsBoolean(eProp.getChild("defaultfolder", XmlServlet.NS)));
        }
        if (FolderParser.hasElement(eProp.getChild("permissions", XmlServlet.NS))) {
            this.parseElementPermissions(folder, eProp.getChild("permissions", XmlServlet.NS));
        }
        this.parseElementFolderChildObject((FolderChildObject)folder, eProp);
    }

    protected void parseElementPermissions(FolderObject folder, Element ePermissions) throws OXException {
        ArrayList<OCLPermission> permissions = new ArrayList<OCLPermission>();
        try {
            List elementPermissions = ePermissions.getChildren();
            for (int a = 0; a < elementPermissions.size(); ++a) {
                Element e = (Element)elementPermissions.get(a);
                if (!e.getNamespace().equals((Object)XmlServlet.NS)) continue;
                OCLPermission oclp = new OCLPermission();
                if (e.getName().equals("user")) {
                    this.parseElementPermissionAttributes(oclp, e);
                    this.parseEntity(oclp, e);
                } else if (e.getName().equals("group")) {
                    this.parseElementPermissionAttributes(oclp, e);
                    this.parseEntity(oclp, e);
                    oclp.setGroupPermission(true);
                } else {
                    throw OXException.general((String)"unknown xml tag in permissions!");
                }
                permissions.add(oclp);
            }
        }
        catch (OXException e) {
            throw new TestException((Exception)((Object)e));
        }
        folder.setPermissions(permissions);
    }

    protected void parseEntity(OCLPermission oclp, Element e) {
        oclp.setEntity(FolderParser.getValueAsInt(e));
    }

    protected void parseElementPermissionAttributes(OCLPermission oclp, Element e) {
        int fp = this.getPermissionAttributeValue(e, "folderpermission");
        int orp = this.getPermissionAttributeValue(e, "objectreadpermission");
        int owp = this.getPermissionAttributeValue(e, "objectwritepermission");
        int odp = this.getPermissionAttributeValue(e, "objectdeletepermission");
        oclp.setAllPermission(fp, orp, owp, odp);
        oclp.setFolderAdmin(this.getPermissionAdminFlag(e));
    }

    protected int getPermissionAttributeValue(Element e, String name) {
        return Integer.parseInt(e.getAttributeValue(name, XmlServlet.NS));
    }

    protected boolean getPermissionAdminFlag(Element e) {
        return Boolean.parseBoolean(e.getAttributeValue("admin_flag", XmlServlet.NS));
    }
}

