/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.contact;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.webdav.xml.AttachmentTest;
import com.openexchange.webdav.xml.ContactTest;
import com.openexchange.webdav.xml.FolderTest;
import java.io.ByteArrayInputStream;
import java.util.Locale;

public class NewTest
extends ContactTest {
    public NewTest(String name) {
        super(name);
    }

    public void testNewContact() throws Exception {
        Contact contactObj = this.createContactObject("testNewContact");
        int objectId = NewTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        contactObj.setObjectID(objectId);
        Contact loadContact = ContactTest.loadContact(this.getWebConversation(), objectId, this.contactFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(contactObj, loadContact);
    }

    public void testNewContactWithAttachment() throws Exception {
        Contact contactObj = this.createContactObject("testNewContactWithAttachment");
        int objectId = NewTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        contactObj.setNumberOfAttachments(2);
        contactObj.setObjectID(objectId);
        AttachmentImpl attachmentObj = new AttachmentImpl();
        attachmentObj.setFilename(System.currentTimeMillis() + "test1.txt");
        attachmentObj.setModuleId(7);
        attachmentObj.setAttachedId(objectId);
        attachmentObj.setFolderId(this.contactFolderId);
        attachmentObj.setRtfFlag(false);
        attachmentObj.setFileMIMEType("plain/text");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("t1".getBytes());
        AttachmentTest.insertAttachment(this.webCon, (AttachmentMetadata)attachmentObj, byteArrayInputStream, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        byteArrayInputStream = new ByteArrayInputStream("t2".getBytes());
        AttachmentTest.insertAttachment(this.webCon, (AttachmentMetadata)attachmentObj, byteArrayInputStream, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Contact loadContact = ContactTest.loadContact(this.getWebConversation(), objectId, this.contactFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(contactObj, loadContact);
    }

    public void testContactInPrivateFlagInPublicFolder() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testContactInPrivateFlagInPublicFolder" + System.currentTimeMillis());
        folderObj.setModule(3);
        folderObj.setType(2);
        folderObj.setParentFolderID(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 128, 128, 128, 128)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Contact contactObj = new Contact();
        contactObj.setSurName("testContactInPrivateFlagInPublicFolder");
        contactObj.setPrivateFlag(true);
        contactObj.setParentFolderID(parentFolderId);
        try {
            int objectId = NewTest.insertContact(this.getWebConversation(), contactObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
            NewTest.deleteContact(this.getWebConversation(), objectId, parentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
            NewTest.fail((String)"conflict exception expected!");
        }
        catch (OXException exc) {
            NewTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), "CON-0171");
        }
    }

    public void testContactWithAttachment() throws Exception {
        Contact contactObj = this.createContactObject("testContactWithAttachment");
        int objectId = NewTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        contactObj.setObjectID(objectId);
        contactObj.setNumberOfAttachments(1);
        AttachmentImpl attachmentMeta = new AttachmentImpl();
        attachmentMeta.setAttachedId(objectId);
        attachmentMeta.setFolderId(this.contactFolderId);
        attachmentMeta.setFileMIMEType("text/plain");
        attachmentMeta.setModuleId(7);
        attachmentMeta.setFilename("test.txt");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("test".getBytes());
        AttachmentTest.insertAttachment(this.webCon, (AttachmentMetadata)attachmentMeta, byteArrayInputStream, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Contact loadContact = NewTest.loadContact(this.getWebConversation(), objectId, this.contactFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Contact[] contactArray = NewTest.listContact(this.getWebConversation(), this.contactFolderId, NewTest.decrementDate(loadContact.getLastModified()), true, false, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        boolean found = false;
        for (int a = 0; a < contactArray.length; ++a) {
            if (contactArray[a].getObjectID() != objectId) continue;
            NewTest.compareObject(contactObj, contactArray[a]);
            found = true;
        }
        NewTest.assertTrue((String)"task not found", (boolean)found);
    }
}

