/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.osgi;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.parser.FolderParser;
import com.openexchange.control.console.StartBundle;
import com.openexchange.control.console.StopBundle;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.JMXInit;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class AbstractBundleTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBundleTest.class);
    protected static final String PROTOCOL = "http://";
    private WebConversation webConversation;
    protected StartBundle startBundle;
    protected StopBundle stopBundle;
    private static final String LOGIN_URL = "/ajax/login";
    private static final String FOLDER_URL = "/ajax/folders";

    protected AbstractBundleTest(String name) {
        super(name);
    }

    protected String getJMXHost() {
        return JMXInit.getJMXProperty(JMXInit.Property.JMX_HOST);
    }

    protected int getJMXPort() {
        return Integer.parseInt(JMXInit.getJMXProperty(JMXInit.Property.JMX_PORT));
    }

    protected String getJMXLogin() {
        return JMXInit.getJMXProperty(JMXInit.Property.JMX_LOGIN);
    }

    protected String getJMXPassword() {
        return JMXInit.getJMXProperty(JMXInit.Property.JMX_PASSWORD);
    }

    protected WebConversation getWebConversation() {
        if (this.webConversation == null) {
            this.webConversation = this.newWebConversation();
        }
        return this.webConversation;
    }

    protected WebConversation newWebConversation() {
        HttpUnitOptions.setDefaultCharacterSet((String)"UTF-8");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        return new WebConversation();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.stopBundle = new StopBundle(this.getJMXHost(), this.getJMXPort(), this.getJMXLogin(), this.getJMXPassword());
        this.startBundle = new StartBundle(this.getJMXHost(), this.getJMXPort(), this.getJMXLogin(), this.getJMXPassword());
        this.stopBundle.stop(this.getBundleName());
        LOG.info("Bundle stopped: " + this.getBundleName());
    }

    public void tearDown() throws Exception {
        this.startBundle.start(this.getBundleName());
        LOG.info("Bundle started: " + this.getBundleName());
        this.stopBundle = null;
        this.startBundle = null;
        super.tearDown();
    }

    protected abstract String getBundleName();

    protected static JSONObject login(WebConversation conversation, String hostname, String login, String password) throws IOException, SAXException, JSONException {
        JSONObject json;
        PostMethodWebRequest req = new PostMethodWebRequest(PROTOCOL + hostname + LOGIN_URL);
        req.setParameter("action", "login");
        req.setParameter("name", login);
        req.setParameter("password", password);
        WebResponse resp = conversation.getResponse((WebRequest)req);
        AbstractBundleTest.assertEquals((String)"Response code is not okay.", (int)200, (int)resp.getResponseCode());
        String body = resp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            LOG.error("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        return json;
    }

    protected static JSONObject getRootFolders(WebConversation conversation, String hostname, String sessionId) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        GetMethodWebRequest req = new GetMethodWebRequest(PROTOCOL + hostname + FOLDER_URL);
        req.setParameter("session", sessionId);
        req.setParameter("action", "root");
        String columns = "1,301,300,304";
        req.setParameter("columns", "1,301,300,304");
        WebResponse resp = conversation.getResponse((WebRequest)req);
        AbstractBundleTest.assertEquals((String)"Response code is not okay.", (int)200, (int)resp.getResponseCode());
        String body = resp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            LOG.error("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        return json;
    }

    protected static int getStandardCalendarFolder(WebConversation conversation, String hostname, String sessionId) throws MalformedURLException, IOException, SAXException, JSONException, OXException {
        List<FolderObject> subfolders = AbstractBundleTest.getSubfolders(conversation, hostname, sessionId, "1", true);
        for (FolderObject subfolder : subfolders) {
            if (subfolder.getModule() != 2 || !subfolder.isDefaultFolder()) continue;
            return subfolder.getObjectID();
        }
        return -1;
    }

    protected static int getStandardInfostoreFolder(WebConversation conversation, String hostname, String sessionId) throws MalformedURLException, IOException, SAXException, JSONException, OXException {
        List<FolderObject> subfolders = AbstractBundleTest.getSubfolders(conversation, hostname, sessionId, "1", true);
        for (FolderObject subfolder : subfolders) {
            if (subfolder.getModule() != 8 || !subfolder.isDefaultFolder()) continue;
            return subfolder.getObjectID();
        }
        return -1;
    }

    protected static List<FolderObject> getSubfolders(WebConversation conversation, String hostname, String sessionId, String parentIdentifier, boolean ignoreMailfolder) throws MalformedURLException, IOException, SAXException, JSONException, OXException {
        WebResponse resp;
        JSONObject respObj;
        GetMethodWebRequest req = new GetMethodWebRequest(PROTOCOL + hostname + FOLDER_URL);
        req.setParameter("session", sessionId);
        req.setParameter("action", "list");
        req.setParameter("parent", parentIdentifier);
        String columns = "1,301,300,304,308,2";
        req.setParameter("columns", "1,301,300,304,308,2");
        if (ignoreMailfolder) {
            req.setParameter("ignore", "mailfolder");
        }
        if ((respObj = new JSONObject((resp = conversation.getResponse((WebRequest)req)).getText())).has("error") && !respObj.isNull("error")) {
            throw OXException.general((String)("Error occured: " + respObj.getString("error")));
        }
        if (!respObj.has("data") || respObj.isNull("data")) {
            throw OXException.general((String)"Error occured: Missing key \"data\"");
        }
        JSONArray data = respObj.getJSONArray("data");
        ArrayList<FolderObject> folders = new ArrayList<FolderObject>();
        for (int i = 0; i < data.length(); ++i) {
            JSONArray arr = data.getJSONArray(i);
            FolderObject subfolder = new FolderObject();
            try {
                subfolder.setObjectID(arr.getInt(0));
            }
            catch (JSONException exc) {
                subfolder.removeObjectID();
                subfolder.setFullName(arr.getString(0));
            }
            subfolder.setModule(FolderParser.getModuleFromString((String)arr.getString(1), (int)(subfolder.containsObjectID() ? subfolder.getObjectID() : -1)));
            subfolder.setFolderName(arr.getString(2));
            subfolder.setSubfolderFlag(arr.getBoolean(3));
            subfolder.setDefaultFolder(arr.getBoolean(4));
            if (!arr.isNull(5)) {
                subfolder.setCreatedBy(arr.getInt(5));
            }
            folders.add(subfolder);
        }
        return folders;
    }
}

