/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures.transformators;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.resource.Resource;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.SimpleCredentials;
import com.openexchange.test.fixtures.transformators.Transformator;
import java.util.ArrayList;

public class ParticipantTransformator
implements Transformator {
    private final FixtureLoader fixtureLoader;

    public ParticipantTransformator(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Object transform(String value) throws OXException {
        if (null == value || 1 > value.length()) {
            return null;
        }
        String fixtureName = "users";
        String fixtureEntry = "";
        String[] splitted = value.split(",");
        ArrayList<Participant> participants = new ArrayList<Participant>(splitted.length);
        for (int i = 0; i < splitted.length; ++i) {
            int idx = splitted[i].indexOf(58);
            if (0 < idx && splitted[i].length() > idx) {
                fixtureName = splitted[i].substring(0, idx);
                fixtureEntry = splitted[i].substring(idx + 1);
            } else {
                fixtureEntry = splitted[i];
            }
            participants.add(this.getParticipant(fixtureName, fixtureEntry));
        }
        return participants;
    }

    private Participant getParticipant(String fixtureName, String fixtureEntry) throws OXException {
        if ("users".equals(fixtureName)) {
            return this.getUserParticipant(fixtureName, fixtureEntry);
        }
        if ("groups".equals(fixtureName)) {
            return this.getGroupParticipant(fixtureName, fixtureEntry);
        }
        if ("contacts".equals(fixtureName)) {
            return this.getExternalUserParticipant(fixtureName, fixtureEntry);
        }
        if ("resources".equals(fixtureName)) {
            return this.getResourceParticipant(fixtureName, fixtureEntry);
        }
        throw OXException.general((String)("Unable to convert " + fixtureName + ":" + fixtureEntry + " into a participant."));
    }

    private Participant getExternalUserParticipant(String fixtureName, String fixtureEntry) throws OXException {
        Contact contact = this.fixtureLoader.getFixtures(fixtureName, Contact.class).getEntry(fixtureEntry).getEntry();
        String email = null;
        if (contact.containsEmail1()) {
            email = contact.getEmail1();
        } else if (contact.containsEmail2()) {
            email = contact.getEmail2();
        } else if (contact.containsEmail3()) {
            email = contact.getEmail3();
        }
        if (null == email) {
            throw OXException.general((String)"External participants must contain an email address");
        }
        ExternalUserParticipant participant = new ExternalUserParticipant(email);
        participant.setDisplayName(contact.getDisplayName());
        participant.setIdentifier(contact.getObjectID());
        return participant;
    }

    private GroupParticipant getGroupParticipant(String fixtureName, String fixtureEntry) throws OXException {
        Group group = this.fixtureLoader.getFixtures(fixtureName, Group.class).getEntry(fixtureEntry).getEntry();
        GroupParticipant participant = new GroupParticipant(group.getIdentifier());
        participant.setDisplayName(group.getDisplayName());
        return participant;
    }

    private UserParticipant getUserParticipant(String fixtureName, String fixtureEntry) throws OXException {
        Contact user = this.fixtureLoader.getFixtures(fixtureName, SimpleCredentials.class).getEntry(fixtureEntry).getEntry().asContact();
        UserParticipant participant = new UserParticipant(user.getObjectID());
        participant.setDisplayName(user.getDisplayName());
        participant.setEmailAddress(user.getEmail1());
        return participant;
    }

    private ResourceParticipant getResourceParticipant(String fixtureName, String fixtureEntry) throws OXException {
        Resource resource = this.fixtureLoader.getFixtures(fixtureName, Resource.class).getEntry(fixtureEntry).getEntry();
        ResourceParticipant participant = new ResourceParticipant(resource.getIdentifier());
        participant.setDisplayName(resource.getDisplayName());
        participant.setEmailAddress(resource.getMail());
        return participant;
    }
}

