/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.replyforward;

import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Charsets;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.MailField;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.internet.InternetAddress;

public final class MailForwardTest
extends AbstractMailTest {
    private static final String RFC822_SRC = "Return-Path: <manuel.kraft@open-xchange.com>\nReceived: from ox.netline-is.de ([unix socket])\n\tby ox (Cyrus v2.2.3) with LMTP; Wed, 02 Apr 2008 07:42:19 +0200\nX-Sieve: CMU Sieve 2.2\nReceived: by ox.netline-is.de (Postfix, from userid 65534)\n\tid 49AB33DB402; Wed,  2 Apr 2008 07:42:19 +0200 (CEST)\nReceived: from netline.de (comfire.netline.de [192.168.32.1])\n\tby ox.netline-is.de (Postfix) with ESMTP id 744013DB3F7\n\tfor <thorben@open-xchange.com>; Wed,  2 Apr 2008 07:42:17 +0200 (CEST)\nReceived: from [10.20.30.11] (helo=www.open-xchange.org ident=mail)\n\tby netline.de with esmtp (Exim)\n\tid 1JgvaA-00032q-00\n\tfor thorben@open-xchange.com; Wed, 02 Apr 2008 07:32:22 +0200\nReceived: from mail.open-xchange.com ([10.20.30.22] helo=ox.open-xchange.com)\n\tby www.open-xchange.org with esmtp (Exim 3.36 #1 (Debian))\n\tid 1Jgvix-0004np-00\n\tfor <thorben@open-xchange.org>; Wed, 02 Apr 2008 07:41:27 +0200\nReceived: by ox.open-xchange.com (Postfix, from userid 76)\n\tid 890B032C833; Wed,  2 Apr 2008 07:41:26 +0200 (CEST)\nReceived: from ox.open-xchange.com ([unix socket])\n\t by ox.open-xchange.com (Cyrus v2.2.12-Invoca-RPM-2.2.12-8.1.RHEL4) with LMTPA;\n\t Wed, 02 Apr 2008 07:41:26 +0200\nX-Sieve: CMU Sieve 2.2\nReceived: by ox.open-xchange.com (Postfix, from userid 99)\n\tid 4C6F232C887; Wed,  2 Apr 2008 07:41:26 +0200 (CEST)\nReceived: from oxee (unknown [192.168.32.9])\n\tby ox.open-xchange.com (Postfix) with ESMTP id 62D8332C7BB\n\tfor <thorben.betten@open-xchange.com>; Wed,  2 Apr 2008 07:41:24 +0200 (CEST)\nDate: Wed, 2 Apr 2008 07:41:24 +0200 (CEST)\nFrom: \"Kraft, Manuel\" <manuel.kraft@open-xchange.com>\nTo: \"Betten, Thorben\" <thorben.betten@open-xchange.com>\nMessage-ID: <32481287.4641207114884399.JavaMail.open-xchange@oxee>\nSubject: imap server\nMIME-Version: 1.0\nContent-Type: multipart/mixed; \n\tboundary=\"----=_Part_298_27959028.1207114884271\"\nX-Priority: 3\nX-Mailer: Open-Xchange Mailer v6.5.0-6342\nX-Scanner: exiscan *1JgvaA-00032q-00*NAZPyw7vBYw* http://duncanthrax.net/exiscan/\nX-Spam-Checker-Version: SpamAssassin 2.64 (2004-01-11) on ox.netline-is.de\nX-Spam-Level: \nX-Spam-Status: No, hits=-4.9 required=5.0 tests=AWL,BAYES_00,UPPERCASE_25_50 \n\tautolearn=no version=2.64\n\n------=_Part_298_27959028.1207114884271\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: quoted-printable\n\nhttp://www.open-xchange.com/forum/showthread.php?t=3D1237\n\n\nweisst du was ich den noch fragen k=C3=B6nnten warum das bei dem son fehler=\n gibt obwohl er nen courier hat den wir ja eigentlich supporten?!=20\n\nmanuel\n------=_Part_298_27959028.1207114884271\nMIME-Version: 1.0\nContent-Type: text/x-vcard; charset=UTF-8; name=\"Kraft,Manuel.vcf\"\nContent-Transfer-Encoding: quoted-printable\nContent-Disposition: attachment; filename=\"Kraft,Manuel.vcf\"\n\nBEGIN:VCARD\nVERSION:2.1\nFN:Kraft, Manuel\nN:Kraft;Manuel;;Herr;\nPHOTO;JPEG;BASE64:\nPNGIHDRFFLupHYsdtIMEu0IDATxilumsPXIA47hS4EZNuBF1+YRu87oE//ss1c0Q1AB0JiXFRDq=\nGfUb4Lzll277gYmLRm9ZxTDi8h4AkxxY1lxWs//Hn3GUGJCUllDICB+1Ub2QONa9tcT73yMUWx1=\nBNy1M+r9QyI186dizplPJIufKOSMw11nnaccLwEOCEZEfZsAAAWck/ccD3RDc1VrTedY++aKA05=\n30AlkZeRv5gN+yo78tAqy5sAT+RLl/x0f3sSSSJULO7jUUW8849UXbEBAOKqxORXHcZdr59mVXf=\nlf02ZgAAZxtCH/bd3zKK+tjA8wAAwttn//kOAwFmFMzyPQDzgO74vNSwjVQPv0txOYKwfADqew0=\nXEWOkMhPXTkvSR6EqeUmI0tGlmt6s1EkykW2adf368vJyvm7CLYBz+O6Eltx6jtstv10F6N//gS=\nxpSCo9Aekej8Gv7D3QPAPQmTcKicyiRICNP1IicWxQeFlewulhOZuajr1INtr+SJXJNaxEfeifG=\neHE59IIKxzO27Jz96duyWyyJyreSSopwGBQFTu0IbicGk5lrSpH/neeUysF//vTu1LbCXUZO/GT=\n6Z1W00Ffdvh+9Zr5acgfoXw8g6osmc1PYsrr1kEpVryGlnqnUxoWClMM/X+VU6XKddCa29pSW9e=\nLcXpxCykiU9QZRFmltSmp4+Vksqzy5dU+9nrSRMNF2qesAQfRYrod7xW/4e/XGpvE4xZSqguU9C=\nA2EUO57MVxPetKqyTEzHF8TTX1Q9c81uWLisTj/yJY00JbxItsN+xliiQTsftB//DywyPgzxqqo=\niaMqjBNud8SSCHA+Zx0X999vRabll7x7WWG0qzaR2YgdLkpAioNbGxSTHzjCs/2ktJgz2UWig/O=\nfo/uOr4AuHf2SzIqK9H+q959JZ3/2s9p6mHl0nn7sfrFb6114BNyim7NYRQpb5If633AdTCrwLN=\nhLL8DwwSSFTrdsx0HtH33/vTIpj2SZ+Zkz8jMmwqZ1l1EWNY8cRqt7XPM8RB6ONG/mQj9ShCGYu=\nJrDqyIVxit4t2ZoLkNTlhBH2nXMBe8XyE9li1fHSOwlHs9JSXI3El8eSegLetw0MXuEEs1UIENA=\nAA=3D\n BDAY:19810907\nADR;TYPE=3Dwork:;;;;;;DE\nTEL;TYPE=3Dwork;TYPE=3Dvoice:+49 (2761) 8385-29\nTEL;TYPE=3Dwork;TYPE=3Dvoice:+49 162 2393954\nTEL;TYPE=3Dwork;TYPE=3Dfax:+49 (2761) 8385-30\nTEL;TYPE=3Dcell;TYPE=3Dvoice:+49 171 691 1712\nEMAIL:manuel.kraft@open-xchange.com\nROLE:Developer\nORG:Open-Xchange Inc.;Development\nREV:20080310T100717.953Z\nUID:22@oxee.netline.de\nEND:VCARD\n\n------=_Part_298_27959028.1207114884271--\n\n";
    private static final String RFC822_FORWARD = "Return-Path: <dream-team-bounces@open-xchange.com>\nReceived: from ox.netline-is.de ([unix socket])\n\tby ox (Cyrus v2.2.3) with LMTP; Mon, 31 Mar 2008 22:39:13 +0200\nX-Sieve: CMU Sieve 2.2\nReceived: by ox.netline-is.de (Postfix, from userid 65534)\n\tid 1D3EB39A15A; Mon, 31 Mar 2008 22:39:11 +0200 (CEST)\nReceived: from netline.de (comfire.netline.de [192.168.32.1])\n\tby ox.netline-is.de (Postfix) with ESMTP id 0272639A155\n\tfor <thorben@open-xchange.com>; Mon, 31 Mar 2008 22:39:00 +0200 (CEST)\nReceived: from [10.20.30.11] (helo=www.open-xchange.org ident=mail)\n\tby netline.de with esmtp (Exim)\n\tid 1JgQd5-0005ya-00\n\tfor thorben@open-xchange.com; Mon, 31 Mar 2008 22:29:19 +0200\nReceived: from mail.open-xchange.com ([10.20.30.22] helo=ox.open-xchange.com)\n\tby www.open-xchange.org with esmtp (Exim 3.36 #1 (Debian))\n\tid 1JgQlf-00070z-00\n\tfor <thorben@open-xchange.org>; Mon, 31 Mar 2008 22:38:11 +0200\nReceived: by ox.open-xchange.com (Postfix, from userid 76)\n\tid 6EE3F32C677; Mon, 31 Mar 2008 22:38:08 +0200 (CEST)\nReceived: from ox.open-xchange.com ([unix socket])\n\t by ox.open-xchange.com (Cyrus v2.2.12-Invoca-RPM-2.2.12-8.1.RHEL4) with LMTPA;\n\t Mon, 31 Mar 2008 22:38:07 +0200\nX-Sieve: CMU Sieve 2.2\nReceived: by ox.open-xchange.com (Postfix, from userid 99)\n\tid 46C8F32C6F2; Mon, 31 Mar 2008 22:38:00 +0200 (CEST)\nReceived: from ox.open-xchange.com (localhost.localdomain [127.0.0.1])\n\tby ox.open-xchange.com (Postfix) with ESMTP id 3CD7732C620;\n\tMon, 31 Mar 2008 22:37:58 +0200 (CEST)\nX-Original-To: dream-team@ox.open-xchange.com\nDelivered-To: dream-team@ox.open-xchange.com\nReceived: by ox.open-xchange.com (Postfix, from userid 99)\n\tid 6258D32C677; Mon, 31 Mar 2008 22:37:56 +0200 (CEST)\nReceived: from edna (nrbg-4dbf9375.pool.einsundeins.de [77.191.147.117])\n\tby ox.open-xchange.com (Postfix) with ESMTP id 82C6532C50F\n\tfor <dream-team@open-xchange.com>;\n\tMon, 31 Mar 2008 22:37:54 +0200 (CEST)\nDate: Mon, 31 Mar 2008 22:39:25 +0200\nTo: \"dream-team@open-xchange.com\" <dream-team@open-xchange.com>\nFrom: =?utf-8?Q?Ren=C3=A9_Stach?= <rene.stach@open-xchange.com>\nOrganization: http://open-xchange.com/\nContent-Type: text/plain; format=flowed; delsp=yes; charset=utf-8\nMIME-Version: 1.0\nMessage-ID: <op.t8webzmnraenw4@edna>\nUser-Agent: Opera Mail/9.26 (Linux)\nSubject: [dream-team] Good bye und macht's gut\nX-BeenThere: dream-team@open-xchange.com\nX-Mailman-Version: 2.1.5\nPrecedence: list\nList-Id: Mailinglist for whole the dream-team of Open-Xchange - all members of\n\tOpen-Change <dream-team.open-xchange.com>\nList-Unsubscribe: <https://ox.open-xchange.com/mailman/listinfo/dream-team>,\n\t<mailto:dream-team-request@open-xchange.com?subject=unsubscribe>\nList-Archive: <https://ox.open-xchange.com/pipermail/dream-team>\nList-Post: <mailto:dream-team@open-xchange.com>\nList-Help: <mailto:dream-team-request@open-xchange.com?subject=help>\nList-Subscribe: <https://ox.open-xchange.com/mailman/listinfo/dream-team>,\n\t<mailto:dream-team-request@open-xchange.com?subject=subscribe>\nSender: dream-team-bounces@open-xchange.com\nErrors-To: dream-team-bounces@open-xchange.com\nContent-Transfer-Encoding: quoted-printable\nX-Scanner: exiscan *1JgQd5-0005ya-00*nthOXtQxc7Q* http://duncanthrax.net/exiscan/\nX-Spam-Checker-Version: SpamAssassin 2.64 (2004-01-11) on ox.netline-is.de\nX-Spam-Level: \nX-Spam-Status: No, hits=-4.5 required=5.0 tests=AWL,BAYES_00,\n\tTO_ADDRESS_EQ_REAL autolearn=no version=2.64\n\nHallo Dream-Team,\n\nauch ich m=C3=B6chte mich =C3=BCber diese Mailingliste von euch allen ver=\nabschieden. =20\nEs war eine tolle Zeit, die mir viel Spa=C3=9F gemacht hat. Wir haben zus=\nammen =20\ntolle Produkte auf die Beine gestellt, die mittlerweile vom Kleinkindalte=\nr =20\nzum Jugendlichen herangewachsen sind.\n\nIch w=C3=BCnsche euch allen das Geschick und Gl=C3=BCck, die beiden junge=\nn Produkte =20\nins Erwachsenenalter zu =C3=BCberf=C3=BChren, denn das ist die Zeit, in d=\ner sie Geld =20\nnach Hause bringen und somit helfen, das Unternehmen erfolgreich zu mache=\nn.\n\nWohin meine Reise gehen wird, wei=C3=9F ich momentan noch nicht. Es gibt =\n=20\nmehrere interessante Angebote, aber noch ist nichts entschieden. Da die =20\nmeisten mit mir =C3=BCber Xing verbunden sind, werdet ihr sicherlich =20\nmitbekommen was ich in Zukunft machen werde.\n\nWie Rafael so sch=C3=B6n sagte: \"Man sieht sich immer zweimal im Leben.\" =\nW=C3=BCrde =20\nmich sehr freuen.\n\nTsch=C3=BCss, servus und good bye!\n--=20\nRen=C3=A9 Stach\nAddress: Open-Xchange GmbH, Maxfeldstr. 9, 90409 N=C3=BCrnberg\nPhone: +49 (0)911 180 1413     Fax: +49 (0)911 180 1419\nWeb: http://open-xchange.com/\n";

    public MailForwardTest() {
    }

    public MailForwardTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailForward() {
        try {
            MailMessage sourceMail = MimeMessageConverter.convertMessage((byte[])RFC822_SRC.getBytes(Charsets.US_ASCII));
            ContextImpl ctx = new ContextImpl(this.getCid());
            SessionObject session = this.getSession();
            MailAccess mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            try {
                MailMessage forwardMail = mailAccess.getLogicTools().getFowardMessage(new MailMessage[]{sourceMail}, false);
                UserSettingMail usm = UserSettingMailStorage.getInstance().getUserSettingMail(this.getUser(), ctx.getContextId());
                MailForwardTest.assertTrue((String)"Header 'From' does not carry expected value", (boolean)forwardMail.getFrom()[0].equals((Object)new InternetAddress(usm.getSendAddr(), true)));
                User user = UserStorage.getStorageUser((int)session.getUserId(), (Context)ctx);
                Locale locale = user.getLocale();
                TimeZone tz = TimeZone.getTimeZone(user.getTimeZone());
                StringHelper stringHelper = StringHelper.valueOf((Locale)locale);
                String subjectPrefix = "Fwd: ";
                String subject = new StringBuilder(32).append("Fwd: ").append(sourceMail.getSubject()).toString();
                MailForwardTest.assertTrue((String)"Header 'Subject' does not carry expected value", (boolean)subject.equals(forwardMail.getSubject()));
                MailForwardTest.assertTrue((String)"Header 'Content-Type' does not carry expected value", (boolean)forwardMail.getContentType().isMimeType("multipart/mixed"));
                int count = forwardMail.getEnclosedCount();
                MailForwardTest.assertTrue((String)"Unexpected number of enclosed parts", (count == 2 ? 1 : 0) != 0);
                for (int i = 0; i < count; ++i) {
                    MailPart part = forwardMail.getEnclosedMailPart(i);
                    if (i == 0) {
                        MailForwardTest.assertTrue((String)"Unexpected content type in body", (boolean)part.getContentType().isMimeType("text/*"));
                        Object content = part.getContent();
                        MailForwardTest.assertTrue((String)"Missing content", (content != null ? 1 : 0) != 0);
                        if (!UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), (Context)ctx).isForwardAsAttachment()) {
                            String forwardPrefix = stringHelper.getString("---------- Original Message ----------\nFrom: #FROM#\nTo: #TO##CC_LINE#\nDate: #DATE# at #TIME#\nSubject: #SUBJECT#");
                            InternetAddress[] from = sourceMail.getFrom();
                            forwardPrefix = forwardPrefix.replaceFirst("#FROM#", from == null || from.length == 0 ? "" : from[0].toUnicodeString());
                            InternetAddress[] to = sourceMail.getTo();
                            forwardPrefix = forwardPrefix.replaceFirst("#TO#", to == null || to.length == 0 ? "" : MailForwardTest.addrs2String(to));
                            InternetAddress[] cc = sourceMail.getCc();
                            forwardPrefix = forwardPrefix.replaceFirst("#CC_LINE#", cc == null || cc.length == 0 ? "" : new StringBuilder(64).append("\nCc: ").append(MailForwardTest.addrs2String(cc)).toString());
                            Date date = sourceMail.getSentDate();
                            if (date == null) {
                                forwardPrefix = forwardPrefix.replaceFirst("#DATE#", "");
                                forwardPrefix = forwardPrefix.replaceFirst("#TIME#", "");
                            } else {
                                DateFormat dateFormat = DateFormat.getDateInstance(1, locale);
                                dateFormat.setTimeZone(tz);
                                forwardPrefix = forwardPrefix.replaceFirst("#DATE#", dateFormat.format(date));
                                dateFormat = DateFormat.getTimeInstance(3, locale);
                                dateFormat.setTimeZone(tz);
                                forwardPrefix = forwardPrefix.replaceFirst("#TIME#", dateFormat.format(date));
                            }
                            forwardPrefix = forwardPrefix.replaceFirst("#SUBJECT#", sourceMail.getSubject());
                            String text = content.toString().replaceAll("(\r?\n)> ", "$1");
                            MailForwardTest.assertTrue((String)("Missing forward prefix:\n" + forwardPrefix), (text.indexOf(forwardPrefix) > 0 ? 1 : 0) != 0);
                            continue;
                        }
                        MailForwardTest.assertTrue((String)"Unexpected forward prefix", (content.toString().trim().length() == 0 ? 1 : 0) != 0);
                        continue;
                    }
                    if (!UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), (Context)ctx).isForwardAsAttachment()) {
                        MailForwardTest.assertTrue((String)"Unexpected content type in file attachment", (boolean)part.getContentType().isMimeType("text/*card"));
                        continue;
                    }
                    MailForwardTest.assertTrue((String)"Unexpected content type in file attachment", (boolean)part.getContentType().isMimeType("message/rfc822"));
                }
            }
            finally {
                mailAccess.close(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailForwardTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailForwardAnother() {
        try {
            MailMessage sourceMail = MimeMessageConverter.convertMessage((byte[])RFC822_FORWARD.getBytes(Charsets.US_ASCII));
            ContextImpl ctx = new ContextImpl(this.getCid());
            SessionObject session = this.getSession();
            MailAccess mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            try {
                boolean isInlineForward;
                MailMessage forwardMail = mailAccess.getLogicTools().getFowardMessage(new MailMessage[]{sourceMail}, false);
                UserSettingMail usm = UserSettingMailStorage.getInstance().getUserSettingMail(this.getUser(), ctx.getContextId());
                MailForwardTest.assertTrue((String)"Header 'From' does not carry expected value", (boolean)forwardMail.getFrom()[0].equals((Object)new InternetAddress(usm.getSendAddr(), true)));
                User user = UserStorage.getStorageUser((int)session.getUserId(), (Context)ctx);
                Locale locale = user.getLocale();
                TimeZone tz = TimeZone.getTimeZone(user.getTimeZone());
                StringHelper stringHelper = StringHelper.valueOf((Locale)locale);
                String subjectPrefix = "Fwd: ";
                String subject = new StringBuilder(32).append("Fwd: ").append(sourceMail.getSubject()).toString();
                MailForwardTest.assertTrue((String)"Header 'Subject' does not carry expected value", (boolean)subject.equals(forwardMail.getSubject()));
                boolean bl = isInlineForward = !UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), (Context)ctx).isForwardAsAttachment();
                if (isInlineForward) {
                    MailForwardTest.assertTrue((String)"Header 'Content-Type' does not carry expected value", (boolean)forwardMail.getContentType().isMimeType("text/plain"));
                } else {
                    MailForwardTest.assertTrue((String)"Header 'Content-Type' does not carry expected value", (boolean)forwardMail.getContentType().isMimeType("multipart/*"));
                }
                int count = forwardMail.getEnclosedCount();
                if (isInlineForward) {
                    MailForwardTest.assertTrue((String)("Unexpected number of enclosed parts: " + count), (count == -1 ? 1 : 0) != 0);
                } else {
                    MailForwardTest.assertTrue((String)("Unexpected number of enclosed parts: " + count), (count == 2 ? 1 : 0) != 0);
                }
                Object content = forwardMail.getContent();
                if (isInlineForward) {
                    MailForwardTest.assertTrue((String)"Missing content", (content != null ? 1 : 0) != 0);
                }
                if (isInlineForward) {
                    String forwardPrefix = stringHelper.getString("---------- Original Message ----------\nFrom: #FROM#\nTo: #TO##CC_LINE#\nDate: #DATE# at #TIME#\nSubject: #SUBJECT#");
                    InternetAddress[] from = sourceMail.getFrom();
                    forwardPrefix = forwardPrefix.replaceFirst("#FROM#", from == null || from.length == 0 ? "" : from[0].toUnicodeString());
                    InternetAddress[] to = sourceMail.getTo();
                    forwardPrefix = forwardPrefix.replaceFirst("#TO#", to == null || to.length == 0 ? "" : MailForwardTest.addrs2String(to));
                    InternetAddress[] cc = sourceMail.getCc();
                    forwardPrefix = forwardPrefix.replaceFirst("#CC_LINE#", cc == null || cc.length == 0 ? "" : new StringBuilder(64).append("\nCc: ").append(MailForwardTest.addrs2String(cc)).toString());
                    Date date = sourceMail.getSentDate();
                    if (date == null) {
                        forwardPrefix = forwardPrefix.replaceFirst("#DATE#", "");
                        forwardPrefix = forwardPrefix.replaceFirst("#TIME#", "");
                    } else {
                        DateFormat dateFormat = DateFormat.getDateInstance(1, locale);
                        dateFormat.setTimeZone(tz);
                        forwardPrefix = forwardPrefix.replaceFirst("#DATE#", dateFormat.format(date));
                        dateFormat = DateFormat.getTimeInstance(3, locale);
                        dateFormat.setTimeZone(tz);
                        forwardPrefix = forwardPrefix.replaceFirst("#TIME#", dateFormat.format(date));
                    }
                    forwardPrefix = forwardPrefix.replaceFirst("#SUBJECT#", sourceMail.getSubject());
                    String text = content.toString().replaceAll("(\r?\n)> ", "$1");
                    MailForwardTest.assertTrue((String)("Missing forward prefix:\n" + forwardPrefix), (text.indexOf(forwardPrefix) > 0 ? 1 : 0) != 0);
                }
            }
            finally {
                mailAccess.close(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailForwardTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForwardMultiple() {
        try {
            MailAccess mailAccess;
            block9: {
                new ContextImpl(this.getCid());
                SessionObject session = this.getSession();
                mailAccess = MailAccess.getInstance((Session)session);
                mailAccess.connect();
                String[] uids = null;
                try {
                    MailMessage[] mails = new MailMessage[]{MimeMessageConverter.convertMessage((byte[])RFC822_FORWARD.getBytes(Charsets.US_ASCII)), MimeMessageConverter.convertMessage((byte[])RFC822_SRC.getBytes(Charsets.US_ASCII))};
                    uids = mailAccess.getMessageStorage().appendMessages("INBOX", mails);
                    MailMessage[] fetchedMails = mailAccess.getMessageStorage().getMessages("INBOX", uids, new MailField[]{MailField.FULL});
                    MailMessage forwardMail = mailAccess.getLogicTools().getFowardMessage(fetchedMails, false);
                    MailForwardTest.assertTrue((String)("Unexpected content type: " + forwardMail.getContentType().toString()), (boolean)forwardMail.getContentType().isMimeType("multipart/mixed"));
                    int count = forwardMail.getEnclosedCount();
                    MailForwardTest.assertTrue((String)("Unexpected number of attachments: " + count), (count == 3 ? 1 : 0) != 0);
                    boolean partOfFirstMailFound = false;
                    boolean partOfSecondMailFound = false;
                    for (int i = 0; i < count; ++i) {
                        MailPart part = forwardMail.getEnclosedMailPart(i);
                        if (i == 0) {
                            MailForwardTest.assertTrue((String)("Unexpected enclosed part's content type: " + part.getContentType()), (boolean)part.getContentType().isMimeType("text/*"));
                        } else {
                            MailForwardTest.assertTrue((String)("Unexpected enclosed part's content type: " + part.getContentType()), (boolean)part.getContentType().isMimeType("message/rfc822"));
                        }
                        if (i != 1 && i != 2) continue;
                        MailMessage myMail = (MailMessage)part.getContent();
                        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
                        myMail.writeTo((OutputStream)out);
                        String mailtext = new String(out.toByteArray(), Charsets.US_ASCII);
                        if (mailtext.contains("gibt obwohl er nen courier hat")) {
                            partOfFirstMailFound = true;
                        }
                        if (!mailtext.contains("nach Hause bringen und somit helfen")) continue;
                        partOfSecondMailFound = true;
                    }
                    MailForwardTest.assertTrue((String)"Part of first mail missing", (boolean)partOfFirstMailFound);
                    MailForwardTest.assertTrue((String)"Part of second mail missing", (boolean)partOfSecondMailFound);
                    if (uids == null) break block9;
                }
                catch (Throwable throwable) {
                    if (uids != null) {
                        mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
                    }
                    mailAccess.close(false);
                    throw throwable;
                }
                mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
            }
            mailAccess.close(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            MailForwardTest.fail((String)e.getMessage());
        }
    }

    private static String addrs2String(InternetAddress[] addrs) {
        StringBuilder tmp = new StringBuilder(addrs.length * 16);
        tmp.append(addrs[0].toUnicodeString());
        for (int i = 1; i < addrs.length; ++i) {
            tmp.append(", ").append(addrs[i].toUnicodeString());
        }
        return tmp.toString();
    }
}

