/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.vcard;

import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.vcard.AbstractVCardUnitTest;
import com.openexchange.tools.versit.converter.ConverterException;
import java.io.IOException;
import java.util.List;

public class MissingAddressesAfterImportTest
extends AbstractVCardUnitTest {
    public String vcard = "BEGIN:VCARD\nVERSION:3.0\nPRODID:OPEN-XCHANGE\nFN:Prinz\\, Tobias\nN:Prinz;Tobias;;;\nNICKNAME:Tierlieb\nBDAY:19810501\nADR;TYPE=work:;;Broadway 3131 / 5th Ave;T\u00fcbingen;Baden-W\u00fcrttemberg;57621;Germany\nADR;TYPE=home:;;Testroad 4711;Port de la V\u00e9rde;Skol-upon-sea;37542;France\nORG:- deactivated -\nREV:20061204T160750.018Z\nUID:80@ox6.netline.de\nEND:VCARD\n";

    public void testBug14350() throws ConverterException, IOException {
        this.checkAdresses(this.performTest("Test with mime type text/x-vcard", this.vcard, "text/x-vcard"));
    }

    public void testBug14350_2() throws ConverterException, IOException {
        this.checkAdresses(this.performTest("Test with mime type text/vcard", this.vcard, "text/vcard"));
    }

    private void checkAdresses(List<Contact> list) {
        MissingAddressesAfterImportTest.assertEquals((String)"Should have parsed one contact", (int)1, (int)list.size());
        Contact actual = list.get(0);
        MissingAddressesAfterImportTest.assertEquals((String)"Broadway 3131 / 5th Ave", (String)actual.getStreetBusiness());
        MissingAddressesAfterImportTest.assertEquals((String)"T\u00fcbingen", (String)actual.getCityBusiness());
        MissingAddressesAfterImportTest.assertEquals((String)"Baden-W\u00fcrttemberg", (String)actual.getStateBusiness());
        MissingAddressesAfterImportTest.assertEquals((String)"57621", (String)actual.getPostalCodeBusiness());
        MissingAddressesAfterImportTest.assertEquals((String)"Germany", (String)actual.getCountryBusiness());
        MissingAddressesAfterImportTest.assertEquals((String)"Testroad 4711", (String)actual.getStreetHome());
        MissingAddressesAfterImportTest.assertEquals((String)"Port de la V\u00e9rde", (String)actual.getCityHome());
        MissingAddressesAfterImportTest.assertEquals((String)"Skol-upon-sea", (String)actual.getStateHome());
        MissingAddressesAfterImportTest.assertEquals((String)"37542", (String)actual.getPostalCodeHome());
        MissingAddressesAfterImportTest.assertEquals((String)"France", (String)actual.getCountryHome());
    }
}

