/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.methods.CustomXmlRequestEntity;
import com.openexchange.dav.caldav.properties.SupportedCalendarComponentSetProperty;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.util.Date;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.client.methods.PropPatchMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.w3c.dom.Document;

public class Bug36943Test
extends CalDAVTest {
    public Bug36943Test(String name) {
        super(name);
    }

    public void testVEventWithAstralSymbols() throws Exception {
        String uid = Bug36943Test.randomUID();
        Date start = TimeTools.D("next friday at 09:00");
        Date end = TimeTools.D("next friday at 10:00");
        String summary = "Pile of \ud83d\udca9 poo";
        String iCal = Bug36943Test.generateICal(start, end, uid, summary, "test");
        Bug36943Test.assertEquals((String)"response code wrong", (int)201, (int)this.putICal(uid, iCal));
        String expectedTitle = summary.replaceAll("\ud83d\udca9", "");
        Appointment appointment = this.getAppointment(uid);
        Bug36943Test.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Bug36943Test.assertEquals((String)"Title wrong", (String)expectedTitle, (String)appointment.getTitle());
        ICalResource iCalResource = this.get(uid, null);
        Bug36943Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug36943Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug36943Test.assertNotNull((String)"No SUMMARY in iCal found", (Object)iCalResource.getVEvent().getSummary());
        Bug36943Test.assertEquals((String)"SUMMARY wrong", (String)expectedTitle, (String)iCalResource.getVEvent().getSummary());
    }

    public void testVTodoWithAstralSymbols() throws Exception {
        String folderID = String.valueOf(this.getClient().getValues().getPrivateTaskFolder());
        String uid = Bug36943Test.randomUID();
        Date start = TimeTools.D("next friday at 09:00");
        Date end = TimeTools.D("next friday at 10:00");
        String summary = "Pile of \ud83d\udca9 poo";
        String iCal = Bug36943Test.generateVTodo(start, end, uid, summary, "test");
        Bug36943Test.assertEquals((String)"response code wrong", (int)201, (int)this.putICal(folderID, uid, iCal));
        String expectedTitle = summary.replaceAll("\ud83d\udca9", "");
        Task task = this.getTask(folderID, uid);
        Bug36943Test.assertNotNull((String)"task not found on server", (Object)task);
        Bug36943Test.assertEquals((String)"Title wrong", (String)expectedTitle, (String)task.getTitle());
        ICalResource iCalResource = this.get(folderID, uid, null);
        Bug36943Test.assertNotNull((String)"No VTODO in iCal found", (Object)iCalResource.getVTodo());
        Bug36943Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVTodo().getUID());
        Bug36943Test.assertNotNull((String)"No SUMMARY in iCal found", (Object)iCalResource.getVTodo().getSummary());
        Bug36943Test.assertEquals((String)"SUMMARY wrong", (String)expectedTitle, (String)iCalResource.getVTodo().getSummary());
    }

    public void testCreateCollectionWithAstralSymbols() throws Exception {
        String uid = Bug36943Test.randomUID();
        String name = "Pile of \ud83d\udca9 poo " + Bug36943Test.randomUID();
        DavPropertySet setProperties = new DavPropertySet();
        setProperties.add((DavProperty)new SupportedCalendarComponentSetProperty(SupportedCalendarComponentSetProperty.Comp.VEVENT));
        setProperties.add((DavProperty)new DefaultDavProperty(PropertyNames.DISPLAYNAME, (Object)name));
        this.mkCalendar(uid, setProperties);
        String expectedName = name.replaceAll("\ud83d\udca9", "");
        FolderObject folder = super.getCalendarFolder(expectedName);
        Bug36943Test.assertNotNull((String)"folder not found on server", (Object)folder);
        this.rememberForCleanUp(folder);
        Bug36943Test.assertEquals((String)"folder name wrong", (String)expectedName, (String)folder.getFolderName());
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.DISPLAYNAME);
        props.add(PropertyNames.RESOURCE_ID);
        props.add(PropertyNames.RESOURCETYPE);
        PropFindMethod propFind = new PropFindMethod(super.getWebDAVClient().getBaseURI() + "/caldav/", 0, props, 1);
        MultiStatusResponse[] responses = super.getWebDAVClient().doPropFind(propFind);
        Bug36943Test.assertNotNull((String)"got no response", (Object)responses);
        Bug36943Test.assertTrue((String)"got no response", (0 < responses.length ? 1 : 0) != 0);
        MultiStatusResponse folderResponse = null;
        for (MultiStatusResponse response : responses) {
            if (!response.getPropertyNames(200).contains(PropertyNames.DISPLAYNAME) || !expectedName.equals(super.extractTextContent(PropertyNames.DISPLAYNAME, response))) continue;
            folderResponse = response;
            break;
        }
        Bug36943Test.assertNotNull((String)"no response for new folder", folderResponse);
    }

    public void testRenameCollectionWithAstralSymbols() throws Exception {
        String originalName = Bug36943Test.randomUID();
        FolderObject folder = this.createFolder(originalName);
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.DISPLAYNAME);
        props.add(PropertyNames.RESOURCE_ID);
        props.add(PropertyNames.RESOURCETYPE);
        PropFindMethod propFind = new PropFindMethod(super.getWebDAVClient().getBaseURI() + "/caldav/", 0, props, 1);
        MultiStatusResponse[] responses = super.getWebDAVClient().doPropFind(propFind);
        Bug36943Test.assertNotNull((String)"got no response", (Object)responses);
        Bug36943Test.assertTrue((String)"got no response", (0 < responses.length ? 1 : 0) != 0);
        MultiStatusResponse folderResponse = null;
        for (MultiStatusResponse response : responses) {
            if (!response.getPropertyNames(200).contains(PropertyNames.DISPLAYNAME) || !originalName.equals(super.extractTextContent(PropertyNames.DISPLAYNAME, response))) continue;
            folderResponse = response;
            break;
        }
        Bug36943Test.assertNotNull((String)"no response for new folder", folderResponse);
        String newName = "Pile of \ud83d\udca9 poo " + Bug36943Test.randomUID();
        DavPropertySet setProperties = new DavPropertySet();
        setProperties.add((DavProperty)new DefaultDavProperty(PropertyNames.DISPLAYNAME, (Object)newName));
        PropPatchMethod propPatch = new PropPatchMethod(this.getWebDAVClient().getBaseURI() + folderResponse.getHref(), setProperties, new DavPropertyNameSet()){

            public void setRequestBody(Document requestBody) throws IOException {
                this.setRequestEntity(new CustomXmlRequestEntity(requestBody, "UTF-16"));
            }
        };
        responses = super.getWebDAVClient().doPropPatch(propPatch, 207);
        Bug36943Test.assertNotNull((String)"got no response", (Object)responses);
        Bug36943Test.assertTrue((String)"got no response", (0 < responses.length ? 1 : 0) != 0);
        String expectedName = newName.replaceAll("\ud83d\udca9", "");
        folder = this.getCalendarFolder(expectedName);
        Bug36943Test.assertNotNull((String)"folder not found on server", (Object)folder);
        this.rememberForCleanUp(folder);
        Bug36943Test.assertEquals((String)"folder name wrong", (String)expectedName, (String)folder.getFolderName());
        props = new DavPropertyNameSet();
        props.add(PropertyNames.DISPLAYNAME);
        props.add(PropertyNames.RESOURCE_ID);
        props.add(PropertyNames.RESOURCETYPE);
        propFind = new PropFindMethod(this.getWebDAVClient().getBaseURI() + "/caldav/", 0, props, 1);
        responses = this.getWebDAVClient().doPropFind(propFind);
        Bug36943Test.assertNotNull((String)"got no response", (Object)responses);
        Bug36943Test.assertTrue((String)"got no response", (0 < responses.length ? 1 : 0) != 0);
        folderResponse = null;
        for (MultiStatusResponse response : responses) {
            if (!response.getPropertyNames(200).contains(PropertyNames.DISPLAYNAME) || !expectedName.equals(super.extractTextContent(PropertyNames.DISPLAYNAME, response))) continue;
            folderResponse = response;
            break;
        }
        Bug36943Test.assertNotNull((String)"no response for renamed folder", (Object)folderResponse);
    }
}

