/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.contact.action.GetContactForUserRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.task.ManagedTaskTest;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.tasks.Task;
import java.util.TimeZone;

public class TaskExternalUsersBecomeInternalUsers
extends ManagedTaskTest {
    public TaskExternalUsersBecomeInternalUsers(String name) {
        super(name);
    }

    public void testExternalParticipantBecomesUserParticipantIfAddressMatches() throws Exception {
        Participant[] participants;
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int user2id = client2.getValues().getUserId();
        GetResponse response = client2.execute(new GetContactForUserRequest(user2id, true, TimeZone.getDefault()));
        String user2email = response.getContact().getEmail1();
        Task task = this.generateTask("Task to test the transformation of external participants into internal ones");
        task.addParticipant((Participant)new ExternalUserParticipant(user2email));
        task.addParticipant((Participant)new UserParticipant(user2id));
        this.manager.insertTaskOnServer(task);
        Task actual = this.manager.getTaskFromServer(task);
        boolean foundAsExternal = false;
        boolean foundAsInternal = false;
        for (Participant participant : participants = actual.getParticipants()) {
            if (participant.getType() == 5 && participant.getEmailAddress().equals(user2email)) {
                foundAsExternal = true;
            }
            if (participant.getType() != 1 || participant.getIdentifier() != user2id) continue;
            foundAsInternal = true;
        }
        TaskExternalUsersBecomeInternalUsers.assertFalse((String)"Should not find user listed as external participant", (boolean)foundAsExternal);
        TaskExternalUsersBecomeInternalUsers.assertTrue((String)"Should find user listed as internal participant", (boolean)foundAsInternal);
    }

    public void testExternalParticipantIsRemovedIfAddressMatchesUserParticipant() throws Exception {
        Participant[] participants;
        int userId = this.getClient().getValues().getUserId();
        GetResponse response = this.getClient().execute(new GetContactForUserRequest(userId, true, TimeZone.getDefault()));
        String user1email = response.getContact().getEmail1();
        Task task = this.generateTask("Another task to test the transformation of external participants into internal ones");
        task.addParticipant((Participant)new ExternalUserParticipant(user1email));
        this.manager.insertTaskOnServer(task);
        Task actual = this.manager.getTaskFromServer(task);
        boolean foundAsExternal = false;
        int foundAsInternal = 0;
        for (Participant participant : participants = actual.getParticipants()) {
            if (participant.getType() == 5 && participant.getEmailAddress().equals(user1email)) {
                foundAsExternal = true;
            }
            if (participant.getType() != 1 || participant.getIdentifier() != userId) continue;
            ++foundAsInternal;
        }
        TaskExternalUsersBecomeInternalUsers.assertFalse((String)"Should not find creator listed as external participant", (boolean)foundAsExternal);
        TaskExternalUsersBecomeInternalUsers.assertEquals((String)"Should find creator listed as internal participant once and only once", (int)1, (int)foundAsInternal);
    }

    public void testExternalParticipantBecomesUserParticipantIfAddressMatchesAfterUpdateToo() throws Exception {
        Participant[] participants;
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int user2id = client2.getValues().getUserId();
        GetResponse response = client2.execute(new GetContactForUserRequest(user2id, true, TimeZone.getDefault()));
        String user2email = response.getContact().getEmail1();
        Task task = this.generateTask("Another task to test the transformation of external participants into internal ones");
        Task result = this.manager.insertTaskOnServer(task);
        Task update = new Task();
        update.setLastModified(result.getLastModified());
        update.setObjectID(result.getObjectID());
        update.setParentFolderID(result.getParentFolderID());
        update.addParticipant((Participant)new ExternalUserParticipant(user2email));
        update.addParticipant((Participant)new UserParticipant(user2id));
        this.manager.updateTaskOnServer(update);
        Task actual = this.manager.getTaskFromServer(task);
        boolean foundAsExternal = false;
        boolean foundAsInternal = false;
        for (Participant participant : participants = actual.getParticipants()) {
            if (participant.getType() == 5 && participant.getEmailAddress().equals(user2email)) {
                foundAsExternal = true;
            }
            if (participant.getType() != 1 || participant.getIdentifier() != user2id) continue;
            foundAsInternal = true;
        }
        TaskExternalUsersBecomeInternalUsers.assertFalse((String)"Should not find user listed as external participant", (boolean)foundAsExternal);
        TaskExternalUsersBecomeInternalUsers.assertTrue((String)"Should find user listed as internal participant", (boolean)foundAsInternal);
    }
}

