/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.subscribe.test;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.subscribe.actions.AbstractSubscriptionResponse;
import com.openexchange.ajax.subscribe.actions.AllSubscriptionsRequest;
import com.openexchange.ajax.subscribe.actions.AllSubscriptionsResponse;
import com.openexchange.ajax.subscribe.actions.DeleteSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.DeleteSubscriptionResponse;
import com.openexchange.ajax.subscribe.actions.GetSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.GetSubscriptionResponse;
import com.openexchange.ajax.subscribe.actions.ListSubscriptionsRequest;
import com.openexchange.ajax.subscribe.actions.ListSubscriptionsResponse;
import com.openexchange.ajax.subscribe.actions.NewSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.NewSubscriptionResponse;
import com.openexchange.ajax.subscribe.actions.RefreshSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.RefreshSubscriptionResponse;
import com.openexchange.ajax.subscribe.actions.UpdateSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.UpdateSubscriptionResponse;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.exception.OXException;
import com.openexchange.java.Autoboxing;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class SubscriptionTestManager {
    private AbstractSubscriptionResponse lastResponse;
    private final Set<Integer> createdItems = new HashSet<Integer>();
    private boolean failOnError;
    private AJAXClient client;
    private DynamicFormDescription formDescription;
    private SubscriptionSourceDiscoveryService subscriptionSourceRecoveryService;

    public AbstractSubscriptionResponse getLastResponse() {
        return this.lastResponse;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public void setClient(AJAXClient client) {
        this.client = client;
    }

    public AJAXClient getClient() {
        return this.client;
    }

    public void setFormDescription(DynamicFormDescription formDescription) {
        this.formDescription = formDescription;
    }

    public DynamicFormDescription getFormDescription() {
        return this.formDescription;
    }

    public void setSubscriptionSourceDiscoveryService(SubscriptionSourceDiscoveryService service) {
        this.subscriptionSourceRecoveryService = service;
    }

    public SubscriptionSourceDiscoveryService getSubscriptionSourceRecoveryService() {
        return this.subscriptionSourceRecoveryService;
    }

    public SubscriptionTestManager() {
    }

    public SubscriptionTestManager(AJAXClient client) {
        this();
        this.setClient(client);
    }

    public Subscription newAction(Subscription sub) throws OXException, IOException, SAXException, JSONException {
        NewSubscriptionRequest newReq = new NewSubscriptionRequest(sub, this.getFormDescription());
        newReq.setFailOnError(this.getFailOnError());
        NewSubscriptionResponse newResp = this.getClient().execute(newReq);
        this.lastResponse = newResp;
        this.createdItems.add(Autoboxing.I((int)newResp.getId()));
        sub.setId(newResp.getId());
        return sub;
    }

    public Subscription getAction(int id) throws OXException, IOException, SAXException, JSONException {
        GetSubscriptionRequest getReq = new GetSubscriptionRequest(id);
        getReq.setFailOnError(this.getFailOnError());
        GetSubscriptionResponse getResp = this.getClient().execute(getReq);
        this.lastResponse = getResp;
        return getResp.getSubscription(this.getSubscriptionSourceRecoveryService());
    }

    public void deleteAction(Subscription sub) throws OXException, IOException, SAXException, JSONException {
        int id = sub.getId();
        DeleteSubscriptionRequest delReq = new DeleteSubscriptionRequest(id);
        delReq.setFailOnError(this.getFailOnError());
        DeleteSubscriptionResponse delResp = this.getClient().execute(delReq);
        this.createdItems.remove(Autoboxing.I((int)id));
        this.lastResponse = delResp;
    }

    public void deleteAction(Collection<Integer> ids) throws OXException, IOException, SAXException, JSONException {
        DeleteSubscriptionRequest delReq = new DeleteSubscriptionRequest(ids);
        delReq.setFailOnError(this.getFailOnError());
        DeleteSubscriptionResponse delResp = this.getClient().execute(delReq);
        this.createdItems.removeAll(ids);
        this.lastResponse = delResp;
    }

    public JSONArray listAction(List<Integer> ids, List<String> columns) throws OXException, IOException, SAXException, JSONException {
        ListSubscriptionsRequest listReq = new ListSubscriptionsRequest(ids, columns);
        listReq.setFailOnError(this.getFailOnError());
        ListSubscriptionsResponse listResp = this.getClient().execute(listReq);
        this.lastResponse = listResp;
        return listResp.getList();
    }

    public JSONArray listAction(List<Integer> ids, List<String> columns, Map<String, List<String>> dynamicColumns) throws OXException, IOException, SAXException, JSONException {
        ListSubscriptionsRequest listReq = new ListSubscriptionsRequest(ids, columns, dynamicColumns);
        listReq.setFailOnError(this.getFailOnError());
        ListSubscriptionsResponse listResp = this.getClient().execute(listReq);
        this.lastResponse = listResp;
        return listResp.getList();
    }

    public JSONArray allAction(String folder, List<String> columns) throws OXException, IOException, SAXException, JSONException {
        AllSubscriptionsRequest allReq = null;
        allReq = folder == null ? new AllSubscriptionsRequest(columns) : new AllSubscriptionsRequest(folder, columns);
        allReq.setFailOnError(this.getFailOnError());
        AllSubscriptionsResponse allResp = this.getClient().execute(allReq);
        this.lastResponse = allResp;
        return allResp.getAll();
    }

    public JSONArray allAction(int folder, List<String> columns) throws OXException, IOException, SAXException, JSONException {
        return this.allAction(String.valueOf(folder), columns);
    }

    public JSONArray allAction(List<String> columns) throws OXException, IOException, SAXException, JSONException {
        return this.allAction(null, columns);
    }

    public JSONArray allAction(String folder, List<String> columns, Map<String, List<String>> dynamicColumns) throws OXException, IOException, SAXException, JSONException {
        AllSubscriptionsRequest allReq = new AllSubscriptionsRequest(folder, columns, dynamicColumns);
        allReq.setFailOnError(this.getFailOnError());
        AllSubscriptionsResponse allResp = this.getClient().execute(allReq);
        this.lastResponse = allResp;
        return allResp.getAll();
    }

    public JSONArray allAction(int folder, List<String> columns, Map<String, List<String>> dynamicColumns) throws OXException, IOException, SAXException, JSONException {
        return this.allAction(String.valueOf(folder), columns, dynamicColumns);
    }

    public void updateAction(Subscription subscription) throws OXException, IOException, SAXException, JSONException {
        UpdateSubscriptionRequest updReq = new UpdateSubscriptionRequest(subscription, this.formDescription);
        updReq.setFailOnError(this.getFailOnError());
        UpdateSubscriptionResponse updResp = this.getClient().execute(updReq);
        this.lastResponse = updResp;
    }

    public void refreshAction(int id) throws OXException, IOException, SAXException, JSONException {
        RefreshSubscriptionRequest refreshReq = new RefreshSubscriptionRequest(id, null);
        refreshReq.setFailOnError(this.getFailOnError());
        RefreshSubscriptionResponse refreshResponse = this.getClient().execute(refreshReq);
        this.lastResponse = refreshResponse;
    }

    public void cleanUp() throws OXException, IOException, SAXException, JSONException {
        if (this.createdItems.size() > 0) {
            this.deleteAction(this.createdItems);
        }
    }
}

