/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session.actions;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.session.LoginTools;
import com.openexchange.ajax.session.actions.AbstractRequest;
import com.openexchange.ajax.session.actions.FormLoginParser;
import com.openexchange.ajax.session.actions.FormLoginResponse;
import java.util.ArrayList;

public class FormLoginRequest
extends AbstractRequest<FormLoginResponse> {
    private boolean cookiesNeeded = true;

    public FormLoginRequest(String login, String password, String authId, String client, String version, boolean autologin) {
        super(FormLoginRequest.createParameter(login, password, authId, client, version, autologin));
    }

    private static AJAXRequest.Parameter[] createParameter(String login, String password, String authId, String client, String version, boolean autologin) {
        ArrayList<AJAXRequest.Parameter> retval = new ArrayList<AJAXRequest.Parameter>();
        retval.add(new AJAXRequest.URLParameter("action", "formlogin"));
        if (null != authId) {
            retval.add(new AJAXRequest.URLParameter("authId", authId));
        }
        retval.add(new AJAXRequest.FieldParameter("login", login));
        retval.add(new AJAXRequest.FieldParameter("password", password));
        retval.add(new AJAXRequest.FieldParameter("client", client));
        retval.add(new AJAXRequest.FieldParameter("version", version));
        retval.add(new AJAXRequest.FieldParameter("autologin", Boolean.toString(autologin)));
        return retval.toArray(new AJAXRequest.Parameter[retval.size()]);
    }

    public FormLoginRequest(String login, String password, String authId) {
        this(login, password, authId, AJAXClient.class.getName(), "7.4.2", true);
    }

    public FormLoginRequest(String login, String password) {
        this(login, password, LoginTools.generateAuthId());
    }

    public FormLoginParser getParser() {
        return new FormLoginParser(this.cookiesNeeded);
    }

    public boolean isCookiesNeeded() {
        return this.cookiesNeeded;
    }

    public void setCookiesNeeded(boolean cookiesNeeded) {
        this.cookiesNeeded = cookiesNeeded;
    }
}

