/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.session.actions.FormLoginRequest;
import com.openexchange.ajax.session.actions.FormLoginResponse;
import com.openexchange.ajax.session.actions.StoreRequest;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.java.Strings;

public class Bug36484Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private String login;
    private String password;

    public Bug36484Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        AJAXConfig.init();
        this.login = AJAXConfig.getProperty(AJAXConfig.Property.LOGIN) + "@" + AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        this.password = AJAXConfig.getProperty(AJAXConfig.Property.PASSWORD);
        this.client = new AJAXClient(new AJAXSession(), true);
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.client && !Strings.isEmpty((String)this.client.getSession().getId())) {
            this.client.logout();
        }
        super.tearDown();
    }

    public void testAutoFormLoginWithChangedIP() throws Exception {
        FormLoginResponse loginResponse = this.client.execute(new FormLoginRequest(this.login, this.password));
        String firstSessionID = loginResponse.getSessionId();
        Bug36484Test.assertNotNull((String)"No session ID", (Object)firstSessionID);
        this.client.getSession().setId(firstSessionID);
        this.client.execute(new StoreRequest(firstSessionID));
        ChangedIPFormLoginRequest secondLoginRequest = new ChangedIPFormLoginRequest(this.login, this.password, "53.246.23.4");
        secondLoginRequest.setCookiesNeeded(false);
        FormLoginResponse secondLoginResponse = this.client.execute(secondLoginRequest);
        String secondSessionID = secondLoginResponse.getSessionId();
        Bug36484Test.assertFalse((String)"Same session ID", (boolean)firstSessionID.equals(secondSessionID));
        this.client.getSession().setId(secondSessionID);
    }

    private static final class ChangedIPFormLoginRequest
    extends FormLoginRequest {
        private final String fakedRemoteIP;

        public ChangedIPFormLoginRequest(String login, String password, String fakedRemoteIP) {
            super(login, password);
            this.fakedRemoteIP = fakedRemoteIP;
        }

        @Override
        public Header[] getHeaders() {
            return new Header[]{new Header.SimpleHeader("X-OX-Test-Fake-Remote-IP", this.fakedRemoteIP)};
        }
    }
}

